package HashData::Color::CMYK::ToutesLesCouleursCom::Yellow;

use strict;
use Role::Tiny::With;
with 'HashDataRole::Source::LinesInDATA';
#with 'Role::TinyCommons::Collection::FindItem::Iterator';         # add find_item() (has_item already added above)
#with 'Role::TinyCommons::Collection::PickItems::RandomSeekLines'; # add pick_items() that uses binary search

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'HashData-Color-CMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

# STATS

1;
# ABSTRACT: Yellow CMYK color names (from ToutesLesCouleursCom)

=pod

=encoding UTF-8

=head1 NAME

HashData::Color::CMYK::ToutesLesCouleursCom::Yellow - Yellow CMYK color names (from ToutesLesCouleursCom)

=head1 VERSION

This document describes version 0.001 of HashData::Color::CMYK::ToutesLesCouleursCom::Yellow (from Perl distribution HashData-Color-CMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

CMKY value are in this format: I<C>,I<M>,I<Y>,I<K>. Where each C/M/Y/K value is
an integer from 0 to 100.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/HashData-Color-CMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-HashData-Color-CMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Source: L<https://www.toutes-les-couleurs.com/en/CMYK-color-code.php>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=HashData-Color-CMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
yellow:0,0,100,0
amber:0,19,100,6
aurore:0,20,62,0
butter:0,5,55,6
fees butter:0,4,45,0
wheat:0,8,79,9
blonde:0,17,49,11
golden button:0,13,93,1
bulle:0,11,41,7
goose caca:0,0,94,20
chamois:0,8,41,18
champagne:0,4,27,2
chrome:7,0,95,0
chrome:0,0,98,0
lemon:3,0,76,0
fauve:0,54,95,32
flave:0,0,34,10
sulfur flower:0,0,58,0
gamboge:0,35,94,6
yellow aureolin:0,12,72,6
yellow banana:0,13,97,18
chickadee:4,0,95,6
yellow chartreuse:13,0,100,0
cobalt yellow:0,6,100,0
naples yellow:0,6,26,0
golden yellow:0,10,97,6
imperial yellow:0,11,79,0
yellow mimosa:0,2,57,0
yellow mustard:4,0,100,19
yellow nankin:0,9,57,3
yellow olive:0,0,100,50
yellow straw:0,11,72,0
yellow chick:0,8,62,3
corn:0,13,54,0
march:0,12,65,7
putty:0,1,19,30
honey:0,18,95,15
yellow ocher:0,22,82,13
red ochre:0,31,58,13
or:0,18,94,0
orpiment:0,17,89,1
camel hair:0,34,81,29
cow tail 1:0,8,43,24
cow tail 2:0,10,31,34
sand:0,8,25,12
safran:0,12,91,5
sulfur:0,0,58,0
topaz:0,6,54,2
vanilla:0,8,32,12
venetian:0,27,64,9
