#!/usr/bin/perl
# based on fl4.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok(!$frame->has_crc, "frame doesn't have CRC");
	is($frame->bitrate, 32, "bitrate");
	is($frame->sample, 32000, "sample rate");
	is($frame->channels, 3, "channels");
	ok($frame->mono, "frame is mono");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
b             2jUUUUUUKVWTI              1/8ӀS?i[40v%,dt0              <Ŗq5>9z#U(ΣX:;t7@              ڌ#s-s]nB0[!              CډXa_ebѢaڑ`%_ڥ___ s              MoFV[ST\ZTSZ|VڐX^X2Wv s             R|yQIb
b]m`I`A_____ '              _w
^ڒN2MU=Tڮ\-[[c[ B             =z-t
c-Zm\M_\Q_]^]Y^S            UAetTb`]`d___5__X0            M5ima^a^]\a[)Z1Y9X9WW B            @@mR-_ma_-^
\ڟi\^]8 d            M_FQx]R[ڷUhڼXWڀX4WW   @           P`RYq^P_ڭ]D\[@ZZjY   C           S}ڗma7ZgZG]G_ڦ^g^ڧ_^\_     u           =;UXЍsqڽ23              U.MکM,/	!ګ*!کf)Iک)   @          H
I
J%kl1l;,kkk     T          MOMrbvjnTJYk!>K     $          MQڡۭڤm/.,q2
1گ/  0         5_]L
KM[ZiY9XtWWW    C         9ڮڨݭYڭ).٩-NJ,4      D         #{KdڳjqOnpooo$o&      @        MKmoooonmm7l>k       S        a'@g׏mlxNnhlڗuLˎ    !   3        5ڸm	($嶥ڥA9ڵ٥ڵ      0       =ڪݨڪaڦ.ڦڭڴ      A       U9v51fΕ,5گڮ.uگ.     D       1V\P^\T!YVWXAW             N7
4ڦ7j6%j444      0      6(eکN*+,5,53ګ        T      
mڏmljLnQiڍNj,Ukl~                UڰMں@mڵ'm&
4qTѶRڧJ`      @     5_-,ZYYYYYڙmXyWW        C     9ڡ.ڭڰU*i+        #     PUڕEJU$5UWJ[*         0    5کa,.ϝ/.-V-!,,x         B    F7-m.7.F mMڶ4r7%%8        #    T\QʼU-W2Eڛ)Y          0   5ڭډ+ڶ].ڮ,M,	ګ,        0   PZ*tUUUgʭX*          D   5WES4^A`]R[T5J]VXyW          0  Eڪ.ګݨڋ].Z+)-          0  1ڴ*Diڴ$ڴ5
ڥ1ڵ555          2  5%jF*U
W(\
i*           # 1euUxUWXUv            0 57%)N%J%ڥڶ6%ڦ:%           2 0Uk"aUF[ZEک*UT            # DPJUP,UVr%Vj]* 
