use strict;
use warnings;
use Test::More tests => 68;
use Digest::Hamsi qw(hamsi_512 hamsi_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Hamsi->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            hamsi_512_hex($data), $digest,
            "hamsi_512_hex: $len bits of $msg"
        );
        ok(
            hamsi_512($data) eq pack('H*', $digest),
            "hamsi_512: $len bits of $msg"
        );
    }

    my $md = Digest::Hamsi->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|5CD7436A91E27FC809D7015C3407540633DAB391127113CE6BA360F0C1E35F404510834A551610D6E871E75651EA381A8BA628AF1DCF2B2BE13AF2EB6247290F
00|96BCD4BA931F70FA951744A1DA4DE6679C88F83AB20D839803E2A4EC708D9A731CCA25D74D1874DB06A59E6D6A2C3A5DFC9818BD435EE13DD926D46F48D5FE47
C0|C6BE8A43868F20B3402B6710A611D910ACBB35437A1A75B1A07B3B6A3F7DDEB6CC57E9E39DA9FD1D12D1641EEB1530C829F768F4210D5173EDB60FDE27C0E79B
C0|4387F56C0751CFF0127B8076BC3F8A2C96A9B7049895E975F74F421E07B1C27D4AF319567EC0C8BAD420770A89CC8C3EEAC664164708B84C850857C1A411871A
80|60B5F71FE44B4ED436FCBB1E9F77A6618E228192C8047BE55472B8FEF76AEB861B99684839FA202F4FAA9F2AD1CB8E3E9BAA31F1843AC92D88C6B16C531559A5
48|34F0420DF059AD1472D5A543A426388C9585811E8CF05D0793D152A294F15FA49304EFAE94D27F50D3E316DE0E01366767ED08CC3DBF70442AB18A59E219F472
50|2F4AE104C241C4BCBD9AAFE411252E68947DA5DD62CCC32758AFA217056F605F64BAFEF7452D3DAE21D3CBEEB5FA833E846403D16BFEEDE27EDB593BA2CC05C8
98|64B7C89F58B58556C120DADDB49FB9C10738A882AE5B068E2014235E0AD6D8B5502E4DE7DB67DDBD0A64BD591DB10B05ECCAD2C597FC58515D9AC2437D94D920
CC|7DA1BE62A813A8E24D200671CFFB1D0BE79D2BC176FF0B163B11EDED2414EF66261FF52C745383442BC7F1884D5166F26F41D335FC2D2FDB2F93B24B8D079265
9800|82329158B65CA802A1F70FCDD58D76B2070D870107300B5D478E686B312654F18EDDDDF525366BE5D1D8E8D5024112F9BF03AA2ABC716486C78A683ACE3932DB
9D40|60C48A67DE1911C9FE8179333457AAF5894A809642267E93DE3F82A7B3134A67AAFA7096334878DD64C2AA6A1BB0E803AD6A7638AA7E40577B6DF1325C582AFD
AA80|1F6DFD8B27ABD939E7CCEA8D26C9884128CDC9917AAE4BFCDE853DD0238E4813833598C6DD3DC99DB3D118D4FE1539B985EC277C9D481B90BE2310307FA52876
9830|DEC52D08B28E10C6507BB7029DC441298C5EC40EB01A5A6A3D46A7B637CA8FF3CC44E99D708139CF55F4B1C27AE6728ED3F925036738CDAF031847A8284FAC9A
5030|F234CA5A73A58CF3602EE74A9F440E52F9F1802F07869A78E125D996142FA547FC33BCC3F8DEE75C8FFF48AB1B7C59B0CBC92C5FA1F6D4952A3A4CB146894FDE
4D24|31051C72461700FA1067CF691610E901D1ACAD2330BD4B05609F1FA2C891DAB60090F9522B68F4BFB0BB04D26CE8E60567C299650B8F8A2D60D13D19480827E8
CBDE|F19EE59A933F19D73A2527A99D834570FA1895471359B5DB39C23C205637D8149EE819FA8112126FB6A2C729B6D3495242E00D05B2FC8F7F717251790FAC9E06
41FB|3253D2DB0D57862D6DEEC1033F27E373D3BECBAB7FA74C9B3EC1D041BBCA8978C19E34E3E726A7C163C7D6A996897A5DB80B21B385C47E8E3A3AEE6023388CF2
4FF400|9EBAED3A5F4058C087A53888A5F5DD878BEBAFCCEC593F163F3FB37589046688FE83916C82D0F9ABFBD6DF54D28E6F0F1B8893A692C1E1669C49BF49663C0E06
FD0440|914B3CC3C495484CF6784EEF1C6B55BDA859A557ABD706F7C2AC0EC0D0FCA4E6D0FB1DEA0294B51923C58C7CF48D0A29610C3FCECC541A4227E4D57EE70A25EB
424D00|A6F265190C9C601D18460B7B23796300D85F91697931DD7D7288C4D087098D142E375A20561684DB1C71A6A23AA5C7A7FF8310B136F88E1CDE867AD2042D26FE
3FDEE0|B78D7F0018245E5ED6840D8B02921A78E2CD6F64EE1334D863B4E6CAB58992101FF5D9FA35C76BC7EC6C18F7CD410BA187BFB9E39DEDAF0F7F7C25100965912B
335768|087247DBFC20D8CADDFAFEBF69755F43B42F07DBA4C9F2FEC7771765423BB79D06A20AA2C21C65596F68EB29357779DE1C72F0520C7C45FF0CC138EA52452732
051E7C|9BD8FC56437B142AF920426C39706E458F6240A123E055716858CAD3D87E58D1260E24E4C2EBA139CACCDC58D77D85584F1ABC92865C1079AC3C9E13C96F247E
717F8C|3D6EC60E75C9B085A9AB45C47FDB78346C08A4C4EB36019ADDB2841F785A0C83C2DB2B45638A8B3EFED130CCF245C8D1C0FE92A5B6D2B73A565EE190DDE75696
1F877C|AF015A97B6996ED048F32B3A6C209E6A2DAEACD4F61EB62EAA31C68328EE5790B0681245EBE1ECEC4C0DD7F9008672D28A0424406998EC02518F023B3C27DCDE
EB35CF80|A722C65BD30C39D2D096FA08C1D04E9E533C193D5F0AE5D593FF35373C24AA42F0A76E82393AD3EAD9E3D704DAC470E929F6C3445C1DC9C66FA4D5F5D9ABE802
B406C480|46C913680A4D2764388FD829F437F63779198D39E40F61506590D647BA624B2397C4306A3A6FE2F9D9F1057197884EE44808E025B56120C2B4D24D1692F2F0CC
CEE88040|DDBE979AF56507538E09871DCD9C8093A058E5D80E3AD2647DA7B0B2EAD46B31AF46137F1D287C832C46BC52EFD114DF20C722C8964E4D195CF46EFA06396B81
C584DB70|1B555C8CED6C6C03398E62A7DB25FF4E23856129B8EC05D60C2396CEC68DCE6AA988A2D3CD301F01E4F03A9083FF0E34C3AFC42630C51807837FE95DDBED813B
53587BC8|A8FA0F75BFA83F724E31BD337A3BB648F11BEE5670458288A23F715D4449CB565083F287C9601CB9A8DE78F2BDF30FFC0F3790DF6906BF44260B734BDC81F832
69A305B0|46719579805F1A0F13CADA7D35873C36EF0A1A68AEF30CCE7EB808F3F318D59955DAADB6E231C3F30B8F531FD581A3221574BD8EF7E8D7CECBF32FA18713BE89
C9375ECE|DACE5F2079D2589D1813EEAE533FF9E3436E015CBE641401814E14A3400C577BBEF9939A799B4B4E4E4F10C976BCEC63B7D31F16888E2E220B06E2B16CDB2625
C1ECFDFC|4BDAC806BD3111B72E91DF166102AE846E44F6B9CDFE0AAAC07DD9730D4BEBEB0860919887518DB8D1F32E32C72EFC35BBE487899CC5FE3388CAA8CE096975E2
8D73E8A280|34C69FABC3F3E2D2D60C37FC317ECBA9B1817716194BC62F529D21DDE991B5D818A70E1B3F541AF4002112562E22191F0E166EEE47A63802656A461CEAF9056C
06F2522080|5B3F637DA70AB3F14A940A5B81CED943DC5CADAE49C1EDF2D1D624342A6CDC4F8164F7AC92DB11D517D5123DF3A7617396BE6E09A5CA57501A9B0C5DC8C5D599
3EF6C36F20|F91696D8B14B8062548DB78A15A65183794171C82C9D8B17128A680ADF136464679F47DAE78B038A76FE45D29F5EB57BAE06A595BEA98CFBEE7F051CE3D0D9E7
0127A1D340|1A6269E60CB109DC97A05F43943AC1D95514EA4E2AD1AFCF41B9963F17C093D7D22DBC108A8742EDCC65236698DFA70D6DEB39640AB8EC060A0E0689313D3910
6A6AB6C210|C409EA969DA313F4315BA76EA02DABA357CF3E547CD7C590EDC9268BDB06C5E8CA67B6E28AC8659593AAE81A9C891DA90542DBECDBBE9A8BE5500790B14058EC
AF3175E160|716C7498FA014A51D3C599B137D406EDDBBA66EF36BC09C2AEB25C4E11E5EEBE3F93D2C8D6E9248829C77A7788F28F979E85DBF859B65A222C03949E72C85E75
B66609ED86|8BAA95EDFB2F48379CCB2A3D511C2F39B08893AE75492686FCD85DEECB8DC88D8B988BEFFD6C0F7A39B098B63EE8E79CCE86A4BE7C2CE3C41E77E9EE4FD1C5FF
21F134AC57|4F4AF759886EF05F2DCC0D7DCC48848E3DF89920B07A015B92176EC88A83934390DB34666CCF2D2A9762FFEB281513EA43C9884CE22E7FF07AA9D42A5C148BBC
3DC2AADFFC80|2FB4B430C43A4C68C9DB463FCB3355794454DEA6810BD07A39BF475E4AD684C8C330182243E9A34CA5ACEC3794E5E9A1AB4BE23010A56BA48E5BB341675C649A
9202736D2240|AE0C5F83AF78696D1A473AC09BF51CB2C441208BFA1863F287EF0F472CBB0EEA7E84D761F96CAB245A918870B65E9F8645B83BB503941B941BF3A690C09A5121
F219BD629820|48431BBD34596EE9AB0CFE5E54C0D19D4C96C2BE90D2851D96C81F4E26C3621981DE471A1649FA99A55B8B69E31511E078A26C36C1AC07EFC514904E34897A5D
F3511EE2C4B0|4C513E4EBC1316420AA61AE546BA529B36956F94016511DB09E81AD9BBE6C6E756800CD7B4A3A56CC01429F2172AB53C2D3A9AAB47F26F14137D841BC7D9DD30
3ECAB6BF7720|74F005071489EBB156FE70070805E103EDDFAA286677C1119759DB724291C450D9A5EE1FADB3C77664417F0B5C9DD622D63453E48C93D91781E5FAE7605D925E
CD62F688F498|E1C190DB6BFC5FE98D780D32426BE5924093384EF042C64D00334AD53A5B6E258492E071A51D823E5F82C11001299FCF2D30C428554438A916B22B0B6E0466D2
C2CBAA33A9F8|A13CFB66B7BBA54EE00F72968EAC1832E635D41B448389317ADAD6270570260FC0DEBA05D93816B8BFD48B2F190261D0C88947511F30B7AD24D8FB6F8279DCB5
C6F50BB74E29|BD2C43D9EB58C0BAE3095EC2A570BBCDE5C369DD7C9E71C338C5B95187FFBE317D67A680243E998FC226A8BBF5CBA9AE369C4BD415870A7A176D707F0BF444B2
79F1B4CCC62A00|B7B901A87D1DC32A8EC13F0C25CBEBF0A6C50B28864CE01FECB966747694205EBF879B41BFD2577E560512759DC43EEE70685E505264DA7B86A7884AE5E0004F
