#!/usr/bin/perl

package eBay::API::XML::Call::GetVeROReportStatus::GetVeROReportStatusRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetVeROReportStatusRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetVeROReportStatus::GetVeROReportStatusRequestType

=head1 DESCRIPTION

Retrieves status information about VeRO reported items you have submitted. You 
can receive the status of individual items you have reported or, by specifying 
VeROReportPacketID, you can retrieve status for all items reported with a given 
VeROReportItems request. You can also retrieve items that were reported during a 
given time period. If no input parameters are specified, status is returned on all 
items you have reported in the last two years.
You must be a member of the Verified Rights Owner (VeRO) Program to use this 
call.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetVeROReportStatus::GetVeROReportStatusRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::PaginationType;


my @gaProperties = ( [ 'IncludeReportedItemDetails', 'xs:boolean', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
	, [ 'TimeFrom', 'xs:dateTime', '', '', '' ]
	, [ 'TimeTo', 'xs:dateTime', '', '', '' ]
	, [ 'VeROReportPacketID', 'xs:long', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setIncludeReportedItemDetails()

Set to true to return reported item details when you specify VeROReportPacketID in the request.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeReportedItemDetails {
  my $self = shift;
  $self->{'IncludeReportedItemDetails'} = shift
}

=head2 isIncludeReportedItemDetails()

#    Returns: 'xs:boolean'

=cut

sub isIncludeReportedItemDetails {
  my $self = shift;
  return $self->{'IncludeReportedItemDetails'};
}


=head2 setItemID()

Item ID for an item reported for alleged infringement. Applies to items 
reported with VeROReportItems or by other means (e.g., through the 
web flow).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: No
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setPagination()

Contains the data controlling the pagination of the returned values: how
many items are returned per page of data (per call) and the number of the 
page to return with the current call.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}


=head2 setTimeFrom()

Limits returned items to only those that were submited on or after the 
date-time specified. If specified, TimeTo must also be specified. 
Express the date-time in the format YYYY-MM-DD HH:MM:SS, and in GMT.
(For information on how to convert between your local time zone
and GMT, see Time Values Note.) Applies to items reported with 
VeROReportItems or by other means (e.g., through the web flow).
Infringement reporting data is maintained for two years after the date of 
submission. 
This field is ignored if VeROReportPacketID or ItemID is specified.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setTimeFrom {
  my $self = shift;
  $self->{'TimeFrom'} = shift
}

=head2 getTimeFrom()

#    Returns: 'xs:dateTime'

=cut

sub getTimeFrom {
  my $self = shift;
  return $self->{'TimeFrom'};
}


=head2 setTimeTo()

Limits returned items to only those that were submited on or before the 
date-time specified. If specified, TimeFrom must also be specified. 
Express date-time in the format YYYY-MM-DD HH:MM:SS, and in GMT.
(For information on how to convert between your local time zone
and GMT, see Time Values Note.) Applies to items reported with 
VeROReportItems or by other means (e.g., through the web flow).
Infringement reporting data is maintained for two years after the date of 
submission. 
This field is ignored if VeROReportPacketID or ItemID is specified.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setTimeTo {
  my $self = shift;
  $self->{'TimeTo'} = shift
}

=head2 getTimeTo()

#    Returns: 'xs:dateTime'

=cut

sub getTimeTo {
  my $self = shift;
  return $self->{'TimeTo'};
}


=head2 setVeROReportPacketID()

Packet identifier associated with the reported items for which you want to 
retrieve status. By default, reported item details are not returned when 
you specify the packet ID in the request. Applies only to items reported 
with VeROReportItems.

Max: Default: Min: 
  RequiredInput: No
#    Argument: 'xs:long'

=cut

sub setVeROReportPacketID {
  my $self = shift;
  $self->{'VeROReportPacketID'} = shift
}

=head2 getVeROReportPacketID()

#    Returns: 'xs:long'

=cut

sub getVeROReportPacketID {
  my $self = shift;
  return $self->{'VeROReportPacketID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
