#!/usr/bin/perl

package eBay::API::XML::Call::AddDispute;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddDispute.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::AddDispute

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::AddDispute inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::AddDispute::AddDisputeRequestType;
use eBay::API::XML::Call::AddDispute::AddDisputeResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'AddDispute';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::AddDispute::AddDisputeRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::AddDispute::AddDisputeResponseType';
}

#
# input properties
#

=head2 setDisputeExplanation()

An explanation of the dispute that supplements the
DisputeReason. The allowed value depends on the value of
DisputeReason.

  RequiredInput: Yes
#    Argument: 'ns:DisputeExplanationCodeType'

=cut
       
sub setDisputeExplanation {
   my $self   = shift;
   my $sDisputeExplanation = shift;
   $self->getRequestDataType()->setDisputeExplanation($sDisputeExplanation);
}

=head2 setDisputeReason()

The top-level reason for the Unpaid Item Dispute.
DisputeReasonCodeType has several possible values. However, only
BuyerHasNotPaid and TransactionMutuallyCanceled apply to
AddDispute--you can only use AddDisputeCall to create Unpaid
Item disputes.

  RequiredInput: Yes
#    Argument: 'ns:DisputeReasonCodeType'

=cut
       
sub setDisputeReason {
   my $self   = shift;
   my $sDisputeReason = shift;
   $self->getRequestDataType()->setDisputeReason($sDisputeReason);
}

=head2 setItemID()

The eBay ID of the item in dispute, an item which has been
sold but not yet paid for.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setTransactionID()

The eBay ID of a transaction, created when the buyer committed
to purchasing the item. A transaction ID is unique to the item
but not across the entire eBay site. The transaction ID must be
combined with an item ID to uniquely identify an item.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#

=head2 getDisputeID()

The unique identifier of the Unpaid Item dispute.

  Returned: Always
#    Returns: 'ns:DisputeIDType'

=cut
       
sub getDisputeID {
   my $self = shift;
   return $self->getResponseDataType()->getDisputeID();
}





1;   
