#!perl

use strict;
use warnings;

use Test::More tests => 1840;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $int_str, $frc_str) = split /:/;

    note(qq|\n\$x = Math::BigFloat -> new("$x_str");|,
         qq| (\$i, \$f) = \$x -> dparts();\n\n|);

    {
        my $x = Math::BigFloat -> new($x_str);
        my ($int_got, $frc_got) = $x -> dparts();

        isa_ok($int_got, "Math::BigFloat");
        isa_ok($frc_got, "Math::BigFloat");

        is($int_got, $int_str, "value of integer part");
        is($frc_got, $frc_str, "value of fraction part");
        is($x,       $x_str,   "input is unmodified");
    }

    note(qq|\n\$x = Math::BigFloat -> new("$x_str");|,
         qq| \$i = \$x -> dparts();\n\n|);

    {
        my $x = Math::BigFloat -> new($x_str);
        my $int_got = $x -> dparts();

        isa_ok($int_got, "Math::BigFloat");

        is($int_got, $int_str, "value of integer part");
        is($x,       $x_str,   "input is unmodified");
    }

}

__DATA__

NaN:NaN:0

inf:inf:0
-inf:-inf:0

0:0:0

# positive numbers

0.000000000001:0:0.000000000001
0.00000000001:0:0.00000000001
0.0000000001:0:0.0000000001
0.000000001:0:0.000000001
0.00000001:0:0.00000001
0.0000001:0:0.0000001
0.000001:0:0.000001
0.00001:0:0.00001
0.0001:0:0.0001
0.001:0:0.001
0.01:0:0.01
0.1:0:0.1
1:1:0
10:10:0
100:100:0
1000:1000:0
10000:10000:0
100000:100000:0
1000000:1000000:0
10000000:10000000:0
100000000:100000000:0
1000000000:1000000000:0
10000000000:10000000000:0
100000000000:100000000000:0
1000000000000:1000000000000:0

0.0000000000012:0:0.0000000000012
0.000000000012:0:0.000000000012
0.00000000012:0:0.00000000012
0.0000000012:0:0.0000000012
0.000000012:0:0.000000012
0.00000012:0:0.00000012
0.0000012:0:0.0000012
0.000012:0:0.000012
0.00012:0:0.00012
0.0012:0:0.0012
0.012:0:0.012
0.12:0:0.12
1.2:1:0.2
12:12:0
120:120:0
1200:1200:0
12000:12000:0
120000:120000:0
1200000:1200000:0
12000000:12000000:0
120000000:120000000:0
1200000000:1200000000:0
12000000000:12000000000:0
120000000000:120000000000:0
1200000000000:1200000000000:0

0.00000000000123:0:0.00000000000123
0.0000000000123:0:0.0000000000123
0.000000000123:0:0.000000000123
0.00000000123:0:0.00000000123
0.0000000123:0:0.0000000123
0.000000123:0:0.000000123
0.00000123:0:0.00000123
0.0000123:0:0.0000123
0.000123:0:0.000123
0.00123:0:0.00123
0.0123:0:0.0123
0.123:0:0.123
1.23:1:0.23
12.3:12:0.3
123:123:0
1230:1230:0
12300:12300:0
123000:123000:0
1230000:1230000:0
12300000:12300000:0
123000000:123000000:0
1230000000:1230000000:0
12300000000:12300000000:0
123000000000:123000000000:0
1230000000000:1230000000000:0

0.000000000001234:0:0.000000000001234
0.00000000001234:0:0.00000000001234
0.0000000001234:0:0.0000000001234
0.000000001234:0:0.000000001234
0.00000001234:0:0.00000001234
0.0000001234:0:0.0000001234
0.000001234:0:0.000001234
0.00001234:0:0.00001234
0.0001234:0:0.0001234
0.001234:0:0.001234
0.01234:0:0.01234
0.1234:0:0.1234
1.234:1:0.234
12.34:12:0.34
123.4:123:0.4
1234:1234:0
12340:12340:0
123400:123400:0
1234000:1234000:0
12340000:12340000:0
123400000:123400000:0
1234000000:1234000000:0
12340000000:12340000000:0
123400000000:123400000000:0
1234000000000:1234000000000:0

0.000003141592:0:0.000003141592
0.00003141592:0:0.00003141592
0.0003141592:0:0.0003141592
0.003141592:0:0.003141592
0.03141592:0:0.03141592
0.3141592:0:0.3141592
3.141592:3:0.141592
31.41592:31:0.41592
314.1592:314:0.1592
3141.592:3141:0.592
31415.92:31415:0.92
314159.2:314159:0.2
3141592:3141592:0

# negative numbers

-0.000000000001:0:-0.000000000001
-0.00000000001:0:-0.00000000001
-0.0000000001:0:-0.0000000001
-0.000000001:0:-0.000000001
-0.00000001:0:-0.00000001
-0.0000001:0:-0.0000001
-0.000001:0:-0.000001
-0.00001:0:-0.00001
-0.0001:0:-0.0001
-0.001:0:-0.001
-0.01:0:-0.01
-0.1:0:-0.1
-1:-1:0
-10:-10:0
-100:-100:0
-1000:-1000:0
-10000:-10000:0
-100000:-100000:0
-1000000:-1000000:0
-10000000:-10000000:0
-100000000:-100000000:0
-1000000000:-1000000000:0
-10000000000:-10000000000:0
-100000000000:-100000000000:0
-1000000000000:-1000000000000:0

-0.0000000000012:0:-0.0000000000012
-0.000000000012:0:-0.000000000012
-0.00000000012:0:-0.00000000012
-0.0000000012:0:-0.0000000012
-0.000000012:0:-0.000000012
-0.00000012:0:-0.00000012
-0.0000012:0:-0.0000012
-0.000012:0:-0.000012
-0.00012:0:-0.00012
-0.0012:0:-0.0012
-0.012:0:-0.012
-0.12:0:-0.12
-1.2:-1:-0.2
-12:-12:0
-120:-120:0
-1200:-1200:0
-12000:-12000:0
-120000:-120000:0
-1200000:-1200000:0
-12000000:-12000000:0
-120000000:-120000000:0
-1200000000:-1200000000:0
-12000000000:-12000000000:0
-120000000000:-120000000000:0
-1200000000000:-1200000000000:0

-0.00000000000123:0:-0.00000000000123
-0.0000000000123:0:-0.0000000000123
-0.000000000123:0:-0.000000000123
-0.00000000123:0:-0.00000000123
-0.0000000123:0:-0.0000000123
-0.000000123:0:-0.000000123
-0.00000123:0:-0.00000123
-0.0000123:0:-0.0000123
-0.000123:0:-0.000123
-0.00123:0:-0.00123
-0.0123:0:-0.0123
-0.123:0:-0.123
-1.23:-1:-0.23
-12.3:-12:-0.3
-123:-123:0
-1230:-1230:0
-12300:-12300:0
-123000:-123000:0
-1230000:-1230000:0
-12300000:-12300000:0
-123000000:-123000000:0
-1230000000:-1230000000:0
-12300000000:-12300000000:0
-123000000000:-123000000000:0
-1230000000000:-1230000000000:0

-0.000000000001234:0:-0.000000000001234
-0.00000000001234:0:-0.00000000001234
-0.0000000001234:0:-0.0000000001234
-0.000000001234:0:-0.000000001234
-0.00000001234:0:-0.00000001234
-0.0000001234:0:-0.0000001234
-0.000001234:0:-0.000001234
-0.00001234:0:-0.00001234
-0.0001234:0:-0.0001234
-0.001234:0:-0.001234
-0.01234:0:-0.01234
-0.1234:0:-0.1234
-1.234:-1:-0.234
-12.34:-12:-0.34
-123.4:-123:-0.4
-1234:-1234:0
-12340:-12340:0
-123400:-123400:0
-1234000:-1234000:0
-12340000:-12340000:0
-123400000:-123400000:0
-1234000000:-1234000000:0
-12340000000:-12340000000:0
-123400000000:-123400000000:0
-1234000000000:-1234000000000:0

-0.000003141592:0:-0.000003141592
-0.00003141592:0:-0.00003141592
-0.0003141592:0:-0.0003141592
-0.003141592:0:-0.003141592
-0.03141592:0:-0.03141592
-0.3141592:0:-0.3141592
-3.141592:-3:-0.141592
-31.41592:-31:-0.41592
-314.1592:-314:-0.1592
-3141.592:-3141:-0.592
-31415.92:-31415:-0.92
-314159.2:-314159:-0.2
-3141592:-3141592:0
