
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/Eval//Context.pm
);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'Eval_Context_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#~ print "number of git revision $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

my $code = <<'EOC';
use strict ;
use warnings ;

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'Eval_Context_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#print "number of git revision: $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

sub ACTION_author_test
{
my $self = shift;
local $self->{properties}{test_files} = 'xt/author/*.t' ;
$self->SUPER::ACTION_test();
}

sub ACTION_build 
{
my $self = shift;

if($ENV{'Eval_Context_USE_GIT_VERSION_FOR_DIST'})
	{
	my ($version) = GetVersionAndRevisionFrom('lib/Eval//Context.pm') ;
	
	#~ print "Generating version module ($version)\n" ;
	
	open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;
	
	print VERSION <<EOV ;
	
	# version module automatically generated by the build system
	
	package Context::Version ;
	
	sub GetVersion {return '$version'} ;
	
	1 ;
	
	# end of generated version module
EOV
	
	close VERSION ;
	}
	
$self->SUPER::ACTION_build(@_);
}

sub ACTION_dist
{
my $self = shift;

if($ENV{'Eval_Context_USE_GIT_VERSION_FOR_DIST'})
	{
	my $have_git = $self->do_system('git --version');
	
	if($have_git)
		{
		print `git status`;
		
		if($self->do_system('git log  > git_Changes'))
			{
			use File::Copy;
			move('git_Changes', 'Changes') ;
			}
		else
			{
			print "Couldn't get git log, 'Changes' will not be generated from git log!\n" ;
			}
		}
	else
		{
		print "git not found, 'Changes' will not be generated from git log!\n" ;
		}
	}

#~ $self->ACTION_author_test() ;
#~ $self->SUPER::ACTION_test() ;

$self->SUPER::ACTION_dist();
};


EOC


my $class = Module::Build->subclass(class => 'Eval::Context', code => $code) ;

my $build = $class->new
	(
	module_name => 'Eval::Context',
	
	dist_version => GetVersionAndRevisionFrom('lib/Eval/Context.pm'),
	
	license => 'perl',
	build_requires => 
		{
		'Text::Diff' => 0,
		'Test::Block' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		'Directory::Scratch::Structured' => 0,
		'Test::Output' => 0,
		},
	requires => 
		{
		'Readonly'         => 0,
		'Data::Compare'    => 0,
		'Sub::Exporter'     => 0,
		'Package::Generator' => 0,
		'Data::TreeDumper' => 0,
		'File::Slurp' => 0,
		'Sub::Install' => 0,
		'Symbol' => 0,
		'Safe' => 2.16,
		'Data::Dumper' => 0,
		'version'    => 0.50,
		},
		
	pm_files     => \%all_modules,
	autosplit    => \@split_modules,
	
	dist_author  => 'Khemir Nadim ibn Hamouda. <nadim@khemir.net>',
	dist_abstract => 'Evalute perl code in context wrapper
',
	);
	
$build->create_build_script;
  
