/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_data_Connection({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.Ajax"],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.data.Connection</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.Ajax' rel='Ext.Ajax' class='docClass'>Ext.Ajax</a></div><h4>Files</h4><div class='dependency'><a href='source/Connection.html#Ext-data-Connection' target='_blank'>Connection.js</a></div></pre><div class='doc-contents'><p>The class encapsulates a connection to the page's originating domain, allowing requests to be made\neither to a configured URL, or to a URL specified at request time.</p>\n\n\n<p>Requests made by this class are asynchronous, and will return immediately. No data from\nthe server will be available to the statement immediately following the <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> call.\nTo process returned data, use a\n<a href=\"#request-option-success\" ext:member=\"request-option-success\" ext:cls=\"Ext.data.Connection\">success callback</a>\nin the request options object,\nor an <a href=\"#!/api/Ext.data.Connection-event-requestcomplete\" rel=\"Ext.data.Connection-event-requestcomplete\" class=\"docClass\">event listener</a>.</p>\n\n\n<p><h3>File Uploads</h3><a href=\"#request-option-isUpload\" ext:member=\"request-option-isUpload\" ext:cls=\"Ext.data.Connection\">File uploads</a> are not performed using normal \"Ajax\" techniques, that\nis they are <b>not</b> performed using XMLHttpRequests. Instead the form is submitted in the standard\nmanner with the DOM <tt>&lt;form></tt> element temporarily modified to have its\n<a href=\"http://www.w3.org/TR/REC-html40/present/frames.html#adef-target\">target</a> set to refer\nto a dynamically generated, hidden <tt>&lt;iframe></tt> which is inserted into the document\nbut removed after the return data has been gathered.</p>\n\n\n<p>The server response is parsed by the browser to create the document for the IFRAME. If the\nserver is using JSON to send the return object, then the\n<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17\">Content-Type</a> header\nmust be set to \"text/html\" in order to tell the browser to insert the text unchanged into the document body.</p>\n\n\n<p>Characters which are significant to an HTML parser must be sent as HTML entities, so encode\n\"&lt;\" as \"&amp;lt;\", \"&amp;\" as \"&amp;amp;\" etc.</p>\n\n\n<p>The response text is retrieved from the document, and a fake XMLHttpRequest object\nis created containing a <tt>responseText</tt> property in order to conform to the\nrequirements of event handlers and callbacks.</p>\n\n\n<p>Be aware that file upload packets are sent with the content type <a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form</a>\nand some server technologies (notably JEE) may require some custom processing in order to\nretrieve parameter names and parameter values from the packet content.</p>\n\n\n<p>Also note that it's not possible to check the response code of the hidden iframe, so the success handler will ALWAYS fire.</p>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-defaultHeaders' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-cfg-defaultHeaders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-cfg-defaultHeaders' class='name expandable'>defaultHeaders</a><span> : Object</span></div><div class='description'><div class='short'>(Optional) An object containing request headers which are added\n to each request made by this object. ...</div><div class='long'><p>(Optional) An object containing request headers which are added\n to each request made by this object. (defaults to undefined)</p>\n</div></div></div><div id='cfg-extraParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-cfg-extraParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-cfg-extraParams' class='name expandable'>extraParams</a><span> : Object</span></div><div class='description'><div class='short'>(Optional) An object containing properties which are used as\nextra parameters to each request made by this object. ...</div><div class='long'><p>(Optional) An object containing properties which are used as\nextra parameters to each request made by this object. (defaults to undefined)</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-method' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-cfg-method' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-cfg-method' class='name expandable'>method</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) The default HTTP method to be used for requests. ...</div><div class='long'><p>(Optional) The default HTTP method to be used for requests.\n(defaults to undefined; if not set, but <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> params are present, POST will be used;\notherwise, GET will be used.)</p>\n</div></div></div><div id='cfg-timeout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-cfg-timeout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-cfg-timeout' class='name expandable'>timeout</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>(Optional) The timeout in milliseconds to be used for requests. ...</div><div class='long'><p>(Optional) The timeout in milliseconds to be used for requests. (defaults to 30000)</p>\n<p>Defaults to: <code>30000</code></p></div></div></div><div id='cfg-url' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-cfg-url' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-cfg-url' class='name expandable'>url</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) The default URL to be used for requests to the server. ...</div><div class='long'><p>(Optional) <p>The default URL to be used for requests to the server. Defaults to undefined.</p></p>\n\n<p>The <code>url</code> config may be a function which <i>returns</i> the URL to use for the Ajax request. The scope\n(<code><b>this</b></code> reference) of the function is the <code>scope</code> option passed to the <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> method.</p>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-autoAbort' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-property-autoAbort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-property-autoAbort' class='name expandable'>autoAbort</a><span> : Boolean</span></div><div class='description'><div class='short'>(Optional) Whether this request should abort any pending requests. ...</div><div class='long'><p>(Optional) Whether this request should abort any pending requests. (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-disableCaching' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-property-disableCaching' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-property-disableCaching' class='name expandable'>disableCaching</a><span> : Boolean</span></div><div class='description'><div class='short'>(Optional) True to add a unique cache-buster param to GET requests. ...</div><div class='long'><p>(Optional) True to add a unique cache-buster param to GET requests. (defaults to true)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-disableCachingParam' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-property-disableCachingParam' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-property-disableCachingParam' class='name expandable'>disableCachingParam</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>(Optional) Change the parameter which is sent went disabling caching\nthrough a cache buster. ...</div><div class='long'><p>(Optional) Change the parameter which is sent went disabling caching\nthrough a cache buster. Defaults to '_dc'</p>\n<p>Defaults to: <code>'_dc'</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.Connection-method-constructor' class='name expandable'>Ext.data.Connection</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.data.Connection\" rel=\"Ext.data.Connection\" class=\"docClass\">Ext.data.Connection</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>a configuration object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Connection\" rel=\"Ext.data.Connection\" class=\"docClass\">Ext.data.Connection</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-abort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-method-abort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-method-abort' class='name expandable'>abort</a>( <span class='pre'>[transactionId]</span> )</div><div class='description'><div class='short'>Aborts any outstanding request. ...</div><div class='long'><p>Aborts any outstanding request.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>transactionId</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>defaults to the last transaction</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-isLoading' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-method-isLoading' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-method-isLoading' class='name expandable'>isLoading</a>( <span class='pre'>[transactionId]</span> ) : Boolean</div><div class='description'><div class='short'>Determine whether this object has a request outstanding. ...</div><div class='long'><p>Determine whether this object has a request outstanding.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>transactionId</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>defaults to the last transaction</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if there is an outstanding request.</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-request' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-method-request' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-method-request' class='name expandable'>request</a>( <span class='pre'>options</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Sends an HTTP request to a remote server. ...</div><div class='long'><p>Sends an HTTP request to a remote server.</p>\n\n\n<p><b>Important:</b> Ajax server requests are asynchronous, and this call will\nreturn before the response has been received. Process any returned data\nin a callback function.</p>\n\n\n<pre><code><a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a>({\n   url: 'ajax_demo/sample.json',\n   success: function(response, opts) {\n      var obj = <a href=\"#!/api/Ext-method-decode\" rel=\"Ext-method-decode\" class=\"docClass\">Ext.decode</a>(response.responseText);\n      console.dir(obj);\n   },\n   failure: function(response, opts) {\n      console.log('server-side failure with status code ' + response.status);\n   }\n});\n</code></pre>\n\n\n<p>To execute a callback function in the correct scope, use the <tt>scope</tt> option.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>An object which may contain the following properties:<ul>\n<li><b>url</b> : String/Function (Optional)<div class=\"sub-desc\">The URL to\nwhich to send the request, or a function to call which returns a URL string. The scope of the\nfunction is specified by the <tt>scope</tt> option. Defaults to the configured\n<tt><a href=\"#!/api/Ext.data.Connection-cfg-url\" rel=\"Ext.data.Connection-cfg-url\" class=\"docClass\">url</a></tt>.</div></li>\n<li><b>params</b> : Object/String/Function (Optional)<div class=\"sub-desc\">\nAn object containing properties which are used as parameters to the\nrequest, a url encoded string or a function to call to get either. The scope of the function\nis specified by the <tt>scope</tt> option.</div></li>\n<li><b>method</b> : String (Optional)<div class=\"sub-desc\">The HTTP method to use\nfor the request. Defaults to the configured method, or if no method was configured,\n\"GET\" if no parameters are being sent, and \"POST\" if parameters are being sent.  Note that\nthe method name is case-sensitive and should be all caps.</div></li>\n<li><b>callback</b> : Function (Optional)<div class=\"sub-desc\">The\nfunction to be called upon receipt of the HTTP response. The callback is\ncalled regardless of success or failure and is passed the following\nparameters:<ul>\n<li><b>options</b> : Object<div class=\"sub-desc\">The parameter to the request call.</div></li>\n<li><b>success</b> : Boolean<div class=\"sub-desc\">True if the request succeeded.</div></li>\n<li><b>response</b> : Object<div class=\"sub-desc\">The XMLHttpRequest object containing the response data.\nSee <a href=\"http://www.w3.org/TR/XMLHttpRequest/\">http://www.w3.org/TR/XMLHttpRequest/</a> for details about\naccessing elements of the response.</div></li>\n</ul></div></li>\n<li><a id=\"request-option-success\"></a><b>success</b> : Function (Optional)<div class=\"sub-desc\">The function\nto be called upon success of the request. The callback is passed the following\nparameters:<ul>\n<li><b>response</b> : Object<div class=\"sub-desc\">The XMLHttpRequest object containing the response data.</div></li>\n<li><b>options</b> : Object<div class=\"sub-desc\">The parameter to the request call.</div></li>\n</ul></div></li>\n<li><b>failure</b> : Function (Optional)<div class=\"sub-desc\">The function\nto be called upon failure of the request. The callback is passed the\nfollowing parameters:<ul>\n<li><b>response</b> : Object<div class=\"sub-desc\">The XMLHttpRequest object containing the response data.</div></li>\n<li><b>options</b> : Object<div class=\"sub-desc\">The parameter to the request call.</div></li>\n</ul></div></li>\n<li><b>scope</b> : Object (Optional)<div class=\"sub-desc\">The scope in\nwhich to execute the callbacks: The \"this\" object for the callback function. If the <tt>url</tt>, or <tt>params</tt> options were\nspecified as functions from which to draw values, then this also serves as the scope for those function calls.\nDefaults to the browser window.</div></li>\n<li><b>timeout</b> : Number (Optional)<div class=\"sub-desc\">The timeout in milliseconds to be used for this request. Defaults to 30 seconds.</div></li>\n<li><b>form</b> : Element/HTMLElement/String (Optional)<div class=\"sub-desc\">The <tt>&lt;form&gt;</tt>\nElement or the id of the <tt>&lt;form&gt;</tt> to pull parameters from.</div></li>\n<li><a id=\"request-option-isUpload\"></a><b>isUpload</b> : Boolean (Optional)<div class=\"sub-desc\"><b>Only meaningful when used\nwith the <tt>form</tt> option</b>.</p>\n\n<p>True if the form object is a file upload (will be set automatically if the form was\nconfigured with <b><tt>enctype</tt></b> \"multipart/form-data\").</p>\n\n\n<p>File uploads are not performed using normal \"Ajax\" techniques, that is they are <b>not</b>\nperformed using XMLHttpRequests. Instead the form is submitted in the standard manner with the\nDOM <tt>&lt;form></tt> element temporarily modified to have its\n<a href=\"http://www.w3.org/TR/REC-html40/present/frames.html#adef-target\">target</a> set to refer\nto a dynamically generated, hidden <tt>&lt;iframe></tt> which is inserted into the document\nbut removed after the return data has been gathered.</p>\n\n\n<p>The server response is parsed by the browser to create the document for the IFRAME. If the\nserver is using JSON to send the return object, then the\n<a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17\">Content-Type</a> header\nmust be set to \"text/html\" in order to tell the browser to insert the text unchanged into the document body.</p>\n\n\n<p>The response text is retrieved from the document, and a fake XMLHttpRequest object\nis created containing a <tt>responseText</tt> property in order to conform to the\nrequirements of event handlers and callbacks.</p>\n\n\n<p>Be aware that file upload packets are sent with the content type <a href=\"http://www.faqs.org/rfcs/rfc2388.html\">multipart/form</a>\nand some server technologies (notably JEE) may require some custom processing in order to\nretrieve parameter names and parameter values from the packet content.</p>\n\n\n<p></div></li>\n<li><b>headers</b> : Object (Optional)<div class=\"sub-desc\">Request\nheaders to set for the request.</div></li>\n<li><b>xmlData</b> : Object (Optional)<div class=\"sub-desc\">XML document\nto use for the post. Note: This will be used instead of params for the post\ndata. Any params will be appended to the URL.</div></li>\n<li><b>jsonData</b> : Object/String (Optional)<div class=\"sub-desc\">JSON\ndata to use as the post. Note: This will be used instead of params for the post\ndata. Any params will be appended to the URL.</div></li>\n<li><b>disableCaching</b> : Boolean (Optional)<div class=\"sub-desc\">True\nto add a unique cache-buster param to GET requests.</div></li>\n</ul></p></p>\n\n<p>The options object may also contain any other property which might be needed to perform\npostprocessing in a callback because it is passed to callback functions.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>transactionId The id of the server transaction. This may be used\nto cancel the request.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-beforerequest' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-event-beforerequest' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-event-beforerequest' class='name expandable'>beforerequest</a>( <span class='pre'>conn, options</span> )</div><div class='description'><div class='short'>Fires before a network request is made to retrieve a data object. ...</div><div class='long'><p>Fires before a network request is made to retrieve a data object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : Connection<div class='sub-desc'><p>This Connection object.</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The options config object passed to the <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> method.</p>\n</div></li></ul></div></div></div><div id='event-requestcomplete' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-event-requestcomplete' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-event-requestcomplete' class='name expandable'>requestcomplete</a>( <span class='pre'>conn, response, options</span> )</div><div class='description'><div class='short'>Fires if the request was successfully completed. ...</div><div class='long'><p>Fires if the request was successfully completed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : Connection<div class='sub-desc'><p>This Connection object.</p>\n</div></li><li><span class='pre'>response</span> : Object<div class='sub-desc'><p>The XHR object containing the response data.\nSee <a href=\"http://www.w3.org/TR/XMLHttpRequest/\">The XMLHttpRequest Object</a>\nfor details.</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The options config object passed to the <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> method.</p>\n</div></li></ul></div></div></div><div id='event-requestexception' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Connection'>Ext.data.Connection</span><br/><a href='source/Connection.html#Ext-data-Connection-event-requestexception' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Connection-event-requestexception' class='name expandable'>requestexception</a>( <span class='pre'>conn, response, options</span> )</div><div class='description'><div class='short'>Fires if an error HTTP status was returned from the server. ...</div><div class='long'><p>Fires if an error HTTP status was returned from the server.\nSee <a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html\">HTTP Status Code Definitions</a>\nfor details of HTTP status codes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : Connection<div class='sub-desc'><p>This Connection object.</p>\n</div></li><li><span class='pre'>response</span> : Object<div class='sub-desc'><p>The XHR object containing the response data.\nSee <a href=\"http://www.w3.org/TR/XMLHttpRequest/\">The XMLHttpRequest Object</a>\nfor details.</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>The options config object passed to the <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> method.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Connection.html#Ext-data-Connection","filename":"Connection.js"}],"linenr":11,"members":{"property":[{"tagname":"property","owner":"Ext.data.Connection","meta":{},"name":"autoAbort","id":"property-autoAbort"},{"tagname":"property","owner":"Ext.data.Connection","meta":{},"name":"disableCaching","id":"property-disableCaching"},{"tagname":"property","owner":"Ext.data.Connection","meta":{},"name":"disableCachingParam","id":"property-disableCachingParam"}],"cfg":[{"tagname":"cfg","owner":"Ext.data.Connection","meta":{},"name":"defaultHeaders","id":"cfg-defaultHeaders"},{"tagname":"cfg","owner":"Ext.data.Connection","meta":{},"name":"extraParams","id":"cfg-extraParams"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.data.Connection","meta":{},"name":"method","id":"cfg-method"},{"tagname":"cfg","owner":"Ext.data.Connection","meta":{},"name":"timeout","id":"cfg-timeout"},{"tagname":"cfg","owner":"Ext.data.Connection","meta":{},"name":"url","id":"cfg-url"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.data.Connection","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.data.Connection","meta":{},"name":"abort","id":"method-abort"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.data.Connection","meta":{},"name":"isLoading","id":"method-isLoading"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.data.Connection","meta":{},"name":"request","id":"method-request"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.data.Connection","meta":{},"name":"beforerequest","id":"event-beforerequest"},{"tagname":"event","owner":"Ext.data.Connection","meta":{},"name":"requestcomplete","id":"event-requestcomplete"},{"tagname":"event","owner":"Ext.data.Connection","meta":{},"name":"requestexception","id":"event-requestexception"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.data.Connection","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.data.Connection","mixins":[],"mixedInto":[]});