/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_Element({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.Layer"],"extends":null,"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.Layer' rel='Ext.Layer' class='docClass'>Ext.Layer</a></div><h4>Files</h4><div class='dependency'><a href='source/Element-more.html#Ext-Element' target='_blank'>Element-more.js</a></div><div class='dependency'><a href='source/Element.alignment.html#Ext-Element' target='_blank'>Element.alignment.js</a></div><div class='dependency'><a href='source/Element.dd.html#Ext-Element' target='_blank'>Element.dd.js</a></div><div class='dependency'><a href='source/Element.fx-more.html#Ext-Element' target='_blank'>Element.fx-more.js</a></div><div class='dependency'><a href='source/Element.insertion-more.html#Ext-Element' target='_blank'>Element.insertion-more.js</a></div><div class='dependency'><a href='source/Element.keys.html#Ext-Element' target='_blank'>Element.keys.js</a></div><div class='dependency'><a href='source/Element.position-more.html#Ext-Element' target='_blank'>Element.position-more.js</a></div><div class='dependency'><a href='source/Element.scroll-more.html#Ext-Element' target='_blank'>Element.scroll-more.js</a></div><div class='dependency'><a href='source/Element.style-more.html#Ext-Element' target='_blank'>Element.style-more.js</a></div><div class='dependency'><a href='source/Element.traversal-more.html#Ext-Element' target='_blank'>Element.traversal-more.js</a></div><div class='dependency'><a href='source/Element.fx.html#Ext-Element' target='_blank'>Element.fx.js</a></div><div class='dependency'><a href='source/Element.insertion.html#Ext-Element' target='_blank'>Element.insertion.js</a></div><div class='dependency'><a href='source/Element.html#Ext-Element' target='_blank'>Element.js</a></div><div class='dependency'><a href='source/Element.position.html#Ext-Element' target='_blank'>Element.position.js</a></div><div class='dependency'><a href='source/Element.scroll.html#Ext-Element' target='_blank'>Element.scroll.js</a></div><div class='dependency'><a href='source/Element.style.html#Ext-Element' target='_blank'>Element.style.js</a></div><div class='dependency'><a href='source/Element.traversal.html#Ext-Element' target='_blank'>Element.traversal.js</a></div></pre><div class='doc-contents'><p>Encapsulates a DOM element, adding simple DOM manipulation facilities, normalizing for browser differences.</p>\n\n\n<p>All instances of this class inherit the methods of <a href=\"#!/api/Ext.Fx\" rel=\"Ext.Fx\" class=\"docClass\">Ext.Fx</a> making visual effects easily available to all DOM elements.</p>\n\n\n<p>Note that the events documented in this class are not Ext events, they encapsulate browser events. To\naccess the underlying browser event, see Ext.EventObject.browserEvent. Some older\nbrowsers may not support the full range of events. Which events are supported is beyond the control of ExtJs.</p>\n\n\n<p>Usage:<br></p>\n\n<pre><code>// by id\nvar el = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"my-div\");\n\n// by DOM element reference\nvar el = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(myDivElement);\n</code></pre>\n\n\n<p><b>Animations</b><br /></p>\n\n<p>When an element is manipulated, by default there is no animation.</p>\n\n\n<pre><code>var el = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"my-div\");\n\n// no animation\nel.setWidth(100);\n</code></pre>\n\n\n<p>Many of the functions for manipulating an element have an optional \"animate\" parameter.  This\nparameter can be specified as boolean (<tt>true</tt>) for default animation effects.</p>\n\n\n<pre><code>// default animation\nel.setWidth(100, true);\n</code></pre>\n\n\n\n\n<p>To configure the effects, an object literal with animation options to use as the Element animation\nconfiguration object can also be specified. Note that the supported Element animation configuration\noptions are a subset of the <a href=\"#!/api/Ext.Fx\" rel=\"Ext.Fx\" class=\"docClass\">Ext.Fx</a> animation options specific to Fx effects.  The supported\nElement animation configuration options are:</p>\n\n\n<pre>Option    Default   Description\n--------- --------  ---------------------------------------------\n<a href=\"#!/api/Ext.Fx-cfg-duration\" rel=\"Ext.Fx-cfg-duration\" class=\"docClass\">duration</a>  .35       The duration of the animation in seconds\n<a href=\"#!/api/Ext.Fx-cfg-easing\" rel=\"Ext.Fx-cfg-easing\" class=\"docClass\">easing</a>    easeOut   The easing method\n<a href=\"#!/api/Ext.Fx-cfg-callback\" rel=\"Ext.Fx-cfg-callback\" class=\"docClass\">callback</a>  none      A function to execute when the anim completes\n<a href=\"#!/api/Ext.Fx-cfg-scope\" rel=\"Ext.Fx-cfg-scope\" class=\"docClass\">scope</a>     this      The scope (this) of the callback function\n</pre>\n\n\n\n\n<pre><code>// Element animation options object\nvar opt = {\n    <a href=\"#!/api/Ext.Fx-cfg-duration\" rel=\"Ext.Fx-cfg-duration\" class=\"docClass\">duration</a>: 1,\n    <a href=\"#!/api/Ext.Fx-cfg-easing\" rel=\"Ext.Fx-cfg-easing\" class=\"docClass\">easing</a>: 'elasticIn',\n    <a href=\"#!/api/Ext.Fx-cfg-callback\" rel=\"Ext.Fx-cfg-callback\" class=\"docClass\">callback</a>: this.foo,\n    <a href=\"#!/api/Ext.Fx-cfg-scope\" rel=\"Ext.Fx-cfg-scope\" class=\"docClass\">scope</a>: this\n};\n// animation with some options set\nel.setWidth(100, opt);\n</code></pre>\n\n\n<p>The Element animation object being used for the animation will be set on the options\nobject as \"anim\", which allows you to stop or manipulate the animation. Here is an example:</p>\n\n\n<pre><code>// using the \"anim\" property to get the Anim object\nif(opt.anim.isAnimated()){\n    opt.anim.stop();\n}\n</code></pre>\n\n\n<p>Also see the <tt><a href=\"#!/api/Ext.Element-method-animate\" rel=\"Ext.Element-method-animate\" class=\"docClass\">animate</a></tt> method for another animation technique.</p>\n\n\n<p><b> Composite (Collections of) Elements</b></p>\n\n\n<p>For working with collections of Elements, see <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></p>\n\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Properties</h3><div id='property-autoBoxAdjust' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-property-autoBoxAdjust' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-property-autoBoxAdjust' class='name expandable'>autoBoxAdjust</a><span> : Boolean</span></div><div class='description'><div class='short'>true to automatically adjust width and height settings for box-model issues (default to true) ...</div><div class='long'><p>true to automatically adjust width and height settings for box-model issues (default to true)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-defaultUnit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-property-defaultUnit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-property-defaultUnit' class='name expandable'>defaultUnit</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default unit to append to CSS values where a unit isn't provided (defaults to px). ...</div><div class='long'><p>The default unit to append to CSS values where a unit isn't provided (defaults to px).</p>\n<p>Defaults to: <code>&quot;px&quot;</code></p></div></div></div><div id='property-dom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-property-dom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-property-dom' class='name not-expandable'>dom</a><span> : HTMLElement</span></div><div class='description'><div class='short'><p>The DOM element</p>\n</div><div class='long'><p>The DOM element</p>\n</div></div></div><div id='property-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-property-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-property-id' class='name not-expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The DOM element ID</p>\n</div><div class='long'><p>The DOM element ID</p>\n</div></div></div><div id='property-originalDisplay' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-property-originalDisplay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-property-originalDisplay' class='name expandable'>originalDisplay</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The element's default display mode  (defaults to \"\") ...</div><div class='long'><p>The element's default display mode  (defaults to \"\")</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-DISPLAY' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-static-property-DISPLAY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-static-property-DISPLAY' class='name expandable'>DISPLAY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Visibility mode constant for use with setVisibilityMode. ...</div><div class='long'><p>Visibility mode constant for use with <a href=\"#!/api/Ext.Element-method-setVisibilityMode\" rel=\"Ext.Element-method-setVisibilityMode\" class=\"docClass\">setVisibilityMode</a>. Use display to hide element</p>\n</div></div></div><div id='static-property-OFFSETS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-static-property-OFFSETS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-static-property-OFFSETS' class='name expandable'>OFFSETS</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Visibility mode constant for use with setVisibilityMode. ...</div><div class='long'><p>Visibility mode constant for use with <a href=\"#!/api/Ext.Element-method-setVisibilityMode\" rel=\"Ext.Element-method-setVisibilityMode\" class=\"docClass\">setVisibilityMode</a>. Use offsets (x and y positioning offscreen)\nto hide element.</p>\n</div></div></div><div id='static-property-VISIBILITY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-static-property-VISIBILITY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-static-property-VISIBILITY' class='name expandable'>VISIBILITY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Visibility mode constant for use with setVisibilityMode. ...</div><div class='long'><p>Visibility mode constant for use with <a href=\"#!/api/Ext.Element-method-setVisibilityMode\" rel=\"Ext.Element-method-setVisibilityMode\" class=\"docClass\">setVisibilityMode</a>. Use visibility to hide element</p>\n</div></div></div><div id='static-property-visibilityCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-static-property-visibilityCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-static-property-visibilityCls' class='name expandable'>visibilityCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Defaults to 'x-hide-nosize' ...</div><div class='long'><p>Defaults to 'x-hide-nosize'</p>\n<p>Defaults to: <code>'x-hide-nosize'</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.Element-method-constructor' class='name expandable'>Ext.Element</a>( <span class='pre'>element, [forceNew]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Create a new Element directly. ...</div><div class='long'><p>Create a new Element directly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'>\n</div></li><li><span class='pre'>forceNew</span> : Boolean (optional)<div class='sub-desc'><p>By default the constructor checks to see if there is already an instance of this element in the cache and if there is it returns the same instance. This will skip that check (useful for extending this class).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-addClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addClass' class='name expandable'>addClass</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Adds one or more CSS classes to the element. ...</div><div class='long'><p>Adds one or more CSS classes to the element. Duplicate classes are automatically filtered out.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The CSS class to add, or an array of classes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addClassOnClick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-addClassOnClick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addClassOnClick' class='name expandable'>addClassOnClick</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets up event handlers to add and remove a css class when the mouse is down and then up on this element (a click effect) ...</div><div class='long'><p>Sets up event handlers to add and remove a css class when the mouse is down and then up on this element (a click effect)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addClassOnFocus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-addClassOnFocus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addClassOnFocus' class='name expandable'>addClassOnFocus</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets up event handlers to add and remove a css class when this element has the focus ...</div><div class='long'><p>Sets up event handlers to add and remove a css class when this element has the focus</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addClassOnOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-addClassOnOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addClassOnOver' class='name expandable'>addClassOnOver</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets up event handlers to add and remove a css class when the mouse is over this element ...</div><div class='long'><p>Sets up event handlers to add and remove a css class when the mouse is over this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addKeyListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.keys.html#Ext-Element-method-addKeyListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addKeyListener' class='name expandable'>addKeyListener</a>( <span class='pre'>key, fn, [scope]</span> ) : <a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a></div><div class='description'><div class='short'>Convenience method for constructing a KeyMap ...</div><div class='long'><p>Convenience method for constructing a KeyMap</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Object/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either a string with the keys to listen for, the numeric key code, array of key codes or an object with the following options:\n<code>{key: (number or array), shift: (true/false), ctrl: (true/false), alt: (true/false)}</code></p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the specified function is executed. Defaults to this Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a></span><div class='sub-desc'><p>The KeyMap created</p>\n</div></li></ul></div></div></div><div id='method-addKeyMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.keys.html#Ext-Element-method-addKeyMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addKeyMap' class='name expandable'>addKeyMap</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a></div><div class='description'><div class='short'>Creates a KeyMap for this element ...</div><div class='long'><p>Creates a KeyMap for this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The KeyMap config. See <a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a> for more details</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a></span><div class='sub-desc'><p>The KeyMap created</p>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, fn, [scope], [options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Appends an event handler to this element. ...</div><div class='long'><p>Appends an event handler to this element.  The shorthand version <a href=\"#!/api/Ext.Element-method-on\" rel=\"Ext.Element-method-on\" class=\"docClass\">on</a> is equivalent.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of event to handle.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function the event invokes. This function is passed\nthe following parameters:<ul>\n<li><b>evt</b> : EventObject<div class=\"sub-desc\">The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">EventObject</a> describing the event.</div></li>\n<li><b>el</b> : HtmlElement<div class=\"sub-desc\">The DOM element which was the target of the event.\nNote that this may be filtered by using the <tt>delegate</tt> option.</div></li>\n<li><b>o</b> : Object<div class=\"sub-desc\">The options object from the addListener call.</div></li>\n</ul></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to this Element.</b>.</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration properties.\nThis may contain any of the following properties:<ul>\n<li><b>scope</b> Object : <div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to this Element.</b></div></li>\n<li><b>delegate</b> String: <div class=\"sub-desc\">A simple selector to filter the target or look for a descendant of the target. See below for additional details.</div></li>\n<li><b>stopEvent</b> Boolean: <div class=\"sub-desc\">True to stop the event. That is stop propagation, and prevent the default action.</div></li>\n<li><b>preventDefault</b> Boolean: <div class=\"sub-desc\">True to prevent the default action</div></li>\n<li><b>stopPropagation</b> Boolean: <div class=\"sub-desc\">True to prevent event propagation</div></li>\n<li><b>normalized</b> Boolean: <div class=\"sub-desc\">False to pass a browser event to the handler function instead of an <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a></div></li>\n<li><b>target</b> <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>: <div class=\"sub-desc\">Only call the handler if the event was fired on the target Element, <i>not</i> if the event was bubbled up from a child node.</div></li>\n<li><b>delay</b> Number: <div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> Boolean: <div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> Number: <div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nIn the following examples, the shorthand form <a href=\"#!/api/Ext.Element-method-on\" rel=\"Ext.Element-method-on\" class=\"docClass\">on</a> is used rather than the more verbose\naddListener.  The two are equivalent.  Using the options argument, it is possible to combine different\ntypes of listeners:<br>\n<br>\nA delayed, one-time listener that auto stops the event and adds a custom argument (forumId) to the\noptions object. The options object is available as the third parameter in the handler function.<div style=\"margin: 5px 20px 20px;\">\nCode:\n<pre><code>el.on('click', this.onClick, this, {\n    single: true,\n    delay: 100,\n    stopEvent : true,\n    forumId: 4\n});</code></pre></p>\n\n\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.</p>\n\n\n<p>\nCode:\n<pre><code>el.on({\n    'click' : {\n        fn: this.onClick,\n        scope: this,\n        delay: 100\n    },\n    'mouseover' : {\n        fn: this.onMouseOver,\n        scope: this\n    },\n    'mouseout' : {\n        fn: this.onMouseOut,\n        scope: this\n    }\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\nCode:\n<pre><code></p>\nel.on({\n    'click' : this.onClick,\n    'mouseover' : this.onMouseOver,\n    'mouseout' : this.onMouseOut,\n    scope: this\n});\n</code></pre></p>\n\n\n<p><b>delegate</b></p>\n\n\n<p>This is a configuration option that you can pass along when registering a handler for\nan event to assist with event delegation. Event delegation is a technique that is used to\nreduce memory consumption and prevent exposure to memory-leaks. By registering an event\nfor a container element as opposed to each element within a container. By setting this\nconfiguration option to a simple selector, the target element will be filtered to look for\na descendant of the target.\nFor example:\n<pre><code>// using this markup:\n&lt;div id='elId'>\n    &lt;p id='p1'>paragraph one&lt;/p>\n    &lt;p id='p2' class='clickable'>paragraph two&lt;/p>\n    &lt;p id='p3'>paragraph three&lt;/p>\n&lt;/div>\n// utilize event delegation to registering just one handler on the container element:\nel = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>('elId');\nel.on(\n    'click',\n    function(e,t) {\n        // handle click\n        console.info(t.id); // 'p2'\n    },\n    this,\n    {\n        // filter the target element to be a descendant with the class 'clickable'\n        delegate: '.clickable'\n    }\n);\n</code></pre></p>\n\n</div></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addUnits' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-addUnits' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-addUnits' class='name expandable'>addUnits</a>( <span class='pre'>size</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Test if size has a unit, otherwise appends the default ...</div><div class='long'><p>Test if size has a unit, otherwise appends the default</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>size</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-alignTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-alignTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-alignTo' class='name expandable'>alignTo</a>( <span class='pre'>element, position, [offsets], [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Aligns this element with another element relative to the specified anchor points. ...</div><div class='long'><p>Aligns this element with another element relative to the specified anchor points. If the other element is the\ndocument it aligns it to the viewport.\nThe position parameter is optional, and can be specified in any one of the following formats:</p>\n\n<ul>\n  <li><b>Blank</b>: Defaults to aligning the element's top-left corner to the target's bottom-left corner (\"tl-bl\").</li>\n  <li><b>One anchor (deprecated)</b>: The passed anchor position is used as the target element's anchor point.\n      The element being aligned will position its top-left corner (tl) to that point.  <i>This method has been\n      deprecated in favor of the newer two anchor syntax below</i>.</li>\n  <li><b>Two anchors</b>: If two values from the table below are passed separated by a dash, the first value is used as the\n      element's anchor point, and the second value is used as the target's anchor point.</li>\n</ul>\n\n\n<p>In addition to the anchor points, the position parameter also supports the \"?\" character.  If \"?\" is passed at the end of\nthe position string, the element will attempt to align as specified, but the position will be adjusted to constrain to\nthe viewport if necessary.  Note that the element being aligned might be swapped to align to a different position than\nthat specified in order to enforce the viewport constraints.\nFollowing are all of the supported anchor positions:</p>\n\n<pre>Value  Description\n-----  -----------------------------\ntl     The top left corner (default)\nt      The center of the top edge\ntr     The top right corner\nl      The center of the left edge\nc      In the center of the element\nr      The center of the right edge\nbl     The bottom left corner\nb      The center of the bottom edge\nbr     The bottom right corner\n</pre>\n\n\n<p>Example Usage:</p>\n\n<pre><code>// align el to other-el using the default positioning (\"tl-bl\", non-constrained)\nel.alignTo(\"other-el\");\n\n// align the top left corner of el with the top right corner of other-el (constrained to viewport)\nel.alignTo(\"other-el\", \"tr?\");\n\n// align the bottom right corner of el with the center left edge of other-el\nel.alignTo(\"other-el\", \"br-l?\");\n\n// align the center of el with the bottom left corner of other-el and\n// adjust the x position by -6 pixels (and the y position by 0)\nel.alignTo(\"other-el\", \"c-bl\", [-6, 0]);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Mixed<div class='sub-desc'><p>The element to align to.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>(optional, defaults to \"tl-bl?\") The position to align to.</p>\n</div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-anchorTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-anchorTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-anchorTo' class='name expandable'>anchorTo</a>( <span class='pre'>element, position, [offsets], [animate], [monitorScroll], [callback]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Anchors an element to another element and realigns it when the window is resized. ...</div><div class='long'><p>Anchors an element to another element and realigns it when the window is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Mixed<div class='sub-desc'><p>The element to align to.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The position to align to.</p>\n</div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation or a standard Element animation config object</p>\n</div></li><li><span class='pre'>monitorScroll</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>True to monitor body scroll and reposition. If this parameter\nis a number, it is used as the buffer delay (defaults to 50ms).</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The function to call after the animation finishes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-animate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-animate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-animate' class='name expandable'>animate</a>( <span class='pre'>args, [duration], [onComplete], [easing], [animType]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Perform custom animation on this element. ...</div><div class='long'><p>Perform custom animation on this element.</p>\n\n<div><ul class=\"mdetail-params\">\n<li><u>Animation Properties</u></li>\n\n<p>The Animation Control Object enables gradual transitions for any member of an\nelement's style object that takes a numeric value including but not limited to\nthese properties:</p><div><ul class=\"mdetail-params\">\n<li><tt>bottom, top, left, right</tt></li>\n<li><tt>height, width</tt></li>\n<li><tt>margin, padding</tt></li>\n<li><tt>borderWidth</tt></li>\n<li><tt>opacity</tt></li>\n<li><tt>fontSize</tt></li>\n<li><tt>lineHeight</tt></li>\n</ul></div>\n\n\n<li><u>Animation Property Attributes</u></li>\n\n<p>Each Animation Property is a config object with optional properties:</p>\n<div><ul class=\"mdetail-params\">\n<li><tt>by</tt>*  : relative change - start at current value, change by this value</li>\n<li><tt>from</tt> : ignore current value, start from this value</li>\n<li><tt>to</tt>*  : start at current value, go to this value</li>\n<li><tt>unit</tt> : any allowable unit specification</li>\n<p>* do not specify both <tt>to</tt> and <tt>by</tt> for an animation property</p>\n</ul></div>\n\n<li><u>Animation Types</u></li>\n\n<p>The supported animation types:</p><div><ul class=\"mdetail-params\">\n<li><tt>'run'</tt> : Default\n<pre><code>var el = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>('complexEl');\nel.animate(\n    // animation control object\n    {\n        borderWidth: {to: 3, from: 0},\n        opacity: {to: .3, from: 1},\n        height: {to: 50, from: el.getHeight()},\n        width: {to: 300, from: el.getWidth()},\n        top  : {by: - 100, unit: 'px'},\n    },\n    0.35,      // animation duration\n    null,      // callback\n    'easeOut', // easing method\n    'run'      // animation type ('run','color','motion','scroll')\n);\n</code></pre>\n</li>\n<li><tt>'color'</tt>\n<p>Animates transition of background, text, or border colors.</p>\n<pre><code>el.animate(\n    // animation control object\n    {\n        color: { to: '#06e' },\n        backgroundColor: { to: '#e06' }\n    },\n    0.35,      // animation duration\n    null,      // callback\n    'easeOut', // easing method\n    'color'    // animation type ('run','color','motion','scroll')\n);\n</code></pre>\n</li>\n\n<li><tt>'motion'</tt>\n<p>Animates the motion of an element to/from specific points using optional bezier\nway points during transit.</p>\n<pre><code>el.animate(\n    // animation control object\n    {\n        borderWidth: {to: 3, from: 0},\n        opacity: {to: .3, from: 1},\n        height: {to: 50, from: el.getHeight()},\n        width: {to: 300, from: el.getWidth()},\n        top  : {by: - 100, unit: 'px'},\n        points: {\n            to: [50, 100],  // go to this point\n            control: [      // optional bezier way points\n                [ 600, 800],\n                [-100, 200]\n            ]\n        }\n    },\n    3000,      // animation duration (milliseconds!)\n    null,      // callback\n    'easeOut', // easing method\n    'motion'   // animation type ('run','color','motion','scroll')\n);\n</code></pre>\n</li>\n<li><tt>'scroll'</tt>\n<p>Animate horizontal or vertical scrolling of an overflowing page element.</p>\n<pre><code>el.animate(\n    // animation control object\n    {\n        scroll: {to: [400, 300]}\n    },\n    0.35,      // animation duration\n    null,      // callback\n    'easeOut', // easing method\n    'scroll'   // animation type ('run','color','motion','scroll')\n);\n</code></pre>\n</li>\n</ul></div>\n\n</ul></div>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>The animation control args</p>\n</div></li><li><span class='pre'>duration</span> : Float (optional)<div class='sub-desc'><p>How long the animation lasts in seconds (defaults to <tt>.35</tt>)</p>\n</div></li><li><span class='pre'>onComplete</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Function to call when animation completes</p>\n</div></li><li><span class='pre'>easing</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p><a href=\"#!/api/Ext.Fx-cfg-easing\" rel=\"Ext.Fx-cfg-easing\" class=\"docClass\">Ext.Fx.easing</a> method to use (defaults to <tt>'easeOut'</tt>)</p>\n</div></li><li><span class='pre'>animType</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p><tt>'run'</tt> is the default. Can also be <tt>'color'</tt>,\n<tt>'motion'</tt>, or <tt>'scroll'</tt></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-appendChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-appendChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-appendChild' class='name expandable'>appendChild</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Appends the passed element(s) to this element ...</div><div class='long'><p>Appends the passed element(s) to this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : String/HTMLElement/Array/Element/CompositeElement<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-appendTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-appendTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-appendTo' class='name expandable'>appendTo</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Appends this element to the passed element ...</div><div class='long'><p>Appends this element to the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The new parent element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-applyStyles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-applyStyles' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-applyStyles' class='name expandable'>applyStyles</a>( <span class='pre'>styles</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>More flexible version of setStyle for setting style properties. ...</div><div class='long'><p>More flexible version of <a href=\"#!/api/Ext.Element-method-setStyle\" rel=\"Ext.Element-method-setStyle\" class=\"docClass\">setStyle</a> for setting style properties.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>styles</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A style specification string, e.g. \"width:100px\", or object in the form {width:\"100px\"}, or\na function which returns such a specification.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-blur' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-blur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-blur' class='name expandable'>blur</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Tries to blur the element. ...</div><div class='long'><p>Tries to blur the element. Any exceptions are caught and ignored.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-boxWrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-boxWrap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-boxWrap' class='name expandable'>boxWrap</a>( <span class='pre'>[class]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Wraps the specified element with a special 9 element markup/CSS block that renders by default as\na gray container wit...</div><div class='long'><p>Wraps the specified element with a special 9 element markup/CSS block that renders by default as\na gray container with a gradient background, rounded corners and a 4-way shadow.</p>\n\n\n<p>This special markup is used throughout Ext when box wrapping elements (<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>,\n<a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a> when <tt><a href=\"#!/api/Ext.Panel-cfg-frame\" rel=\"Ext.Panel-cfg-frame\" class=\"docClass\">frame=true</a></tt>, <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>).  The markup\nis of this form:</p>\n\n\n<pre><code>    Ext.Element.boxMarkup =\n    &#39;&lt;div class=\"{0}-tl\">&lt;div class=\"{0}-tr\">&lt;div class=\"{0}-tc\">&lt;/div>&lt;/div>&lt;/div>\n     &lt;div class=\"{0}-ml\">&lt;div class=\"{0}-mr\">&lt;div class=\"{0}-mc\">&lt;/div>&lt;/div>&lt;/div>\n     &lt;div class=\"{0}-bl\">&lt;div class=\"{0}-br\">&lt;div class=\"{0}-bc\">&lt;/div>&lt;/div>&lt;/div>&#39;;\n</code></pre>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>    // Basic box wrap\n    <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"foo\").boxWrap();\n\n    // You can also add a custom class and use CSS inheritance rules to customize the box look.\n    // 'x-box-blue' is a built-in alternative -- look at the related CSS definitions as an example\n    // for how to create a custom box wrap style.\n    <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"foo\").boxWrap().addClass(\"x-box-blue\");\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>class</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A base CSS class to apply to the containing wrapper element\n(defaults to <tt>'x-box'</tt>). Note that there are a number of CSS rules that are dependent on\nthis name to make the overall effect work, so if you supply an alternate base class, make sure you\nalso supply all of the necessary rules.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The outermost wrapping element of the created box structure.</p>\n</div></li></ul></div></div></div><div id='method-center' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-center' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-center' class='name expandable'>center</a>( <span class='pre'>[centerIn]</span> )</div><div class='description'><div class='short'>Centers the Element in either the viewport, or another Element. ...</div><div class='long'><p>Centers the Element in either the viewport, or another Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>centerIn</span> : Mixed (optional)<div class='sub-desc'><p>The element in which to center the element.</p>\n</div></li></ul></div></div></div><div id='method-child' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-child' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-child' class='name expandable'>child</a>( <span class='pre'>selector, [returnDom]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Selects a single child at any depth below this element based on the passed CSS selector (the selector should not cont...</div><div class='long'><p>Selects a single child at any depth below this element based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return the DOM node instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The child <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (or DOM node if returnDom = true)</p>\n</div></li></ul></div></div></div><div id='method-clean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element-more.html#Ext-Element-method-clean' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-clean' class='name expandable'>clean</a>( <span class='pre'>[forceReclean]</span> )</div><div class='description'><div class='short'>Removes worthless text nodes ...</div><div class='long'><p>Removes worthless text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>forceReclean</span> : Boolean (optional)<div class='sub-desc'><p>By default the element\nkeeps track if it has been cleaned already so\nyou can call this over and over. However, if you update the element and\nneed to force a reclean, you can pass true.</p>\n</div></li></ul></div></div></div><div id='method-clearOpacity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-clearOpacity' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-clearOpacity' class='name expandable'>clearOpacity</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Clears any opacity settings from this element. ...</div><div class='long'><p>Clears any opacity settings from this element. Required in some cases for IE.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clearPositioning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-clearPositioning' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-clearPositioning' class='name expandable'>clearPositioning</a>( <span class='pre'>[value]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Clear positioning back to the default when the document was loaded ...</div><div class='long'><p>Clear positioning back to the default when the document was loaded</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The value to use for the left,right,top,bottom, defaults to '' (empty string). You could use 'auto'.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-clip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-clip' class='name expandable'>clip</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Store the current overflow setting and clip overflow on the element - use unclip to remove ...</div><div class='long'><p>Store the current overflow setting and clip overflow on the element - use <tt><a href=\"#!/api/Ext.Element-method-unclip\" rel=\"Ext.Element-method-unclip\" class=\"docClass\">unclip</a></tt> to remove</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-contains' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-contains' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-contains' class='name expandable'>contains</a>( <span class='pre'>el</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this element is an ancestor of the passed element ...</div><div class='long'><p>Returns true if this element is an ancestor of the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The element to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this element is an ancestor of el, else false</p>\n</div></li></ul></div></div></div><div id='method-createChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-createChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-createChild' class='name expandable'>createChild</a>( <span class='pre'>config, [insertBefore], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates the passed DomHelper config and appends it to this element or optionally inserts it before the passed child e...</div><div class='long'><p>Creates the passed DomHelper config and appends it to this element or optionally inserts it before the passed child element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>DomHelper element config object.  If no tag is specified (e.g., {tag:'input'}) then a div will be\nautomatically generated with the specified attributes.</p>\n</div></li><li><span class='pre'>insertBefore</span> : HTMLElement (optional)<div class='sub-desc'><p>a child element of this element</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>true to return the dom node instead of creating an Element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new child element</p>\n</div></li></ul></div></div></div><div id='method-createProxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element-more.html#Ext-Element-method-createProxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-createProxy' class='name expandable'>createProxy</a>( <span class='pre'>config, [renderTo], [matchBox]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates a proxy element of this element ...</div><div class='long'><p>Creates a proxy element of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>The class name of the proxy element or a DomHelper config object</p>\n</div></li><li><span class='pre'>renderTo</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement (optional)<div class='sub-desc'><p>The element or element id to render the proxy to (defaults to document.body)</p>\n</div></li><li><span class='pre'>matchBox</span> : Boolean (optional)<div class='sub-desc'><p>True to align and size the proxy to this element now (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new proxy element</p>\n</div></li></ul></div></div></div><div id='method-createShim' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx-more.html#Ext-Element-method-createShim' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-createShim' class='name expandable'>createShim</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Creates an iframe shim for this element to keep selects and other windowed objects from\nshowing through. ...</div><div class='long'><p>Creates an iframe shim for this element to keep selects and other windowed objects from\nshowing through.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new shim element</p>\n</div></li></ul></div></div></div><div id='method-down' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-down' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-down' class='name expandable'>down</a>( <span class='pre'>selector, [returnDom]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Selects a single direct child based on the passed CSS selector (the selector should not contain an id). ...</div><div class='long'><p>Selects a single <em>direct</em> child based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return the DOM node instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The child <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (or DOM node if returnDom = true)</p>\n</div></li></ul></div></div></div><div id='method-enableDisplayMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx-more.html#Ext-Element-method-enableDisplayMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-enableDisplayMode' class='name expandable'>enableDisplayMode</a>( <span class='pre'>[display]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience method for setVisibilityMode(Element.DISPLAY) ...</div><div class='long'><p>Convenience method for setVisibilityMode(Element.DISPLAY)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>display</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>What to set display to when visible</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-findParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-findParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-findParent' class='name expandable'>findParent</a>( <span class='pre'>selector, [maxDepth], [returnEl]</span> ) : HTMLElement</div><div class='description'><div class='short'>Looks at this node and then at parent nodes for a match of the passed simple selector (e.g. ...</div><div class='long'><p>Looks at this node and then at parent nodes for a match of the passed simple selector (e.g. div.some-class or span:first-child)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/Mixed (optional)<div class='sub-desc'><p>The max depth to search as a number or element (defaults to 50 || document.body)</p>\n</div></li><li><span class='pre'>returnEl</span> : Boolean (optional)<div class='sub-desc'><p>True to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object instead of DOM node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>The matching DOM node (or null if no match was found)</p>\n</div></li></ul></div></div></div><div id='method-findParentNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-findParentNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-findParentNode' class='name expandable'>findParentNode</a>( <span class='pre'>selector, [maxDepth], [returnEl]</span> ) : HTMLElement</div><div class='description'><div class='short'>Looks at parent nodes for a match of the passed simple selector (e.g. ...</div><div class='long'><p>Looks at parent nodes for a match of the passed simple selector (e.g. div.some-class or span:first-child)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/Mixed (optional)<div class='sub-desc'><p>The max depth to</p>\n\n<pre><code>            search as a number or element (defaults to 10 || document.body)\n</code></pre>\n</div></li><li><span class='pre'>returnEl</span> : Boolean (optional)<div class='sub-desc'><p>True to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object instead of DOM node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>The matching DOM node (or null if no match was found)</p>\n</div></li></ul></div></div></div><div id='method-first' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-first' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-first' class='name expandable'>first</a>( <span class='pre'>[selector], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the first child, skipping text nodes ...</div><div class='long'><p>Gets the first child, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the next sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The first child or null</p>\n</div></li></ul></div></div></div><div id='method-fly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-fly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-fly' class='name expandable'>fly</a>( <span class='pre'>el, [named]</span> ) : Element</div><div class='description'><div class='short'>Gets the globally shared flyweight Element, with the passed node as the active element. ...</div><div class='long'><p>Gets the globally shared flyweight Element, with the passed node as the active element. Do not store a reference to this element -\nthe dom node can be overwritten by other code. Shorthand of <a href=\"#!/api/Ext.Element-method-fly\" rel=\"Ext.Element-method-fly\" class=\"docClass\">fly</a></p>\n\n\n<p>Use this to make one-time references to DOM elements which are not going to be accessed again either by\napplication code, or by Ext's classes. If accessing an element which will be processed regularly, then <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>\nwill be more appropriate to take advantage of the caching provided by the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> class.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'><p>The dom node or id</p>\n</div></li><li><span class='pre'>named</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Allows for creation of named reusable flyweights to prevent conflicts\n(e.g. internally Ext uses \"_global\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Element</span><div class='sub-desc'><p>The shared Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='method-focus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-focus' class='name expandable'>focus</a>( <span class='pre'>[defer]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Tries to focus the element. ...</div><div class='long'><p>Tries to focus the element. Any exceptions are caught and ignored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>defer</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Milliseconds to defer the focus</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-getAlignToXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-getAlignToXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getAlignToXY' class='name expandable'>getAlignToXY</a>( <span class='pre'>element, position, [offsets]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the x,y coordinates to align this element with another element. ...</div><div class='long'><p>Gets the x,y coordinates to align this element with another element. See <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">alignTo</a> for more info on the\nsupported position values.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Mixed<div class='sub-desc'><p>The element to align to.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>(optional, defaults to \"tl-bl?\") The position to align to.</p>\n</div></li><li><span class='pre'>offsets</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Offset the positioning by [x, y]</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>[x, y]</p>\n</div></li></ul></div></div></div><div id='method-getAnchorXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-getAnchorXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getAnchorXY' class='name expandable'>getAnchorXY</a>( <span class='pre'>[anchor], [local], [size]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the x,y coordinates specified by the anchor position on the element. ...</div><div class='long'><p>Gets the x,y coordinates specified by the anchor position on the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anchor</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The specified anchor position (defaults to \"c\").  See <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">alignTo</a>\nfor details on supported anchor positions.</p>\n</div></li><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>True to get the local (element top/left-relative) anchor position instead\nof page coordinates</p>\n</div></li><li><span class='pre'>size</span> : Object (optional)<div class='sub-desc'><p>An object containing the size to use for calculating anchor position\n{width: (target width), height: (target height)} (defaults to the element's current size)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>[x, y] An array containing the element's x and y coordinates</p>\n</div></li></ul></div></div></div><div id='method-getAttribute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-getAttribute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getAttribute' class='name expandable'>getAttribute</a>( <span class='pre'>name, [namespace]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the value of an attribute from the element's underlying DOM node. ...</div><div class='long'><p>Returns the value of an attribute from the element's underlying DOM node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The attribute name</p>\n</div></li><li><span class='pre'>namespace</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The namespace in which to look for the attribute</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The attribute value</p>\n</div></li></ul></div></div></div><div id='method-getAttributeNS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-getAttributeNS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getAttributeNS' class='name expandable'>getAttributeNS</a>( <span class='pre'>namespace, name</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='deprecated signature' >deprecated</strong></div><div class='description'><div class='short'>Returns the value of a namespaced attribute from the element's underlying DOM node. ...</div><div class='long'><p>Returns the value of a namespaced attribute from the element's underlying DOM node.</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        \n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The namespace in which to look for the attribute</p>\n</div></li><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The attribute name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The attribute value</p>\n</div></li></ul></div></div></div><div id='method-getBorderWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-getBorderWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getBorderWidth' class='name expandable'>getBorderWidth</a>( <span class='pre'>side</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the width of the border(s) for the specified side(s) ...</div><div class='long'><p>Gets the width of the border(s) for the specified side(s)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>side</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Can be t, l, r, b or any combination of those to add multiple values. For example,\npassing <tt>'lr'</tt> would get the border <b><u>l</u></b>eft width + the border <b><u>r</u></b>ight width.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The width of the sides passed added together</p>\n</div></li></ul></div></div></div><div id='method-getBottom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getBottom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getBottom' class='name expandable'>getBottom</a>( <span class='pre'>local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the bottom Y coordinate of the element (element Y position + element height) ...</div><div class='long'><p>Gets the bottom Y coordinate of the element (element Y position + element height)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean<div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-getBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[contentBox], [local]</span> ) : Object</div><div class='description'><div class='short'>Return an object defining the area of this Element which can be passed to setBox to\nset another Element's size/locati...</div><div class='long'><p>Return an object defining the area of this Element which can be passed to <a href=\"#!/api/Ext.Element-method-setBox\" rel=\"Ext.Element-method-setBox\" class=\"docClass\">setBox</a> to\nset another Element's size/location to match this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentBox</span> : Boolean (optional)<div class='sub-desc'><p>If true a box for the content of the element is returned.</p>\n</div></li><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page x/y.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>box An object in the format</p>\n\n<pre><code>{\n    x: &lt;Element's X position>,\n    y: &lt;Element's Y position>,\n    width: &lt;Element's width>,\n    height: &lt;Element's height>,\n    bottom: &lt;Element's lower bound>,\n    right: &lt;Element's rightmost bound>\n}\n</code></pre>\n\n\n<p>The returned object may also be addressed as an Array where index 0 contains the X position\nand index 1 contains the Y position. So the result may also be used for <a href=\"#!/api/Ext.Element-method-setXY\" rel=\"Ext.Element-method-setXY\" class=\"docClass\">setXY</a></p>\n</div></li></ul></div></div></div><div id='method-getCenterXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-getCenterXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getCenterXY' class='name expandable'>getCenterXY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Calculates the x, y to center this element on the screen ...</div><div class='long'><p>Calculates the x, y to center this element on the screen</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The x, y values [x, y]</p>\n</div></li></ul></div></div></div><div id='method-getColor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-getColor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getColor' class='name expandable'>getColor</a>( <span class='pre'>attr, defaultValue, [prefix]</span> )</div><div class='description'><div class='short'>Return the CSS color for the specified CSS attribute. ...</div><div class='long'><p>Return the CSS color for the specified CSS attribute. rgb, 3 digit (like #fff) and valid values\nare convert to standard 6 digit hex color.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attr</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The css attribute</p>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The default value to use when a valid color isn't found</p>\n</div></li><li><span class='pre'>prefix</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>defaults to #. Use an empty string when working with\ncolor anims.</p>\n</div></li></ul></div></div></div><div id='method-getComputedHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getComputedHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getComputedHeight' class='name expandable'>getComputedHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders\nwhen...</div><div class='long'><p>Returns either the offsetHeight or the height of this element based on CSS height adjusted by padding or borders\nwhen needed to simulate offsetHeight when offsets aren't available. This may not work on display:none elements\nif a height has not been set using CSS.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getComputedWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getComputedWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getComputedWidth' class='name expandable'>getComputedWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders\nwhen ne...</div><div class='long'><p>Returns either the offsetWidth or the width of this element based on CSS width adjusted by padding or borders\nwhen needed to simulate offsetWidth when offsets aren't available. This may not work on display:none elements\nif a width has not been set using CSS.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFrameWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getFrameWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getFrameWidth' class='name expandable'>getFrameWidth</a>( <span class='pre'>sides, onlyContentBox</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the sum width of the padding and borders for the passed \"sides\". ...</div><div class='long'><p>Returns the sum width of the padding and borders for the passed \"sides\". See getBorderWidth()</p>\n\n<pre><code>     for more information about the sides.\n</code></pre>\n\n<p>@param {String} sides</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sides</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>onlyContentBox</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-getHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'>[contentHeight]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the offset height of the element ...</div><div class='long'><p>Returns the offset height of the element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentHeight</span> : Boolean (optional)<div class='sub-desc'><p>true to get the height minus borders and padding</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The element's height</p>\n</div></li></ul></div></div></div><div id='method-getLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getLeft' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getLeft' class='name expandable'>getLeft</a>( <span class='pre'>local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the left X coordinate ...</div><div class='long'><p>Gets the left X coordinate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean<div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMargins' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getMargins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getMargins' class='name expandable'>getMargins</a>( <span class='pre'>[sides]</span> ) : Object/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns an object with properties top, left, right and bottom representing the margins of this element unless sides i...</div><div class='long'><p>Returns an object with properties top, left, right and bottom representing the margins of this element unless sides is passed,\nthen it returns the calculated width of the sides (see getPadding)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sides</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Any combination of l, r, t, b to get the sum of those sides</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getOffsetsTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getOffsetsTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getOffsetsTo' class='name expandable'>getOffsetsTo</a>( <span class='pre'>element</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Returns the offsets of this element from the passed element. ...</div><div class='long'><p>Returns the offsets of this element from the passed element. Both element must be part of the DOM tree and not have display:none to have page coordinates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Mixed<div class='sub-desc'><p>The element to get the offsets from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The XY page offsets (e.g. [100, -200])</p>\n</div></li></ul></div></div></div><div id='method-getPadding' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-getPadding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getPadding' class='name expandable'>getPadding</a>( <span class='pre'>side</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the width of the padding(s) for the specified side(s) ...</div><div class='long'><p>Gets the width of the padding(s) for the specified side(s)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>side</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Can be t, l, r, b or any combination of those to add multiple values. For example,\npassing <tt>'lr'</tt> would get the padding <b><u>l</u></b>eft + the padding <b><u>r</u></b>ight.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The padding of the sides passed added together</p>\n</div></li></ul></div></div></div><div id='method-getPositioning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getPositioning' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getPositioning' class='name expandable'>getPositioning</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets an object with all CSS positioning properties. ...</div><div class='long'><p>Gets an object with all CSS positioning properties. Useful along with setPostioning to get\nsnapshot before performing an update and then restoring the element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRegion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-getRegion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getRegion' class='name expandable'>getRegion</a>( <span class='pre'></span> ) : Region</div><div class='description'><div class='short'>Returns the region of the given element. ...</div><div class='long'><p>Returns the region of the given element.\nThe element must be part of the DOM tree to have a region (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Region</span><div class='sub-desc'><p>A Ext.lib.Region containing \"top, left, bottom, right\" member data.</p>\n</div></li></ul></div></div></div><div id='method-getRight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getRight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getRight' class='name expandable'>getRight</a>( <span class='pre'>local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the right X coordinate of the element (element X position + element width) ...</div><div class='long'><p>Gets the right X coordinate of the element (element X position + element width)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean<div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getScroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.scroll.html#Ext-Element-method-getScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getScroll' class='name expandable'>getScroll</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the current scroll position of the element. ...</div><div class='long'><p>Returns the current scroll position of the element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the scroll position in the format {left: (scrollLeft), top: (scrollTop)}</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getSize' class='name expandable'>getSize</a>( <span class='pre'>[contentSize]</span> ) : Object</div><div class='description'><div class='short'>Returns the size of the element. ...</div><div class='long'><p>Returns the size of the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentSize</span> : Boolean (optional)<div class='sub-desc'><p>true to get the width/size minus borders and padding</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getStyle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-getStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getStyle' class='name expandable'>getStyle</a>( <span class='pre'>property</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Normalizes currentStyle and computedStyle. ...</div><div class='long'><p>Normalizes currentStyle and computedStyle.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The style property whose value is returned.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The current value of the style property for this element.</p>\n</div></li></ul></div></div></div><div id='method-getStyleSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getStyleSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getStyleSize' class='name expandable'>getStyleSize</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the dimensions of the element available to lay content out in. ...</div><div class='long'><p>Returns the dimensions of the element available to lay content out in.<p>\n\ngetStyleSize utilizes prefers style sizing if present, otherwise it chooses the larger of offsetHeight/clientHeight and offsetWidth/clientWidth.\nTo obtain the size excluding scrollbars, use getViewSize\n\nSizing of the document body is handled at the adapter level which handles special cases for IE and strict modes, etc.\n\n</p></p></div></div></div><div id='method-getStyles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getStyles' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getStyles' class='name expandable'>getStyles</a>( <span class='pre'>style1, style2, etc</span> ) : Object</div><div class='description'><div class='short'>Returns an object with properties matching the styles requested. ...</div><div class='long'><p>Returns an object with properties matching the styles requested.\nFor example, el.getStyles('color', 'font-size', 'width') might return\n{'color': '#FFFFFF', 'font-size': '13px', 'width': '100px'}.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>style1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A style name</p>\n</div></li><li><span class='pre'>style2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A style name</p>\n</div></li><li><span class='pre'>etc</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The style object</p>\n</div></li></ul></div></div></div><div id='method-getTextWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/TextMetrics.html#Ext-Element-method-getTextWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getTextWidth' class='name expandable'>getTextWidth</a>( <span class='pre'>text, [min], [max]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the width in pixels of the passed text, or the width of the text in this Element. ...</div><div class='long'><p>Returns the width in pixels of the passed text, or the width of the text in this Element. getTextWidth</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The text to measure. Defaults to the innerHTML of the element.</p>\n</div></li><li><span class='pre'>min</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The minumum value to return.</p>\n</div></li><li><span class='pre'>max</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The maximum value to return.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The text width in pixels.</p>\n</div></li></ul></div></div></div><div id='method-getTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getTop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getTop' class='name expandable'>getTop</a>( <span class='pre'>local</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the top Y coordinate ...</div><div class='long'><p>Gets the top Y coordinate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean<div class='sub-desc'><p>True to get the local css position instead of page coordinate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getUpdater' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element-more.html#Ext-Element-method-getUpdater' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getUpdater' class='name expandable'>getUpdater</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a></div><div class='description'><div class='short'>Gets this element's Updater ...</div><div class='long'><p>Gets this element's <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Updater</a></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a></span><div class='sub-desc'><p>The Updater</p>\n</div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>asNumber</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the value of the \"value\" attribute ...</div><div class='long'><p>Returns the value of the \"value\" attribute</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>asNumber</span> : Boolean<div class='sub-desc'><p>true to parse the value as a number</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getViewSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-getViewSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getViewSize' class='name expandable'>getViewSize</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the dimensions of the element available to lay content out in. ...</div><div class='long'><p>Returns the dimensions of the element available to lay content out in.<p>\n<p>If the element (or any ancestor element) has CSS style <code>display : none</code>, the dimensions will be zero.</p>\nexample:\n<pre><code>        var vpSize = <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>().getViewSize();\n\n        // all Windows created afterwards will have a default value of 90% height and 95% width\n        Ext.Window.override({\n            width: vpSize.width * 0.9,\n            height: vpSize.height * 0.95\n        });\n        // To handle window resizing you would have to hook onto onWindowResize.\n</code></pre>\n\ngetViewSize utilizes clientHeight/clientWidth which excludes sizing of scrollbars.\nTo obtain the size including scrollbars, use getStyleSize\n\nSizing of the document body is handled at the adapter level which handles special cases for IE and strict modes, etc.\n\n</p></p></div></div></div><div id='method-getWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-getWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'>[contentWidth]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the offset width of the element ...</div><div class='long'><p>Returns the offset width of the element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contentWidth</span> : Boolean (optional)<div class='sub-desc'><p>true to get the width minus borders and padding</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The element's width</p>\n</div></li></ul></div></div></div><div id='method-getX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getX' class='name expandable'>getX</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current X position of the element based on page coordinates. ...</div><div class='long'><p>Gets the current X position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The X position of the element</p>\n</div></li></ul></div></div></div><div id='method-getXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getXY' class='name expandable'>getXY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the current position of the element based on page coordinates. ...</div><div class='long'><p>Gets the current position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The XY position of the element</p>\n</div></li></ul></div></div></div><div id='method-getY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-getY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-getY' class='name expandable'>getY</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current Y position of the element based on page coordinates. ...</div><div class='long'><p>Gets the current Y position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The Y position of the element</p>\n</div></li></ul></div></div></div><div id='method-hasClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-hasClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-hasClass' class='name expandable'>hasClass</a>( <span class='pre'>className</span> ) : Boolean</div><div class='description'><div class='short'>Checks if the specified CSS class exists on this element's DOM node. ...</div><div class='long'><p>Checks if the specified CSS class exists on this element's DOM node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the class exists, else false</p>\n</div></li></ul></div></div></div><div id='method-hasMetrics' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-hasMetrics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-hasMetrics' class='name expandable'>hasMetrics</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Determine if the Element has a relevant height and width available based\nupon current logical visibility state ...</div><div class='long'><p>Determine if the Element has a relevant height and width available based\nupon current logical visibility state</p>\n</div></div></div><div id='method-hide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-hide' class='name expandable'>hide</a>( <span class='pre'>[animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Hide this element - Uses display mode to determine whether to use \"display\" or \"visibility\". ...</div><div class='long'><p>Hide this element - Uses display mode to determine whether to use \"display\" or \"visibility\". See <a href=\"#!/api/Ext.Element-method-setVisible\" rel=\"Ext.Element-method-setVisible\" class=\"docClass\">setVisible</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-hover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-hover' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-hover' class='name expandable'>hover</a>( <span class='pre'>overFn, outFn, [scope], [options]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element. ...</div><div class='long'><p>Sets up event handlers to call the passed functions when the mouse is moved into and out of the Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call when the mouse enters the Element.</p>\n</div></li><li><span class='pre'>outFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call when the mouse leaves the Element.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the functions are executed. Defaults to the Element's DOM element.</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>Options for the listener. See <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">the &lt;tt&gt;options&lt;/tt&gt; parameter</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-initDD' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.dd.html#Ext-Element-method-initDD' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-initDD' class='name expandable'>initDD</a>( <span class='pre'>group, config, overrides</span> ) : <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a></div><div class='description'><div class='short'>Initializes a Ext.dd.DD drag drop object for this element. ...</div><div class='long'><p>Initializes a <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a> drag drop object for this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group the DD object is member of</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The DD config object</p>\n</div></li><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>An object containing methods to override/implement on the DD object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a></span><div class='sub-desc'><p>The DD object</p>\n</div></li></ul></div></div></div><div id='method-initDDProxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.dd.html#Ext-Element-method-initDDProxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-initDDProxy' class='name expandable'>initDDProxy</a>( <span class='pre'>group, config, overrides</span> ) : <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></div><div class='description'><div class='short'>Initializes a Ext.dd.DDProxy object for this element. ...</div><div class='long'><p>Initializes a <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a> object for this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group the DDProxy object is member of</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The DDProxy config object</p>\n</div></li><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>An object containing methods to override/implement on the DDProxy object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></span><div class='sub-desc'><p>The DDProxy object</p>\n</div></li></ul></div></div></div><div id='method-initDDTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.dd.html#Ext-Element-method-initDDTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-initDDTarget' class='name expandable'>initDDTarget</a>( <span class='pre'>group, config, overrides</span> ) : <a href=\"#!/api/Ext.dd.DDTarget\" rel=\"Ext.dd.DDTarget\" class=\"docClass\">Ext.dd.DDTarget</a></div><div class='description'><div class='short'>Initializes a Ext.dd.DDTarget object for this element. ...</div><div class='long'><p>Initializes a <a href=\"#!/api/Ext.dd.DDTarget\" rel=\"Ext.dd.DDTarget\" class=\"docClass\">Ext.dd.DDTarget</a> object for this element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>group</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The group the DDTarget object is member of</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The DDTarget config object</p>\n</div></li><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>An object containing methods to override/implement on the DDTarget object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DDTarget\" rel=\"Ext.dd.DDTarget\" class=\"docClass\">Ext.dd.DDTarget</a></span><div class='sub-desc'><p>The DDTarget object</p>\n</div></li></ul></div></div></div><div id='method-insertAfter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-insertAfter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-insertAfter' class='name expandable'>insertAfter</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Inserts this element after the passed element in the DOM ...</div><div class='long'><p>Inserts this element after the passed element in the DOM</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The element to insert after</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-insertBefore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-insertBefore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-insertBefore' class='name expandable'>insertBefore</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Inserts this element before the passed element in the DOM ...</div><div class='long'><p>Inserts this element before the passed element in the DOM</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The element before which this element will be inserted</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-insertFirst' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-insertFirst' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-insertFirst' class='name expandable'>insertFirst</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts (or creates) an element (or DomHelper config) as the first child of this element ...</div><div class='long'><p>Inserts (or creates) an element (or DomHelper config) as the first child of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed/Object<div class='sub-desc'><p>The id or element to insert or a DomHelper config to create and insert</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new child</p>\n</div></li></ul></div></div></div><div id='method-insertHtml' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-insertHtml' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-insertHtml' class='name expandable'>insertHtml</a>( <span class='pre'>where, html, [returnEl]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts an html fragment into this element ...</div><div class='long'><p>Inserts an html fragment into this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>where</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Where to insert the html in relation to this element - beforeBegin, afterBegin, beforeEnd, afterEnd.</p>\n</div></li><li><span class='pre'>html</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The HTML fragment</p>\n</div></li><li><span class='pre'>returnEl</span> : Boolean (optional)<div class='sub-desc'><p>True to return an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The inserted node (or nearest related if more than 1 inserted)</p>\n</div></li></ul></div></div></div><div id='method-insertSibling' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion-more.html#Ext-Element-method-insertSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-insertSibling' class='name expandable'>insertSibling</a>( <span class='pre'>el, [where], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Inserts (or creates) the passed element (or DomHelper config) as a sibling of this element ...</div><div class='long'><p>Inserts (or creates) the passed element (or DomHelper config) as a sibling of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed/Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The id, element to insert or a DomHelper config to create and insert <em>or</em> an array of any of those.</p>\n</div></li><li><span class='pre'>where</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>'before' or 'after' defaults to before</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return the raw DOM element instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The inserted Element. If an array is passed, the last inserted element is returned.</p>\n</div></li></ul></div></div></div><div id='method-is' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-is' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-is' class='name expandable'>is</a>( <span class='pre'>selector</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this element matches the passed simple selector (e.g. ...</div><div class='long'><p>Returns true if this element matches the passed simple selector (e.g. div.some-class or span:first-child)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this element matches the selector, else false</p>\n</div></li></ul></div></div></div><div id='method-isBorderBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-isBorderBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-isBorderBox' class='name expandable'>isBorderBox</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Tests various css rules/browsers to determine if this element uses a border box ...</div><div class='long'><p>Tests various css rules/browsers to determine if this element uses a border box</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDisplayed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx-more.html#Ext-Element-method-isDisplayed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-isDisplayed' class='name expandable'>isDisplayed</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if display is not \"none\" ...</div><div class='long'><p>Returns true if display is not \"none\"</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isMasked' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx-more.html#Ext-Element-method-isMasked' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-isMasked' class='name expandable'>isMasked</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this element is masked ...</div><div class='long'><p>Returns true if this element is masked</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isScrollable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.scroll.html#Ext-Element-method-isScrollable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-isScrollable' class='name expandable'>isScrollable</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this element is scrollable. ...</div><div class='long'><p>Returns true if this element is scrollable.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-isVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Checks whether the element is currently visible using both visibility and display properties. ...</div><div class='long'><p>Checks whether the element is currently visible using both visibility and display properties.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the element is currently visible, else false</p>\n</div></li></ul></div></div></div><div id='method-last' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-last' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-last' class='name expandable'>last</a>( <span class='pre'>[selector], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the last child, skipping text nodes ...</div><div class='long'><p>Gets the last child, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the previous sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The last child or null</p>\n</div></li></ul></div></div></div><div id='method-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-load' class='name expandable'>load</a>( <span class='pre'>options</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Updates the innerHTML of this Element\nfrom a specified URL. ...</div><div class='long'><p>Updates the <a href=\"http://developer.mozilla.org/en/DOM/element.innerHTML\">innerHTML</a> of this Element\nfrom a specified URL. Note that this is subject to the <a href=\"http://en.wikipedia.org/wiki/Same_origin_policy\">Same Origin Policy</a></p>\n\n\n<p>Updating innerHTML of an element will <b>not</b> execute embedded <tt>&lt;script></tt> elements. This is a browser restriction.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : Mixed<div class='sub-desc'><p>. Either a sring containing the URL from which to load the HTML, or an <a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a> options object specifying\nexactly how to request the HTML.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-mask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx-more.html#Ext-Element-method-mask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-mask' class='name expandable'>mask</a>( <span class='pre'>[msg], [msgCls]</span> ) : Element</div><div class='description'><div class='short'>Puts a mask over this element to disable user interaction. ...</div><div class='long'><p>Puts a mask over this element to disable user interaction. Requires core.css.\nThis method can only be applied to elements which accept child nodes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A message to display in the mask</p>\n</div></li><li><span class='pre'>msgCls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A css class to apply to the msg element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Element</span><div class='sub-desc'><p>The mask element</p>\n</div></li></ul></div></div></div><div id='method-move' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-move' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-move' class='name expandable'>move</a>( <span class='pre'>direction, distance, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Move this element relative to its current position. ...</div><div class='long'><p>Move this element relative to its current position.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Possible values are: \"l\" (or \"left\"), \"r\" (or \"right\"), \"t\" (or \"top\", or \"up\"), \"b\" (or \"bottom\", or \"down\").</p>\n</div></li><li><span class='pre'>distance</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>How far to move the element in pixels</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-moveTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-moveTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-moveTo' class='name expandable'>moveTo</a>( <span class='pre'>x, y, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the position of the element in page coordinates, regardless of how the element is positioned. ...</div><div class='long'><p>Sets the position of the element in page coordinates, regardless of how the element is positioned.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-next' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-next' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-next' class='name expandable'>next</a>( <span class='pre'>[selector], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the next sibling, skipping text nodes ...</div><div class='long'><p>Gets the next sibling, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the next sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The next sibling or null</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, fn, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler (shorthand for addListener). ...</div><div class='long'><p>Appends an event handler (shorthand for <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of event to handle.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing standard <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> options</p>\n</div></li></ul></div></div></div><div id='method-parent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-parent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-parent' class='name expandable'>parent</a>( <span class='pre'>[selector], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the parent node for this element, optionally chaining up trying to match a selector ...</div><div class='long'><p>Gets the parent node for this element, optionally chaining up trying to match a selector</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find a parent node that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The parent node or null</p>\n</div></li></ul></div></div></div><div id='method-position' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-position' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-position' class='name expandable'>position</a>( <span class='pre'>[pos], [zIndex], [x], [y]</span> )</div><div class='description'><div class='short'>Initializes positioning on this element. ...</div><div class='long'><p>Initializes positioning on this element. If a desired position is not passed, it will make the\nthe element positioned relative IF it is not already positioned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pos</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Positioning to use \"relative\", \"absolute\" or \"fixed\"</p>\n</div></li><li><span class='pre'>zIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The zIndex to apply</p>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Set the page X position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Set the page Y position</p>\n</div></li></ul></div></div></div><div id='method-prev' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-prev' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-prev' class='name expandable'>prev</a>( <span class='pre'>[selector], [returnDom]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</div><div class='description'><div class='short'>Gets the previous sibling, skipping text nodes ...</div><div class='long'><p>Gets the previous sibling, skipping text nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Find the previous sibling that matches the passed simple selector</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return a raw dom node instead of an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/HTMLElement</span><div class='sub-desc'><p>The previous sibling or null</p>\n</div></li></ul></div></div></div><div id='method-purgeAllListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-purgeAllListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-purgeAllListeners' class='name expandable'>purgeAllListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Recursively removes all previous added listeners from this element and its children ...</div><div class='long'><p>Recursively removes all previous added listeners from this element and its children</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-query' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-query' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-query' class='name expandable'>query</a>( <span class='pre'>selector</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Selects child nodes based on the passed CSS selector (the selector should not contain an id). ...</div><div class='long'><p>Selects child nodes based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>An array of the matched nodes</p>\n</div></li></ul></div></div></div><div id='method-radioClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-radioClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-radioClass' class='name expandable'>radioClass</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Adds one or more CSS classes to this element and removes the same class(es) from all siblings. ...</div><div class='long'><p>Adds one or more CSS classes to this element and removes the same class(es) from all siblings.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The CSS class to add, or an array of classes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-relayEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element-more.html#Ext-Element-method-relayEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-relayEvent' class='name expandable'>relayEvent</a>( <span class='pre'>eventName, object</span> )</div><div class='description'><div class='short'>Create an event handler on this element such that when the event fires and is handled by this element,\nit will be rel...</div><div class='long'><p>Create an event handler on this element such that when the event fires and is handled by this element,\nit will be relayed to another object (i.e., fired again as if it originated from that object instead).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to relay</p>\n</div></li><li><span class='pre'>object</span> : Object<div class='sub-desc'><p>Any object that extends <a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a> that will provide the context\nfor firing the relayed event</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-remove' class='name expandable'>remove</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes this element's dom reference. ...</div><div class='long'><p>Removes this element's dom reference.  Note that event and cache removal is handled at <a href=\"#!/api/Ext-method-removeNode\" rel=\"Ext-method-removeNode\" class=\"docClass\">Ext.removeNode</a></p>\n\n</div></div></div><div id='method-removeAllListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-removeAllListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-removeAllListeners' class='name expandable'>removeAllListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes all previous added listeners from this element ...</div><div class='long'><p>Removes all previous added listeners from this element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeAnchor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.alignment.html#Ext-Element-method-removeAnchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-removeAnchor' class='name expandable'>removeAnchor</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Remove any anchor to this element. ...</div><div class='long'><p>Remove any anchor to this element. See <a href=\"#!/api/Ext.Element-method-anchorTo\" rel=\"Ext.Element-method-anchorTo\" class=\"docClass\">anchorTo</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-removeClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-removeClass' class='name expandable'>removeClass</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes one or more CSS classes from the element. ...</div><div class='long'><p>Removes one or more CSS classes from the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The CSS class to remove, or an array of classes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, fn, scope</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes an event handler from this element. ...</div><div class='long'><p>Removes an event handler from this element.  The shorthand version <a href=\"#!/api/Ext.Element-method-un\" rel=\"Ext.Element-method-un\" class=\"docClass\">un</a> is equivalent.\n<b>Note</b>: if a <i>scope</i> was explicitly specified when <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">adding</a> the\nlistener, the same scope must be specified here.\nExample:</p>\n\n<pre><code>el.removeListener('click', this.handlerFn);\n// or\nel.un('click', this.handlerFn);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event from which to remove the handler.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>If a scope (<b><code>this</code></b> reference) was specified when the listener was added,\nthen this must refer to the same object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-repaint' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-repaint' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-repaint' class='name expandable'>repaint</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Forces the browser to repaint this element ...</div><div class='long'><p>Forces the browser to repaint this element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-replace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-replace' class='name expandable'>replace</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Replaces the passed element with this element ...</div><div class='long'><p>Replaces the passed element with this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The element to replace</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replaceClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-replaceClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-replaceClass' class='name expandable'>replaceClass</a>( <span class='pre'>oldClassName, newClassName</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Replaces a CSS class on the element with another. ...</div><div class='long'><p>Replaces a CSS class on the element with another.  If the old name does not exist, the new name will simply be added.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldClassName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class to replace</p>\n</div></li><li><span class='pre'>newClassName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The replacement CSS class</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-replaceWith' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-replaceWith' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-replaceWith' class='name expandable'>replaceWith</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Replaces this element with the passed element ...</div><div class='long'><p>Replaces this element with the passed element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed/Object<div class='sub-desc'><p>The new element or a DomHelper config of an element to create</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-scroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.scroll-more.html#Ext-Element-method-scroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-scroll' class='name expandable'>scroll</a>( <span class='pre'>direction, distance, [animate]</span> ) : Boolean</div><div class='description'><div class='short'>Scrolls this element the specified direction. ...</div><div class='long'><p>Scrolls this element the specified direction. Does bounds checking to make sure the scroll is\nwithin this element's scrollable range.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Possible values are: \"l\" (or \"left\"), \"r\" (or \"right\"), \"t\" (or \"top\", or \"up\"), \"b\" (or \"bottom\", or \"down\").</p>\n</div></li><li><span class='pre'>distance</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>How far to scroll the element in pixels</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns true if a scroll was triggered or false if the element\nwas scrolled as far as it could go.</p>\n</div></li></ul></div></div></div><div id='method-scrollIntoView' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.scroll-more.html#Ext-Element-method-scrollIntoView' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-scrollIntoView' class='name expandable'>scrollIntoView</a>( <span class='pre'>[container], [hscroll]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Scrolls this element into view within the passed container. ...</div><div class='long'><p>Scrolls this element into view within the passed container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : Mixed (optional)<div class='sub-desc'><p>The container element to scroll (defaults to document.body).  Should be a\nstring (id), dom node, or <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n</div></li><li><span class='pre'>hscroll</span> : Boolean (optional)<div class='sub-desc'><p>False to disable horizontal scroll (defaults to true)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-scrollTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.scroll.html#Ext-Element-method-scrollTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-scrollTo' class='name expandable'>scrollTo</a>( <span class='pre'>side, value</span> ) : Element<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Scrolls this element the specified scroll point. ...</div><div class='long'><p>Scrolls this element the specified scroll point. It does NOT do bounds checking so if you scroll to a weird value it will try to do it. For auto bounds checking, use scroll().</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>side</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either \"left\" for scrollLeft values or \"top\" for scrollTop values.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new scroll value.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Element</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-select' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-select' class='name expandable'>select</a>( <span class='pre'>selector</span> ) : CompositeElement/CompositeElementLite</div><div class='description'><div class='short'>Creates a Ext.CompositeElement for child nodes based on the passed CSS selector (the selector should not contain an id). ...</div><div class='long'><p>Creates a <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a> for child nodes based on the passed CSS selector (the selector should not contain an id).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS selector</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>CompositeElement/CompositeElementLite</span><div class='sub-desc'><p>The composite element</p>\n</div></li></ul></div></div></div><div id='method-set' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-set' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-set' class='name expandable'>set</a>( <span class='pre'>o, [useSet]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the passed attributes as attributes of this element (a style attribute can be a string, object or function) ...</div><div class='long'><p>Sets the passed attributes as attributes of this element (a style attribute can be a string, object or function)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The object with the attributes</p>\n</div></li><li><span class='pre'>useSet</span> : Boolean (optional)<div class='sub-desc'><p>false to override the default setAttribute to use expandos.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setBottom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setBottom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setBottom' class='name expandable'>setBottom</a>( <span class='pre'>bottom</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's CSS bottom style. ...</div><div class='long'><p>Sets the element's CSS bottom style.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bottom</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The bottom CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setBounds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-setBounds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setBounds' class='name expandable'>setBounds</a>( <span class='pre'>x, y, width, height, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's position and size in one shot. ...</div><div class='long'><p>Sets the element's position and size in one shot. If animation is true then width, height, x and y will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels)</li>\n<li>A String used to set the CSS width style. Animation may <b>not</b> be used.\n</ul></div></p>\n</li></div></li><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels)</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setBox' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-setBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setBox' class='name expandable'>setBox</a>( <span class='pre'>box, [adjust], [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's box. ...</div><div class='long'><p>Sets the element's box. Use getBox() on another element to get a box obj. If animate is true then width, height, x and y will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : Object<div class='sub-desc'><p>The box to fill {x, y, width, height}</p>\n</div></li><li><span class='pre'>adjust</span> : Boolean (optional)<div class='sub-desc'><p>Whether to adjust for box-model issues automatically</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDisplayed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-setDisplayed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setDisplayed' class='name expandable'>setDisplayed</a>( <span class='pre'>value</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the CSS display property. ...</div><div class='long'><p>Sets the CSS display property. Uses originalDisplay if the specified value is a boolean true.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>Boolean value to display the element using its default display, or a string to set the display directly.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-setHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'>height, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Set the height of this Element. ...</div><div class='long'><p>Set the height of this Element.</p>\n\n<pre><code>// change the height to 200px and animate with default configuration\n<a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">Ext.fly</a>('elementId').setHeight(200, true);\n\n// change the height to 150px and animate with a custom configuration\n<a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">Ext.fly</a>('elId').setHeight(150, {\n    duration : .5, // animation will have a duration of .5 seconds\n    // will change the content to \"finished\"\n    callback: function(){ this.<a href=\"#!/api/Ext.Element-method-update\" rel=\"Ext.Element-method-update\" class=\"docClass\">update</a>(\"finished\"); }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels.)</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setLeft' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setLeft' class='name expandable'>setLeft</a>( <span class='pre'>left</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's left position directly using CSS style (instead of setX). ...</div><div class='long'><p>Sets the element's left position directly using CSS style (instead of <a href=\"#!/api/Ext.Element-method-setX\" rel=\"Ext.Element-method-setX\" class=\"docClass\">setX</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The left CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLeftTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-setLeftTop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setLeftTop' class='name expandable'>setLeftTop</a>( <span class='pre'>left, top</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Quick set left and top adding default units ...</div><div class='long'><p>Quick set left and top adding default units</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The left CSS property value</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The top CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setLocation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setLocation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setLocation' class='name expandable'>setLocation</a>( <span class='pre'>x, y, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the position of the element in page coordinates, regardless of how the element is positioned. ...</div><div class='long'><p>Sets the position of the element in page coordinates, regardless of how the element is positioned.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y value for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setOpacity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-setOpacity' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setOpacity' class='name expandable'>setOpacity</a>( <span class='pre'>opacity, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Set the opacity of the element ...</div><div class='long'><p>Set the opacity of the element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opacity</span> : Float<div class='sub-desc'><p>The new opacity. 0 = transparent, .5 = 50% visibile, 1 = fully visible, etc</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>a standard Element animation config object or <tt>true</tt> for\nthe default animation (<tt>{duration: .35, easing: 'easeIn'}</tt>)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setPositioning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setPositioning' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setPositioning' class='name expandable'>setPositioning</a>( <span class='pre'>posCfg</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Set positioning with an object returned by getPositioning(). ...</div><div class='long'><p>Set positioning with an object returned by getPositioning().</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>posCfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setRegion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position-more.html#Ext-Element-method-setRegion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setRegion' class='name expandable'>setRegion</a>( <span class='pre'>region, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's position and size the specified region. ...</div><div class='long'><p>Sets the element's position and size the specified region. If animation is true then width, height, x and y will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>region</span> : Ext.lib.Region<div class='sub-desc'><p>The region to fill</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setRight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setRight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setRight' class='name expandable'>setRight</a>( <span class='pre'>right</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's CSS right style. ...</div><div class='long'><p>Sets the element's CSS right style.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>right</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The right CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-setSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setSize' class='name expandable'>setSize</a>( <span class='pre'>width, height, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Set the size of this Element. ...</div><div class='long'><p>Set the size of this Element. If animation is true, both width and height will be animated concurrently.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style. Animation may <b>not</b> be used.\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n</ul></div></p>\n</li></div></li><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setStyle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-setStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setStyle' class='name expandable'>setStyle</a>( <span class='pre'>property, [value]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Wrapper for setting style properties, also takes single object parameter of multiple styles. ...</div><div class='long'><p>Wrapper for setting style properties, also takes single object parameter of multiple styles.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>The style property to be set, or an object of multiple styles.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The value to apply to the given property, or null if an object was passed.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setTop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setTop' class='name expandable'>setTop</a>( <span class='pre'>top</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's top position directly using CSS style (instead of setY). ...</div><div class='long'><p>Sets the element's top position directly using CSS style (instead of <a href=\"#!/api/Ext.Element-method-setY\" rel=\"Ext.Element-method-setY\" class=\"docClass\">setY</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>top</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The top CSS property value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisibilityMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-setVisibilityMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setVisibilityMode' class='name expandable'>setVisibilityMode</a>( <span class='pre'>visMode</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the element's visibility mode. ...</div><div class='long'><p>Sets the element's visibility mode. When setVisible() is called it\nwill use this to determine whether to set the visibility or the display property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visMode</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p><a href=\"#!/api/Ext.Element-static-property-VISIBILITY\" rel=\"Ext.Element-static-property-VISIBILITY\" class=\"docClass\">Ext.Element.VISIBILITY</a> or <a href=\"#!/api/Ext.Element-static-property-DISPLAY\" rel=\"Ext.Element-static-property-DISPLAY\" class=\"docClass\">Ext.Element.DISPLAY</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisible' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-setVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'>visible, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the visibility of the element (see details). ...</div><div class='long'><p>Sets the visibility of the element (see details). If the visibilityMode is set to Element.DISPLAY, it will use\nthe display property to hide the element, otherwise it uses visibility. The default is to hide and show using the visibility property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : Boolean<div class='sub-desc'><p>Whether the element is visible</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-setWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'>width, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Set the width of this Element. ...</div><div class='long'><p>Set the width of this Element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in this Element's <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style. Animation may <b>not</b> be used.\n</ul></div></p>\n</li></div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setX' class='name expandable'>setX</a>( <span class='pre'>The, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the X position of the element based on page coordinates. ...</div><div class='long'><p>Sets the X position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>X position of the element</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setXY' class='name expandable'>setXY</a>( <span class='pre'>pos, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the position of the element in page coordinates, regardless of how the element is positioned. ...</div><div class='long'><p>Sets the position of the element in page coordinates, regardless of how the element is positioned.\nThe element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pos</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Contains X &amp; Y [x, y] values for new position (coordinates are page-based)</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-setY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-setY' class='name expandable'>setY</a>( <span class='pre'>The, [animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the Y position of the element based on page coordinates. ...</div><div class='long'><p>Sets the Y position of the element based on page coordinates.  Element must be part of the DOM tree to have page coordinates (display:none or elements not appended return false).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Y position of the element</p>\n</div></li><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-show' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-show' class='name expandable'>show</a>( <span class='pre'>[animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Show this element - Uses display mode to determine whether to use \"display\" or \"visibility\". ...</div><div class='long'><p>Show this element - Uses display mode to determine whether to use \"display\" or \"visibility\". See <a href=\"#!/api/Ext.Element-method-setVisible\" rel=\"Ext.Element-method-setVisible\" class=\"docClass\">setVisible</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>true for the default animation or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-swallowEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element-more.html#Ext-Element-method-swallowEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-swallowEvent' class='name expandable'>swallowEvent</a>( <span class='pre'>eventName, [preventDefault]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Stops the specified event(s) from bubbling and optionally prevents the default action ...</div><div class='long'><p>Stops the specified event(s) from bubbling and optionally prevents the default action</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>an event / array of events to stop from bubbling</p>\n</div></li><li><span class='pre'>preventDefault</span> : Boolean (optional)<div class='sub-desc'><p>true to prevent the default action too</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toggle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx.html#Ext-Element-method-toggle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-toggle' class='name expandable'>toggle</a>( <span class='pre'>[animate]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Toggles the element's visibility or display, depending on visibility mode. ...</div><div class='long'><p>Toggles the element's visibility or display, depending on visibility mode.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : Boolean/Object (optional)<div class='sub-desc'><p>True for the default animation, or a standard Element animation config object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toggleClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-toggleClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-toggleClass' class='name expandable'>toggleClass</a>( <span class='pre'>className</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Toggles the specified CSS class on this element (removes it if it already exists, otherwise adds it). ...</div><div class='long'><p>Toggles the specified CSS class on this element (removes it if it already exists, otherwise adds it).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The CSS class to toggle</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-translatePoints' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.position.html#Ext-Element-method-translatePoints' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-translatePoints' class='name expandable'>translatePoints</a>( <span class='pre'>x, [y]</span> ) : Object</div><div class='description'><div class='short'>Translates the passed page coordinates into left/top css values for this element ...</div><div class='long'><p>Translates the passed page coordinates into left/top css values for this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The page x or an array containing [x, y]</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The page y, required if x is not an array</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object with left and top properties. e.g. {left: (value), top: (value)}</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, fn, scope</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes an event handler from this element (see removeListener for additional notes). ...</div><div class='long'><p>Removes an event handler from this element (see <a href=\"#!/api/Ext.Element-method-removeListener\" rel=\"Ext.Element-method-removeListener\" class=\"docClass\">removeListener</a> for additional notes).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event from which to remove the handler.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler function to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>If a scope (<b><code>this</code></b> reference) was specified when the listener was added,\nthen this must refer to the same object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-unclip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style.html#Ext-Element-method-unclip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-unclip' class='name expandable'>unclip</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Return clipping (overflow) to original clipping before clip was called ...</div><div class='long'><p>Return clipping (overflow) to original clipping before <tt><a href=\"#!/api/Ext.Element-method-clip\" rel=\"Ext.Element-method-clip\" class=\"docClass\">clip</a></tt> was called</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-unmask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.fx-more.html#Ext-Element-method-unmask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-unmask' class='name expandable'>unmask</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes a previously applied mask. ...</div><div class='long'><p>Removes a previously applied mask.</p>\n</div></div></div><div id='method-unselectable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.style-more.html#Ext-Element-method-unselectable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-unselectable' class='name expandable'>unselectable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Disables text selection for this element (normalized across browsers) ...</div><div class='long'><p>Disables text selection for this element (normalized across browsers)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-up' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.traversal.html#Ext-Element-method-up' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-up' class='name expandable'>up</a>( <span class='pre'>selector, [maxDepth]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Walks up the dom looking for a parent node that matches the passed simple selector (e.g. ...</div><div class='long'><p>Walks up the dom looking for a parent node that matches the passed simple selector (e.g. div.some-class or span:first-child).\nThis is a shortcut for findParentNode() that always returns an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The simple selector to test</p>\n</div></li><li><span class='pre'>maxDepth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/Mixed (optional)<div class='sub-desc'><p>The max depth to</p>\n\n<pre><code>            search as a number or element (defaults to 10 || document.body)\n</code></pre>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The matching DOM node (or null if no match was found)</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-method-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-update' class='name expandable'>update</a>( <span class='pre'>html</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Update the innerHTML of this element ...</div><div class='long'><p>Update the innerHTML of this element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>html</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new HTML</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-wrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.insertion.html#Ext-Element-method-wrap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-method-wrap' class='name expandable'>wrap</a>( <span class='pre'>[config], [returnDom]</span> ) : HTMLElement/Element</div><div class='description'><div class='short'>Creates and wraps this element with another element ...</div><div class='long'><p>Creates and wraps this element with another element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'><p>DomHelper element config object for the wrapper element or null for an empty div</p>\n</div></li><li><span class='pre'>returnDom</span> : Boolean (optional)<div class='sub-desc'><p>True to return the raw DOM element instead of <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/Element</span><div class='sub-desc'><p>The newly created wrapper element</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-get' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-static-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-static-method-get' class='name expandable'>get</a>( <span class='pre'>el</span> ) : Element<strong class='static signature' >static</strong></div><div class='description'><div class='short'>Retrieves Ext.Element objects. ...</div><div class='long'><p>Retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects.</p>\n\n<p><b>This method does not retrieve <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>s.</b> This method\nretrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects which encapsulate DOM elements. To retrieve a Component by\nits ID, use <a href=\"#!/api/Ext.ComponentMgr-method-get\" rel=\"Ext.ComponentMgr-method-get\" class=\"docClass\">Ext.ComponentMgr.get</a>.</p>\n\n\n<p>Uses simple caching to consistently return the same object. Automatically fixes if an\nobject was recreated with the same id via AJAX or DOM.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Element</span><div class='sub-desc'><p>The Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='static-method-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/CompositeElementLite.html#Ext-Element-static-method-select' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-static-method-select' class='name expandable'>select</a>( <span class='pre'>selector, [root]</span> ) : CompositeElementLite/CompositeElement<strong class='static signature' >static</strong></div><div class='description'><div class='short'>Selects elements based on the passed CSS selector to enable Element methods\nto be applied to many related elements in...</div><div class='long'><p>Selects elements based on the passed CSS selector to enable <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> methods\nto be applied to many related elements in one statement through the returned <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">CompositeElement</a> or\n<a href=\"#!/api/Ext.CompositeElementLite\" rel=\"Ext.CompositeElementLite\" class=\"docClass\">CompositeElementLite</a> object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The CSS selector or an array of elements</p>\n</div></li><li><span class='pre'>root</span> : HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The root element of the query or id of the root</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>CompositeElementLite/CompositeElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-DOMActivate' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMActivate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMActivate' class='name expandable'>DOMActivate</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when an element is activated, for instance, through a mouse click or a keypress.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMAttrModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMAttrModified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMAttrModified' class='name expandable'>DOMAttrModified</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when an attribute has been modified.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMCharacterDataModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMCharacterDataModified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMCharacterDataModified' class='name expandable'>DOMCharacterDataModified</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when the character data has been modified.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMFocusIn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMFocusIn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMFocusIn' class='name expandable'>DOMFocusIn</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Similar to HTML focus event, but can be applied to any focusable element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMFocusOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMFocusOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMFocusOut' class='name expandable'>DOMFocusOut</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Similar to HTML blur event, but can be applied to any focusable element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMNodeInserted' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMNodeInserted' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeInserted' class='name expandable'>DOMNodeInserted</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a node has been added as a child of another node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMNodeInsertedIntoDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMNodeInsertedIntoDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeInsertedIntoDocument' class='name expandable'>DOMNodeInsertedIntoDocument</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a node is being inserted into a document.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMNodeRemoved' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMNodeRemoved' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeRemoved' class='name expandable'>DOMNodeRemoved</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a descendant node of the element is removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMNodeRemovedFromDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMNodeRemovedFromDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMNodeRemovedFromDocument' class='name expandable'>DOMNodeRemovedFromDocument</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when a node is being removed from a document.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-DOMSubtreeModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-DOMSubtreeModified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-DOMSubtreeModified' class='name expandable'>DOMSubtreeModified</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Where supported. ...</div><div class='long'><p>Where supported. Fires when the subtree is modified.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-abort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-abort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-abort' class='name expandable'>abort</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when an object/image is stopped from loading before completely loaded. ...</div><div class='long'><p>Fires when an object/image is stopped from loading before completely loaded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-blur' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-blur' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-blur' class='name expandable'>blur</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when an element loses focus either via the pointing device or by tabbing navigation. ...</div><div class='long'><p>Fires when an element loses focus either via the pointing device or by tabbing navigation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-change' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-change' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-change' class='name expandable'>change</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a control loses the input focus and its value has been modified since gaining focus. ...</div><div class='long'><p>Fires when a control loses the input focus and its value has been modified since gaining focus.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-click' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-click' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-click' class='name expandable'>click</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mouse click is detected within the element. ...</div><div class='long'><p>Fires when a mouse click is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-contextmenu' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-contextmenu' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-contextmenu' class='name expandable'>contextmenu</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a right click is detected within the element. ...</div><div class='long'><p>Fires when a right click is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-dblclick' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-dblclick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-dblclick' class='name expandable'>dblclick</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mouse double click is detected within the element. ...</div><div class='long'><p>Fires when a mouse double click is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-error' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-error' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-error' class='name expandable'>error</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when an object/image/frame cannot be loaded properly. ...</div><div class='long'><p>Fires when an object/image/frame cannot be loaded properly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-focus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-focus' class='name expandable'>focus</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when an element receives focus either via the pointing device or by tab navigation. ...</div><div class='long'><p>Fires when an element receives focus either via the pointing device or by tab navigation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-keydown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-keydown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-keydown' class='name expandable'>keydown</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a keydown is detected within the element. ...</div><div class='long'><p>Fires when a keydown is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-keypress' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-keypress' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-keypress' class='name expandable'>keypress</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a keypress is detected within the element. ...</div><div class='long'><p>Fires when a keypress is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-keyup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-keyup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-keyup' class='name expandable'>keyup</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a keyup is detected within the element. ...</div><div class='long'><p>Fires when a keyup is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-load' class='name expandable'>load</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when the user agent finishes loading all content within the element. ...</div><div class='long'><p>Fires when the user agent finishes loading all content within the element. Only supported by window, frames, objects and images.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mousedown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mousedown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mousedown' class='name expandable'>mousedown</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mousedown is detected within the element. ...</div><div class='long'><p>Fires when a mousedown is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mouseenter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mouseenter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mouseenter' class='name expandable'>mouseenter</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when the mouse enters the element. ...</div><div class='long'><p>Fires when the mouse enters the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mouseleave' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mouseleave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mouseleave' class='name expandable'>mouseleave</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when the mouse leaves the element. ...</div><div class='long'><p>Fires when the mouse leaves the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mousemove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mousemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mousemove' class='name expandable'>mousemove</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mousemove is detected with the element. ...</div><div class='long'><p>Fires when a mousemove is detected with the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mouseout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mouseout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mouseout' class='name expandable'>mouseout</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mouseout is detected with the element. ...</div><div class='long'><p>Fires when a mouseout is detected with the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mouseover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mouseover' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mouseover' class='name expandable'>mouseover</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mouseover is detected within the element. ...</div><div class='long'><p>Fires when a mouseover is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-mouseup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-mouseup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-mouseup' class='name expandable'>mouseup</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a mouseup is detected within the element. ...</div><div class='long'><p>Fires when a mouseup is detected within the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-reset' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-reset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-reset' class='name expandable'>reset</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a form is reset. ...</div><div class='long'><p>Fires when a form is reset.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-resize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-resize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-resize' class='name expandable'>resize</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a document view is resized. ...</div><div class='long'><p>Fires when a document view is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-scroll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-scroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-scroll' class='name expandable'>scroll</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a document view is scrolled. ...</div><div class='long'><p>Fires when a document view is scrolled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-select' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-select' class='name expandable'>select</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a user selects some text in a text field, including input and textarea. ...</div><div class='long'><p>Fires when a user selects some text in a text field, including input and textarea.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-submit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-submit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-submit' class='name expandable'>submit</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when a form is submitted. ...</div><div class='long'><p>Fires when a form is submitted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div><div id='event-unload' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Element'>Ext.Element</span><br/><a href='source/Element.html#Ext-Element-event-unload' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Element-event-unload' class='name expandable'>unload</a>( <span class='pre'>e, t, o</span> )</div><div class='description'><div class='short'>Fires when the user agent removes all content from a window or frame. ...</div><div class='long'><p>Fires when the user agent removes all content from a window or frame. For elements, it fires when the target element or any of its content has been removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> encapsulating the DOM event.</p>\n</div></li><li><span class='pre'>t</span> : HtmlElement<div class='sub-desc'><p>The target of the event.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The options configuration passed to the <a href=\"#!/api/Ext.Element-method-addListener\" rel=\"Ext.Element-method-addListener\" class=\"docClass\">addListener</a> call.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":[],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[{"tagname":"property","owner":"Ext.Element","meta":{"static":true},"name":"DISPLAY","id":"static-property-DISPLAY"},{"tagname":"property","owner":"Ext.Element","meta":{"static":true},"name":"OFFSETS","id":"static-property-OFFSETS"},{"tagname":"property","owner":"Ext.Element","meta":{"static":true},"name":"VISIBILITY","id":"static-property-VISIBILITY"},{"tagname":"property","owner":"Ext.Element","meta":{"static":true},"name":"visibilityCls","id":"static-property-visibilityCls"}],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Element","meta":{"static":true},"name":"get","id":"static-method-get"},{"tagname":"method","owner":"Ext.Element","meta":{"static":true},"name":"select","id":"static-method-select"}],"event":[],"css_mixin":[]},"files":[{"href":"Element-more.html#Ext-Element","filename":"Element-more.js"},{"href":"Element.alignment.html#Ext-Element","filename":"Element.alignment.js"},{"href":"Element.dd.html#Ext-Element","filename":"Element.dd.js"},{"href":"Element.fx-more.html#Ext-Element","filename":"Element.fx-more.js"},{"href":"Element.insertion-more.html#Ext-Element","filename":"Element.insertion-more.js"},{"href":"Element.keys.html#Ext-Element","filename":"Element.keys.js"},{"href":"Element.position-more.html#Ext-Element","filename":"Element.position-more.js"},{"href":"Element.scroll-more.html#Ext-Element","filename":"Element.scroll-more.js"},{"href":"Element.style-more.html#Ext-Element","filename":"Element.style-more.js"},{"href":"Element.traversal-more.html#Ext-Element","filename":"Element.traversal-more.js"},{"href":"Element.fx.html#Ext-Element","filename":"Element.fx.js"},{"href":"Element.insertion.html#Ext-Element","filename":"Element.insertion.js"},{"href":"Element.html#Ext-Element","filename":"Element.js"},{"href":"Element.position.html#Ext-Element","filename":"Element.position.js"},{"href":"Element.scroll.html#Ext-Element","filename":"Element.scroll.js"},{"href":"Element.style.html#Ext-Element","filename":"Element.style.js"},{"href":"Element.traversal.html#Ext-Element","filename":"Element.traversal.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.Element","meta":{},"name":"autoBoxAdjust","id":"property-autoBoxAdjust"},{"tagname":"property","owner":"Ext.Element","meta":{},"name":"defaultUnit","id":"property-defaultUnit"},{"tagname":"property","owner":"Ext.Element","meta":{},"name":"dom","id":"property-dom"},{"tagname":"property","owner":"Ext.Element","meta":{},"name":"id","id":"property-id"},{"tagname":"property","owner":"Ext.Element","meta":{},"name":"originalDisplay","id":"property-originalDisplay"}],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Element","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"addClass","id":"method-addClass"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"addClassOnClick","id":"method-addClassOnClick"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"addClassOnFocus","id":"method-addClassOnFocus"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"addClassOnOver","id":"method-addClassOnOver"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"addKeyListener","id":"method-addKeyListener"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"addKeyMap","id":"method-addKeyMap"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.Element","meta":{"private":true},"name":"addUnits","id":"method-addUnits"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"alignTo","id":"method-alignTo"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"anchorTo","id":"method-anchorTo"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"animate","id":"method-animate"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"appendChild","id":"method-appendChild"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"appendTo","id":"method-appendTo"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"applyStyles","id":"method-applyStyles"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"blur","id":"method-blur"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"boxWrap","id":"method-boxWrap"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"center","id":"method-center"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"child","id":"method-child"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"clean","id":"method-clean"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"clearOpacity","id":"method-clearOpacity"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"clearPositioning","id":"method-clearPositioning"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"clip","id":"method-clip"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"contains","id":"method-contains"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"createChild","id":"method-createChild"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"createProxy","id":"method-createProxy"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"createShim","id":"method-createShim"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"down","id":"method-down"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"enableDisplayMode","id":"method-enableDisplayMode"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"findParent","id":"method-findParent"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"findParentNode","id":"method-findParentNode"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"first","id":"method-first"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"fly","id":"method-fly"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"focus","id":"method-focus"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getAlignToXY","id":"method-getAlignToXY"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getAnchorXY","id":"method-getAnchorXY"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getAttribute","id":"method-getAttribute"},{"tagname":"method","owner":"Ext.Element","meta":{"deprecated":{"text":""}},"name":"getAttributeNS","id":"method-getAttributeNS"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getBorderWidth","id":"method-getBorderWidth"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getBottom","id":"method-getBottom"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getBox","id":"method-getBox"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getCenterXY","id":"method-getCenterXY"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getColor","id":"method-getColor"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getComputedHeight","id":"method-getComputedHeight"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getComputedWidth","id":"method-getComputedWidth"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getFrameWidth","id":"method-getFrameWidth"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getHeight","id":"method-getHeight"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getLeft","id":"method-getLeft"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getMargins","id":"method-getMargins"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getOffsetsTo","id":"method-getOffsetsTo"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getPadding","id":"method-getPadding"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getPositioning","id":"method-getPositioning"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getRegion","id":"method-getRegion"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getRight","id":"method-getRight"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getScroll","id":"method-getScroll"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getSize","id":"method-getSize"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getStyle","id":"method-getStyle"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getStyleSize","id":"method-getStyleSize"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getStyles","id":"method-getStyles"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getTextWidth","id":"method-getTextWidth"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getTop","id":"method-getTop"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getUpdater","id":"method-getUpdater"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getValue","id":"method-getValue"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getViewSize","id":"method-getViewSize"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getWidth","id":"method-getWidth"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getX","id":"method-getX"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getXY","id":"method-getXY"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"getY","id":"method-getY"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"hasClass","id":"method-hasClass"},{"tagname":"method","owner":"Ext.Element","meta":{"private":true},"name":"hasMetrics","id":"method-hasMetrics"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"hide","id":"method-hide"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"hover","id":"method-hover"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"initDD","id":"method-initDD"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"initDDProxy","id":"method-initDDProxy"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"initDDTarget","id":"method-initDDTarget"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"insertAfter","id":"method-insertAfter"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"insertBefore","id":"method-insertBefore"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"insertFirst","id":"method-insertFirst"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"insertHtml","id":"method-insertHtml"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"insertSibling","id":"method-insertSibling"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"is","id":"method-is"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"isBorderBox","id":"method-isBorderBox"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"isDisplayed","id":"method-isDisplayed"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"isMasked","id":"method-isMasked"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"isScrollable","id":"method-isScrollable"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"isVisible","id":"method-isVisible"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"last","id":"method-last"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"load","id":"method-load"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"mask","id":"method-mask"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"move","id":"method-move"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"moveTo","id":"method-moveTo"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"next","id":"method-next"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"parent","id":"method-parent"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"position","id":"method-position"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"prev","id":"method-prev"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"purgeAllListeners","id":"method-purgeAllListeners"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"query","id":"method-query"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"radioClass","id":"method-radioClass"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"relayEvent","id":"method-relayEvent"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"removeAllListeners","id":"method-removeAllListeners"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"removeAnchor","id":"method-removeAnchor"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"removeClass","id":"method-removeClass"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"repaint","id":"method-repaint"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"replace","id":"method-replace"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"replaceClass","id":"method-replaceClass"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"replaceWith","id":"method-replaceWith"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"scroll","id":"method-scroll"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"scrollIntoView","id":"method-scrollIntoView"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"scrollTo","id":"method-scrollTo"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"select","id":"method-select"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"set","id":"method-set"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setBottom","id":"method-setBottom"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setBounds","id":"method-setBounds"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setBox","id":"method-setBox"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setDisplayed","id":"method-setDisplayed"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setHeight","id":"method-setHeight"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setLeft","id":"method-setLeft"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setLeftTop","id":"method-setLeftTop"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setLocation","id":"method-setLocation"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setOpacity","id":"method-setOpacity"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setPositioning","id":"method-setPositioning"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setRegion","id":"method-setRegion"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setRight","id":"method-setRight"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setSize","id":"method-setSize"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setStyle","id":"method-setStyle"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setTop","id":"method-setTop"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setVisibilityMode","id":"method-setVisibilityMode"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setVisible","id":"method-setVisible"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setWidth","id":"method-setWidth"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setX","id":"method-setX"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setXY","id":"method-setXY"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"setY","id":"method-setY"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"show","id":"method-show"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"swallowEvent","id":"method-swallowEvent"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"toggle","id":"method-toggle"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"toggleClass","id":"method-toggleClass"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"translatePoints","id":"method-translatePoints"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"unclip","id":"method-unclip"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"unmask","id":"method-unmask"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"unselectable","id":"method-unselectable"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"up","id":"method-up"},{"tagname":"method","owner":"Ext.Element","meta":{"chainable":true},"name":"update","id":"method-update"},{"tagname":"method","owner":"Ext.Element","meta":{},"name":"wrap","id":"method-wrap"}],"event":[{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMActivate","id":"event-DOMActivate"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMAttrModified","id":"event-DOMAttrModified"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMCharacterDataModified","id":"event-DOMCharacterDataModified"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMFocusIn","id":"event-DOMFocusIn"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMFocusOut","id":"event-DOMFocusOut"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMNodeInserted","id":"event-DOMNodeInserted"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMNodeInsertedIntoDocument","id":"event-DOMNodeInsertedIntoDocument"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMNodeRemoved","id":"event-DOMNodeRemoved"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMNodeRemovedFromDocument","id":"event-DOMNodeRemovedFromDocument"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"DOMSubtreeModified","id":"event-DOMSubtreeModified"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"abort","id":"event-abort"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"blur","id":"event-blur"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"change","id":"event-change"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"click","id":"event-click"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"contextmenu","id":"event-contextmenu"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"dblclick","id":"event-dblclick"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"error","id":"event-error"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"focus","id":"event-focus"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"keydown","id":"event-keydown"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"keypress","id":"event-keypress"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"keyup","id":"event-keyup"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"load","id":"event-load"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mousedown","id":"event-mousedown"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mouseenter","id":"event-mouseenter"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mouseleave","id":"event-mouseleave"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mousemove","id":"event-mousemove"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mouseout","id":"event-mouseout"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mouseover","id":"event-mouseover"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"mouseup","id":"event-mouseup"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"reset","id":"event-reset"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"resize","id":"event-resize"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"scroll","id":"event-scroll"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"select","id":"event-select"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"submit","id":"event-submit"},{"tagname":"event","owner":"Ext.Element","meta":{},"name":"unload","id":"event-unload"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.Element","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.Element","mixins":[],"mixedInto":[]});