/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.Messages;

public class DefaultReportImpl
implements Report {
    private static boolean DEBUG = false;
    private String ePubName;
    private int errorCount;
    private int warningCount;
    private int exceptionCount;
    private boolean quiet;

    public DefaultReportImpl(String ePubName) {
        this(ePubName, null, false);
    }

    public DefaultReportImpl(String ePubName, boolean quiet) {
        this(ePubName, null, quiet);
    }

    public DefaultReportImpl(String ePubName, String info) {
        this(ePubName, info, false);
    }

    public DefaultReportImpl(String ePubName, String info, boolean quiet) {
        this.quiet = quiet;
        this.ePubName = ePubName;
        if (info != null) {
            this.warning("", 0, 0, info);
        }
        this.errorCount = 0;
        this.warningCount = 0;
        this.exceptionCount = 0;
    }

    private String fixMessage(String message) {
        if (message == null) {
            return "";
        }
        return message.replaceAll("[\\s]+", " ");
    }

    @Override
    public void error(String resource, int line, int column, String message) {
        ++this.errorCount;
        message = this.fixMessage(message);
        System.err.println("ERROR: " + this.ePubName + (resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public void warning(String resource, int line, int column, String message) {
        ++this.warningCount;
        message = this.fixMessage(message);
        System.err.println("WARNING: " + this.ePubName + (resource == null ? "" : "/" + resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public void exception(String resource, Exception e) {
        ++this.exceptionCount;
        System.err.println("EXCEPTION: " + this.ePubName + (resource == null ? "" : "/" + resource) + ": " + e.getMessage());
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public int getExceptionCount() {
        return this.exceptionCount;
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        switch (feature) {
            case FORMAT_VERSION: {
                if (this.quiet) break;
                System.out.println(String.format(Messages.VALIDATING_VERSION_MESSAGE, value));
                break;
            }
            default: {
                if (!DEBUG || this.quiet) break;
                if (resource == null) {
                    System.out.println("INFO: [" + (Object)((Object)feature) + "]=" + value);
                    break;
                }
                System.out.println("INFO: [" + (Object)((Object)feature) + " (" + resource + ")]=" + value);
            }
        }
    }

    @Override
    public void hint(String resource, int line, int column, String message) {
        if (!this.quiet) {
            System.err.println("HINT: " + this.ePubName + (resource == null ? "" : "/" + resource) + ": " + this.fixMessage(message));
        }
    }
}

