
use strict ;
use warnings ;

use Module::Build;

my %all_modules ;
my @split_modules ;

my @pm_files = qw(
lib/App/Requirement/Arch/HTML/Flat.pm
lib/App/Requirement/Arch/Format/Flat.pm
lib/App/Requirement/Arch/Categories.pm
lib/App/Requirement/Arch/Filter.pm
lib/App/Requirement/Arch/Spellcheck.pm
lib/App/Requirement/Arch/Requirements.pm
lib/App/Requirement/Arch.pm
lib/App/Requirement/Multidimensional_Requirement_Database.pod

);

for(@pm_files)
	{
	$all_modules{$_} = $_ ;
	push @split_modules, $_ ;
	}

my @setup_lib=
qw(
) ;

for(@setup_lib)
	{
	$all_modules{$_} = "lib/App/Requirement/Arch/$_" ;
	}

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'App_Requirement_Arch_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#print "number of git revision: $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

my $code = <<'EOC';
use strict ;
use warnings ;

sub GetVersionAndRevisionFrom
{
my ($file) = @_ ;

my $version_from = File::Spec->catfile( split '/', $file );
my $version      = Module::Build->version_from_file($version_from);

if($ENV{'App_Requirement_Arch_USE_GIT_VERSION_FOR_DIST'})
	{
	my $number_of_commits = `git log | grep -E 'commit [0-9a-f]{40}' | wc -l` ;
	chomp $number_of_commits ;
	
	if($number_of_commits)
		{
		#print "number of git revision: $number_of_commits.\n" ;
		return("${version}.${number_of_commits}") ;
		}
	else
		{
		print "Couldn't get git revision, using version from '$file'!\n" ;
		return($version) ;
		}
	}
else
	{
	return($version) ;
	}
}

sub ACTION_author_test
{
my $self = shift;
local $self->{properties}{test_files} = 'xt/author/*.t' ;
$self->SUPER::ACTION_test();
}

sub ACTION_build 
{
my $self = shift;

if($ENV{'App_Requirement_Arch_USE_GIT_VERSION_FOR_DIST'})
	{
	my ($version) = GetVersionAndRevisionFrom('lib/App/Requirement/Arch.pm') ;
	
	#~ print "Generating version module ($version)\n" ;
	
	open VERSION, '>', 'Version.pm' or die "can't generate Version module: $!\n" ;
	
	print VERSION <<EOV ;
	
	# version module automatically generated by the build system
	
	package Config::Version ;
	
	sub GetVersion {return '$version'} ;
	
	1 ;
	
	# end of generated version module
EOV
	
	close VERSION ;
	}
	
$self->SUPER::ACTION_build(@_);
}

sub ACTION_dist
{
my $self = shift;

if($ENV{'App_Requirement_Arch_USE_GIT_VERSION_FOR_DIST'})
	{
	my $have_git = $self->do_system('git --version');
	
	if($have_git)
		{
		print `git status`;
		
		if($self->do_system('git log --decorate > git_Changes'))
			{
			use File::Copy;
			move('git_Changes', 'Changes') ;
			}
		else
			{
			print "Couldn't get git log, 'Changes' will not be generated from git log!\n" ;
			}
		}
	else
		{
		print "git not found, 'Changes' will not be generated from git log!\n" ;
		}
	}

$self->SUPER::ACTION_test() ;
#~ $self->ACTION_author_test() ;

$self->SUPER::ACTION_dist();
};


EOC

my $class = Module::Build->subclass(class => 'App::Requirement::Arch', code => $code) ;

my $build = $class->new
	(
	module_name => 'App::Requirement::Arch',
	
	dist_version => GetVersionAndRevisionFrom('lib/App/Requirement/Arch.pm'),
	
	license => 'perl',
	build_requires => 
		{
		'Text::Diff' => 0,
		'Test::Block' => 0,
		'Test::Exception' => 0,
		'Test::NoWarnings' => 0,
		'Test::Warn' => 0,
		'Directory::Scratch::Structured' => 0,
		},
	
	requires => 
		{
		'Readonly'         => 0,
		'Sub::Exporter'     => 0,
		'Check::ISA'              => '0.04',
		'Data::TreeDumper' => 0,
		'Data::TreeDumper::Utils' => 0,
		'Data::TreeDumper::Renderer::DHTML' => 0,
		'Proc::InvokeEditor' => 0,		
		
		'Cwd' => 0,
		'File::Basename' => 0,
		'File::Spec' => 0,
		'List::MoreUtils' => 0,
		'List::Util' => 0,
		'File::Slurp' => 0,
		'Module::Util' =>0,
		'Scalar::Util'            => '1.19',
		'File::HomeDir'           => '0.86',
		'Text::Pluralize' => 0,
		'Tie::IxHash' => 0,
		'Devel::Cycle' => 0,
		'App::Chained' => 0,
		},
		
	pm_files     => \%all_modules,
	#~ autosplit    => \@split_modules,
	
	script_files => 
		[
		'scripts/templates/master_template.pl',
		'scripts/templates/master_categories.pl',
		'scripts/templates/free_form_template.rat',
		'scripts/field_filters/requirement_fields.pl',
		'scripts/field_filters/flat_requirement_fields.pl',
		'scripts/field_filters/test_requirement_fields.pl',
		'scripts/ra',
		'scripts/ra_edit.pl',
		'scripts/ra_show.pl',
		'scripts/ra_show_flat.pl',
		'scripts/ra_spellcheck.pl',
		'scripts/ra_show_sorted_by_abstraction_level.pl',
		'scripts/Todo.txt',
		'scripts/ra_new.pl',
		'scripts/ra_new_batch.pl',
		'scripts/ra_check.pl',
		'scripts/examples/ir_done.pl',
		'scripts/ra_show_usecases.pl',
		],

	dist_author  => 'Khemir Nadim ibn Hamouda. <nadim@khemir.net>',
	dist_abstract => 'App::Requirement::Arch - Easy requirements creation and handling',
	);
	


use File::HomeDir ;
my $user_template = home() . '/.ra/templates' ;

if(-e $user_template)
	{
	print "Found default template in '$user_template'! You should diff your template "
		. "with the template that comes with this version of App::Requirement::Arch.\n\n" ;
	}
else
	{
	my $answer =  $build->y_n('Create a default template in your home directory?', 'no') ;
	
	if($answer == 1)
		{
		use File::Copy::Recursive 'rcopy' ;
		rcopy('scripts/templates', $user_template) or die "Can't copy the default template in your home directory: $!" ;

		print "\nThe default template was installed in '$user_template'.\n" ;
		}
	}

$build->create_build_script;
  

