package WordList::EN::PersonName::PopularBabyName::US::SSA::1940::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyName-US-SSA'; # DIST
our $VERSION = '0.003'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",11,"num_words",1000,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"avg_word_len",5.73,"shortest_word_len",2,"num_words_contain_unicode",0,"num_words_contains_unicode",0,"num_words_contains_nonword_chars",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1940 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyName::US::SSA::1940::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1940 (from Social Security Administration)

=head1 VERSION

This document describes version 0.003 of WordList::EN::PersonName::PopularBabyName::US::SSA::1940::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyName-US-SSA), released on 2020-05-22.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyName::US::SSA::1940::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyName::US::SSA::1940::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Iterate
 my $first_word = $wl->first_word;
 while (defined(my $word = $wl->next_word)) { ... }

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.73  |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-PersonName-PopularBabyName-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyName-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
James
Robert
John
William
Richard
Charles
David
Thomas
Donald
Ronald
George
Joseph
Larry
Jerry
Kenneth
Edward
Paul
Michael
Gary
Frank
Gerald
Raymond
Harold
Dennis
Walter
Roger
Billy
Joe
Jack
Bobby
Henry
Carl
Arthur
Daniel
Willie
Lawrence
Ralph
Eugene
Wayne
Fred
Albert
Roy
Peter
Jimmy
Howard
Anthony
Harry
Norman
Stephen
Louis
Johnny
Earl
Melvin
Leonard
Bruce
Douglas
Dale
Ernest
Stanley
Philip
Francis
Don
Marvin
Clarence
Samuel
Leroy
Bill
Frederick
Alfred
Gene
Allen
Russell
Terry
Patrick
Herbert
Tommy
Ray
Jim
Phillip
Lee
Eddie
Bernard
Glenn
Andrew
Martin
Jimmie
Franklin
Alan
Leon
Theodore
Gordon
Tom
Jesse
Clifford
Jerome
Edwin
Curtis
Harvey
Bob
Lloyd
Ronnie
Clyde
Floyd
Vincent
Vernon
Alvin
Lewis
Jackie
Barry
Warren
Charlie
Leo
Herman
Wendell
Allan
Cecil
Lester
Arnold
Steven
Victor
Steve
Mike
Jon
Gilbert
Keith
Danny
Calvin
Benjamin
Johnnie
Glen
Darrell
Milton
Rodney
Duane
Timothy
Leslie
Chester
Freddie
Jay
Joel
Roland
Tony
Dean
Elmer
Claude
Wallace
Manuel
Jose
Mark
Sam
Willard
Wesley
Lonnie
Nicholas
Dan
Neil
Hugh
Marion
Ted
Lynn
Maurice
Jessie
Brian
Edgar
Max
Virgil
Oscar
Sidney
Everett
Morris
Dick
Lowell
Lyle
Karl
Bennie
Nathaniel
Luther
Ben
Benny
Delbert
Marshall
Nelson
Jeffrey
Earnest
Homer
Dave
Hubert
Alexander
Gregory
Carroll
Fredrick
Guy
Wilbur
Alton
Stuart
Juan
Donnie
Matthew
Otis
Horace
Carlos
Clifton
Roosevelt
Clinton
Ira
Rudolph
Doyle
Alex
Willis
Leland
Laurence
Clayton
Archie
Loren
Oliver
Kent
Sammy
Troy
Julius
Myron
Wilbert
Garry
Tommie
Gerard
Perry
Byron
Malcolm
Rex
Dewey
Ivan
Salvatore
Sherman
Randall
Aaron
Jacob
Reginald
Pete
Julian
Neal
Jerald
Christopher
Edmund
Nathan
Carlton
Grady
Isaac
Dallas
Eldon
Eric
Pat
Billie
Darrel
Elbert
Merle
Jesus
Orville
Sylvester
Antonio
Rufus
Mack
Ross
Dwight
Teddy
Buddy
Wilson
Woodrow
Bobbie
Ruben
Ramon
Ellis
Junior
Clark
Rudy
Ervin
Irvin
Wade
Nick
Forrest
Darryl
Terrence
Angelo
Frankie
Felix
Bert
Sheldon
Craig
Randolph
Preston
Conrad
Boyd
Noel
Garland
Mickey
Owen
Travis
Aubrey
Phil
Tyrone
Jan
Harley
Burton
Sammie
Scott
Emmett
Daryl
Louie
Royce
Tim
Loyd
Winston
Percy
Mitchell
Wilfred
Chris
Grant
Kenny
Pedro
Marlin
Rodger
Darwin
Grover
Roberto
Gale
Freddy
Raul
Francisco
Ken
Mary
Lanny
Harlan
Kermit
Kevin
Micheal
Mario
Irving
Brent
Elwood
Norbert
Ned
Jeff
Amos
Jonathan
Moses
Edmond
Alfonso
Denis
Stewart
Cleveland
Emil
Cornelius
Lionel
Spencer
Murray
Andy
August
Alonzo
Maynard
Lance
Melvyn
Terrance
Carol
Ed
Marcus
Merlin
Errol
Austin
Luis
Thurman
Sanford
Adrian
Elton
Dominick
Dominic
Monte
Dwayne
Laverne
Johnie
Irwin
Bradley
Adam
Delmar
Otto
Jasper
Nolan
Carmen
Abraham
Gerry
Merrill
Ron
Shirley
Roscoe
Wiley
Lamar
Truman
Millard
Will
Odell
Salvador
Ricardo
Lorenzo
Norris
Weldon
Sterling
Charley
Elijah
Bryan
Elvin
Robin
Elliott
Ollie
Frederic
Hollis
Hal
Monroe
Armando
Barney
Guadalupe
Kurt
Coy
Gabriel
Simon
Hector
Kennith
Gail
Reuben
Denny
Buford
Emanuel
Emory
Erwin
Wilburn
Jerold
Randy
Harrison
Jake
Shelby
Adolph
Van
Clair
Lavern
Rolland
Ernie
Carrol
Galen
Jess
Miguel
Alfredo
Rene
Jackson
Al
Vance
Vern
Fernando
Levi
Linwood
Arturo
Roderick
Clement
Connie
Harris
Wilmer
Booker
Dewayne
Dudley
Hershel
Ulysses
Winfred
Gus
Russel
Jean
Mervin
Miles
Noah
Riley
Solomon
Geoffrey
Ronny
Armand
Fredric
Jerrold
Emery
Wilford
Denver
Kelly
Ward
Alphonso
Dana
Vaughn
Barbara
Basil
Cleo
Dickie
Eli
Patricia
Alberto
Gayle
Alva
Milford
Terence
Blaine
Cary
Delmer
Herschel
Morton
Gearld
Kirk
Morgan
Tracy
Clay
Dalton
Jeffery
Lenard
Earle
Gaylord
Major
Royal
Bradford
Evan
Houston
Emerson
Roman
Forest
Kay
Chuck
Enrique
Everette
Rocco
Domingo
Ernesto
Marc
Rodolfo
Cyril
Freeman
Monty
Thaddeus
Dannie
Odis
Silas
Jeremiah
Davis
Rafael
Sherwood
Terrell
Lyman
Alden
Andre
Bernie
Windell
Barton
Hiram
Luke
Orlando
Betty
Julio
Arlen
Burl
Isaiah
Kerry
Rogers
Claud
Jere
Elroy
Sonny
Tomas
Dwain
Kendall
Vito
Dexter
Garrett
Pablo
Pasquale
Talmadge
Warner
Gilberto
Anton
Carson
Joesph
Wilton
Bryant
Carmine
Arden
Elias
Elmo
Huey
Boyce
Harmon
Jefferson
Kirby
Abel
Alphonse
Olen
Anderson
Lupe
Milo
Orval
Shelton
Bennett
Christian
Dee
Eddy
Jules
Bud
Carey
Cletus
Felton
Rayford
Arther
Augustine
Buster
Hilton
Reynaldo
Augustus
Beverly
Felipe
Kyle
Olin
Fletcher
Jason
Normand
Raymon
Haywood
Benito
Emilio
Reed
Theron
Angel
Foster
Joshua
Lon
Sandy
Arlie
Elliot
Mathew
Merlyn
Carter
Coleman
Hoyt
Maxie
Rollin
Saul
Todd
Waymon
Duncan
Raleigh
Wilber
Art
Avery
Dorsey
Garth
Graham
Jacky
Judson
Lynwood
Alejandro
Donn
Dorothy
Doug
Reggie
Columbus
Donovan
Elden
Hobert
Justin
Oren
Seymour
Val
Bertram
Isiah
Joyce
Andres
Judith
Meredith
Franklyn
Gaylon
Lacy
Stan
Ignacio
Ivory
Otha
Santos
Garfield
Glynn
Mose
Noble
Stanford
Dewitt
Patsy
Vicente
Darold
Elvis
Mason
Ramiro
Toby
Alvis
Hermon
Winford
Bart
Cordell
Emmitt
King
Burt
Donny
Doris
Granville
Lemuel
Mckinley
Robbie
Theadore
Wally
Eldridge
Harland
Israel
Mac
Regis
Taylor
Walker
Williams
Cliff
Cyrus
Emile
Guillermo
Nancy
Orrin
Raphael
Rosevelt
Verlin
Lonny
Stanton
Arlin
Artis
Cruz
Delton
Lincoln
Lucius
Melton
Omer
Santiago
Alford
Ellsworth
Fritz
Hans
Adolfo
Bruno
Bryce
Garold
Mel
Palmer
Reynold
Sydney
Woody
Zane
Bonnie
Lane
Lawerence
Lucien
Stephan
Tex
Arlan
Edd
Hayward
Jewel
Jorge
Kim
Margaret
Matt
Myles
Newton
Leigh
Ambrose
Clarance
Damon
Domenic
Eduardo
Elwin
Joey
Lamont
Lauren
Nicky
Parker
Reid
Benedict
Curtiss
Farrell
Joan
Rayburn
Sharon
Verne
Duwayne
Enoch
Hardy
Walton
Artie
Brooks
Carleton
Ferdinand
Nickolas
Porter
Rogelio
Wardell
Wilkie
Edsel
Eloy
Ezra
Frances
Howell
Jame
Nicolas
Prince
Willian
Arvid
Arvin
Fay
Linda
Loy
Maxwell
Obie
Benton
Berry
Bertrand
Carlo
Clint
Colin
Glendon
Gregg
Haskell
Napoleon
Scotty
Toney
Delano
Greg
Jordan
Leeroy
Lesley
Ottis
Pierre
Prentice
Randell
Seth
Waldo
Wayland
Aurelio
Elisha
Garnett
Ian
Jerrell
Logan
Margarito
Quentin
Rupert
Douglass
Fidel
Hosea
Jewell
Leander
Marlyn
Rick
Abe
Crawford
Dennie
Gonzalo
Winfield
Asa
Dock
General
Mahlon
Marcel
Merritt
Murphy
Newell
Sherrill
Agustin
Danial
Donal
Durwood
Elizabeth
Elzie
Gerold
Gloria
Jonas
Rollie
Brady
Claudie
Cornell
Dillard
Milan
Randal
Rubin
Sal
Sebastian
Thad
Werner
Willam
Adolphus
Aloysius
Alvie
Cloyd
Derrell
Harrell
Ora
Valentine
Whitney
Wylie
Arlo
Ashley
Auther
Bernice
Burnell
Darvin
Derald
Drew
Dwaine
Ezekiel
Gregorio
Marty
Oneal
Romeo
Sandra
Weston
Arvil
Blair
Federico
Humberto
Isidro
Lindsey
Lonzo
Ricky
Stacy
Arlyn
Buck
Donna
Harlen
Janice
Javier
Len
Lenord
Orin
Von
Allyn
Author
Barrie
Carolyn
Gustave
Herb
Leamon
Lorin
Lyndon
Marcos
Ruby
Verl
Virgle
Wyatt
Cedric
Del
Duke
Laurance
Linus
Loyal
Lucious
Madison
Martha
Merton
Miller
Wendel
Woodie
Autry
Clem
Dayton
Dell
Early
Erik
Genaro
Giles
Hazel
Jennings
Lafayette
Lindell
Loran
Mitchel
Norval
Vernell
Virginia
Earlie
Edison
Ezell
Hobart
Jerrel
Judy
Junius
Llewellyn
Omar
Reyes
Rowland
Tillman
Albin
Arlis
Clovis
Donnell
Farris
Jamie
Lavon
