use Test::More qw(no_plan);

use strict;

# (JED, year, month, day)
# JED - Julian Ephemeris Date

my @list = qw(
    alexandrian
    bahai
    armenian
    coptic
    ethiopian
    gregorian
    hebrew
    islamic
    julian
    macedonian
    persian
    republican
    roman
    saka
    syrian
    tamil
    zoroastrian
);

my @alexandrian = (
	[1507231.5 , -564, 12, 6],
	[1660037.5, -145, 4, 12],
	[1746893.5, 93, 1, 29],
	[1770641.5 , 158, 2, 5],
	[1892731.5, 492, 5, 12],
	[1931579.5, 598, 9, 23],
	[1974851.5, 717, 3, 11],
	[2091164.5, 1035, 8, 24],
	[2121509.5, 1118, 9, 23],
	[2155779.5, 1212, 7, 20],
	[2174029.5 , 1262, 7, 7],
	[2191584.5, 1310, 7, 30],
	[2195261.5, 1320, 8, 25],
	[2229274.5, 1413, 10, 10],
	[2245580.5, 1458, 5, 29],
	[2266100.5 , 1514, 8, 5],
	[2288542.5, 1576, 1, 12],
	[2290901.5, 1582, 6, 29],
	[2323140.5 , 1670, 10, 6],
	[2334848.5, 1702, 10, 26],
	[2348020.5, 1738, 11, 19],
	[2366978.5, 1790, 10, 14],
	[2385648.5, 1841, 11, 27],
	[2392825.5, 1861, 7, 19],
	[2416223.5, 1925, 8, 11],
	[2425848.5, 1951, 12, 19],
	[2430266.5, 1964, 1, 19],
	[2430833.5, 1965, 8, 11],
	[2431004.5, 1966, 1, 26],
	[2448698.5 , 2014, 7, 8],
	[2450138.5, 2018, 6, 17],
	[2465737.5 , 2061, 3, 1],
	[2486076.5, 2116, 11, 11]
);

my @armenian = (
	[1507231.5,  -1138,   4,  10],
	[1660037.5,   -720,  12,   6],
	[1746893.5,   -482,  11,  22],
	[1770641.5,   -417,  12,  15],
	[1892731.5,    -82,   6,  10],
	[1931579.5,     24,  11,  18],
	[1974851.5,    143,   6,   5],
	[2091164.5,    462,   2,   3],
	[2121509.5,    545,   3,  23],
	[2155779.5,    639,   2,  13],
	[2174029.5,    689,   2,  13],
	[2191584.5,    737,   3,  18],
	[2195261.5,    747,   4,  15],
	[2229274.5,    840,   6,  23],
	[2245580.5,    885,   2,  24],
	[2266100.5,    941,   5,  14],
	[2288542.5,   1002,  11,  11],
	[2290901.5,   1009,   4,  25],
	[2323140.5,   1097,   8,  24],
	[2334848.5,   1129,   9,  22],
	[2348020.5,   1165,  10,  24],
	[2366978.5,   1217,  10,   2],
	[2385648.5,   1268,  11,  27],
	[2392825.5,   1288,   7,  24],
	[2416223.5,   1352,   9,   2],
	[2425848.5,   1379,   1,  12],
	[2430266.5,   1391,   2,  20],
	[2430833.5,   1392,   9,  12],
	[2431004.5,   1393,   2,  28],
	[2448698.5,   1441,   8,  22],
	[2450138.5,   1445,   8,   2],
	[2465737.5,   1488,   4,  26],
	[2486076.5,   1544,   1,  15]
);

my @bahai = (
	[2416223.5, 60, 2, 11],
	[2425848.5 , 86, 9, 6],
	[2430266.5 , 98, 11, 3],
	[2430833.5, 100, 2, 11],
	[2431004.5, 100, 11, 11],
	[2448698.5, 148, 20, 16],
	[2450138.5, 152, 18, 19],
	[2465737.5 , 195, 13, 7],
	[2486076.5 , 251, 7, 6]
);

my @coptic = (
	[1507231.5,  -870,  12,   6],
	[1660037.5,  -451,   4,  12],
	[1746893.5,  -213,   1,  29],
	[1770641.5,  -148,   2,   5],
	[1892731.5,   186,   5,  12],
	[1931579.5,   292,   9,  23],
	[1974851.5,   411,   3,  11],
	[2091164.5,   729,   8,  24],
	[2121509.5,   812,   9,  23],
	[2155779.5,   906,   7,  20],
	[2174029.5,   956,   7,   7],
	[2191584.5,  1004,   7,  30],
	[2195261.5,  1014,   8,  25],
	[2229274.5,  1107,  10,  10],
	[2245580.5,  1152,   5,  29],
	[2266100.5,  1208,   8,   5],
	[2288542.5,  1270,   1,  12],
	[2290901.5,  1276,   6,  29],
	[2323140.5,  1364,  10,   6],
	[2334848.5,  1396,  10,  26],
	[2348020.5,  1432,  11,  19],
	[2366978.5,  1484,  10,  14],
	[2385648.5,  1535,  11,  27],
	[2392825.5,  1555,   7,  19],
	[2416223.5,  1619,   8,  11],
	[2425848.5,  1645,  12,  19],
	[2430266.5,  1658,   1,  19],
	[2430833.5,  1659,   8,  11],
	[2431004.5,  1660,   1,  26],
	[2448698.5,  1708,   7,   8],
	[2450138.5,  1712,   6,  17],
	[2465737.5,  1755,   3,   1],
	[2486076.5,  1810,  11,  11]
);

my @ethiopian = (
	[1507231.5,  -594,  12,   6],
	[1660037.5,  -175,   4,  12],
	[1746893.5,    63,   1,  29],
	[1770641.5,   128,   2,   5],
	[1892731.5,   462,   5,  12],
	[1931579.5,   568,   9,  23],
	[1974851.5,   687,   3,  11],
	[2091164.5,  1005,   8,  24],
	[2121509.5,  1088,   9,  23],
	[2155779.5,  1182,   7,  20],
	[2174029.5,  1232,   7,   7],
	[2191584.5,  1280,   7,  30],
	[2195261.5,  1290,   8,  25],
	[2229274.5,  1383,  10,  10],
	[2245580.5,  1428,   5,  29],
	[2266100.5,  1484,   8,   5],
	[2288542.5,  1546,   1,  12],
	[2290901.5,  1552,   6,  29],
	[2323140.5,  1640,  10,   6],
	[2334848.5,  1672,  10,  26],
	[2348020.5,  1708,  11,  19],
	[2366978.5,  1760,  10,  14],
	[2385648.5,  1811,  11,  27],
	[2392825.5,  1831,   7,  19],
	[2416223.5,  1895,   8,  11],
	[2425848.5,  1921,  12,  19],
	[2430266.5,  1934,   1,  19],
	[2430833.5,  1935,   8,  11],
	[2431004.5,  1936,   1,  26],
	[2448698.5,  1984,   7,   8],
	[2450138.5,  1988,   6,  17],
	[2465737.5,  2031,   3,   1],
	[2486076.5,  2086,  11,  11]
);

my @gregorian = (
	[1507231.5,  -587,   7,  24],
	[1660037.5,  -169,  12,   5],
	[1746893.5,    70,   9,  24],
	[1770641.5,   135,  10,   2],
	[1892731.5,   470,   1,   8],
	[1931579.5,   576,   5,  20],
	[1974851.5,   694,  11,  10],
	[2091164.5,  1013,   4,  25],
	[2121509.5,  1096,   5,  24],
	[2155779.5,  1190,   3,  23],
	[2174029.5,  1240,   3,  10],
	[2191584.5,  1288,   4,   2],
	[2195261.5,  1298,   4,  27],
	[2229274.5,  1391,   6,  12],
	[2245580.5,  1436,   2,   3],
	[2266100.5,  1492,   4,   9],
	[2288542.5,  1553,   9,  19],
	[2290901.5,  1560,   3,   5],
	[2323140.5,  1648,   6,  10],
	[2334848.5,  1680,   6,  30],
	[2348020.5,  1716,   7,  24],
	[2366978.5,  1768,   6,  19],
	[2385648.5,  1819,   8,   2],
	[2392825.5,  1839,   3,  27],
	[2416223.5,  1903,   4,  19],
	[2425848.5,  1929,   8,  25],
	[2430266.5,  1941,   9,  29],
	[2430833.5,  1943,   4,  19],
	[2431004.5,  1943,  10,   7],
	[2448698.5,  1992,   3,  17],
	[2450138.5,  1996,   2,  25],
	[2465737.5,  2038,  11,  10],
	[2486076.5,  2094,   7,  18]
);

my @hebrew = (
	[1660037.5, 3593, 9, 25],
	[1746893.5,  3831, 7, 3],
	[1892731.5, 4230, 10, 18],
	[1931579.5,  4336, 3, 4],
	[1974851.5, 4455, 8, 13],
	[2091164.5,  4773, 2, 6],
	[2121509.5, 4856, 2, 23],
	[2155779.5,  4950, 1, 7],
	[2174029.5,  5000, 13, 8],
	[2191584.5, 5048, 1, 21],
	[2195261.5,  5058, 2, 7],
	[2229274.5, 5151, 4, 1],
	[2245580.5,  5196, 11, 7],
	[2266100.5,  5252, 1, 3],
	[2288542.5, 5314, 7, 1],
	[2290901.5, 5320, 12, 27],
	[2323140.5, 5408, 3, 20],
	[2334848.5,  5440, 4, 3],
	[2348020.5,  5476, 5, 5],
	[2366978.5,  5528, 4, 4],
	[2385648.5, 5579, 5, 11],
	[2392825.5, 5599, 1, 12],
	[2416223.5, 5663, 1, 22],
	[2425848.5, 5689, 5, 19],
	[2430266.5,  5702, 7, 8],
	[2430833.5, 5703, 1, 14],
	[2431004.5,  5704, 7, 8],
	[2448698.5, 5752, 13, 12],
	[2450138.5,  5756, 12, 5],
	[2465737.5, 5799, 8, 12],
	[2486076.5,  5854, 5, 5]
);

my @islamic = (
	[1660037.5, -813, 2, 24],
	[1746893.5, -568, 4, 2],
	[1770641.5, -501, 4, 7],
	[1892731.5, -157, 10, 18],
	[1931579.5 , -47, 6, 4],
	[1974851.5, 75, 7, 14],
	[2091164.5 , 403, 10, 6],
	[2121509.5, 489, 5, 23],
	[2155779.5 , 586, 2, 8],
	[2174029.5 , 637, 8, 8],
	[2191584.5, 687, 2, 21],
	[2195261.5 , 697, 7, 8],
	[2229274.5 , 793, 7, 2],
	[2245580.5 , 839, 7, 7],
	[2266100.5 , 897, 6, 2],
	[2288542.5 , 960, 10, 1],
	[2290901.5, 967, 5, 28],
	[2323140.5, 1058, 5, 19],
	[2334848.5 , 1091, 6, 3],
	[2348020.5 , 1128, 8, 5],
	[2366978.5 , 1182, 2, 4],
	[2385648.5, 1234, 10, 11],
	[2392825.5, 1255, 1, 12],
	[2416223.5, 1321, 1, 22],
	[2425848.5, 1348, 3, 20],
	[2430266.5 , 1360, 9, 9],
	[2430833.5, 1362, 4, 14],
	[2431004.5 , 1362, 10, 8],
	[2448698.5, 1412, 9, 14],
	[2450138.5 , 1416, 10, 6],
	[2465737.5, 1460, 10, 13],
	[2486076.5 , 1518, 3, 6]
);

my @julian = (
	[1507231.5,  -587,   7,  30],
	[1660037.5,  -169,  12,   8],
	[1746893.5,    70,   9,  26],
	[1770641.5,   135,  10,   3],
	[1892731.5,   470,   1,   7],
	[1931579.5,   576,   5,  18],
	[1974851.5,   694,  11,   7],
	[2091164.5,  1013,   4,  19],
	[2121509.5,  1096,   5,  18],
	[2155779.5,  1190,   3,  16],
	[2174029.5,  1240,   3,   3],
	[2191584.5,  1288,   3,  26],
	[2195261.5,  1298,   4,  20],
	[2229274.5,  1391,   6,   4],
	[2245580.5,  1436,   1,  25],
	[2266100.5,  1492,   3,  31],
	[2288542.5,  1553,   9,   9],
	[2290901.5,  1560,   2,  24],
	[2323140.5,  1648,   5,  31],
	[2334848.5,  1680,   6,  20],
	[2348020.5,  1716,   7,  13],
	[2366978.5,  1768,   6,   8],
	[2385648.5,  1819,   7,  21],
	[2392825.5,  1839,   3,  15],
	[2416223.5,  1903,   4,   6],
	[2425848.5,  1929,   8,  12],
	[2430266.5,  1941,   9,  16],
	[2430833.5,  1943,   4,   6],
	[2431004.5,  1943,   9,  24],
	[2448698.5,  1992,   3,   4],
	[2450138.5,  1996,   2,  12],
	[2465737.5,  2038,  10,  28],
	[2486076.5,  2094,   7,   5]
);

my @macedonian = (
	[1507231.5 , -275, 11, 30],
	[1660037.5  , 144, 4, 8],
	[1746893.5 , 382, 1, 26],
	[1770641.5  , 447, 2, 3],
	[1892731.5  , 781, 5, 7],
	[1931579.5 , 887, 9, 18],
	[1974851.5  , 1006, 3, 7],
	[2091164.5 , 1324, 8, 19],
	[2121509.5 , 1407, 9, 18],
	[2155779.5 , 1501, 7, 16],
	[2174029.5  , 1551, 7, 3],
	[2191584.5 , 1599, 7, 26],
	[2195261.5 , 1609, 8, 20],
	[2229274.5  , 1702, 10, 4],
	[2245580.5 , 1747, 5, 25],
	[2266100.5 , 1803, 7, 31],
	[2288542.5  , 1865, 1, 9],
	[2290901.5 , 1871, 6, 24],
	[2323140.5 , 1959, 9, 31],
	[2334848.5 , 1991, 10, 20],
	[2348020.5 , 2027, 11, 13],
	[2366978.5  , 2079, 10, 8],
	[2385648.5 , 2130, 11, 21],
	[2392825.5 , 2150, 7, 15],
	[2416223.5  , 2214, 8, 6],
	[2425848.5 , 2240, 12, 12],
	[2430266.5 , 2253, 1, 16],
	[2430833.5  , 2254, 8, 6],
	[2431004.5 , 2255, 1, 24],
	[2448698.5  , 2303, 7, 4],
	[2450138.5 , 2307, 6, 12],
	[2465737.5 , 2350, 2, 28],
	[2486076.5  , 2405, 11, 5]
);

my @persian = (
	[1660037.5, -800, 13, 6],
	[1746893.5, -562, 12, 22],
	[1770641.5, -497, 13, 15],
	[1892731.5, -162, 6, 15],
	[1931579.5, -56, 12, 18],
	[1974851.5, 63, 6, 10],
	[2091164.5, 382, 2, 8],
	[2121509.5, 465, 3, 28],
	[2155779.5, 559, 2, 18],
	[2174029.5, 609, 2, 18],
	[2191584.5, 657, 3, 23],
	[2195261.5, 667, 4, 20],
	[2229274.5, 760, 6, 28],
	[2245580.5, 805, 2, 29],
	[2266100.5, 861, 5, 19],
	[2288542.5, 922, 12, 11],
	[2290901.5, 929, 4, 30],
	[2323140.5, 1017, 8, 29],
	[2334848.5, 1049, 10, 22],
	[2348020.5, 1085, 11, 24],
	[2366978.5 , 1137, 11, 2],
	[2385648.5, 1188, 12, 27],
	[2392825.5, 1208, 7, 29],
	[2416223.5 , 1272, 10, 2],
	[2425848.5, 1299, 1, 17],
	[2430266.5, 1311, 2, 25],
	[2430833.5, 1312, 10, 12],
	[2431004.5 , 1313, 3, 3],
	[2448698.5, 1361, 8, 27],
	[2450138.5 , 1365, 8, 7],
	[2465737.5 , 1408, 5, 1],
	[2486076.5, 1464, 1, 20]
);

my @republican = (
	[2348020.5 , -76, 11, 6],
	[2366978.5 , -24, 10, 1],
	[2385648.5, 27, 11, 14],
	[2392825.5 , 47, 7, 6],
	[2416223.5, 111, 7, 29],
	[2425848.5 , 137, 12, 7],
	[2430266.5 , 150, 1, 7],
	[2430833.5, 151, 7, 29],
	[2431004.5, 152, 1, 14],
	[2448698.5, 200, 6, 27],
	[2450138.5 , 204, 6, 6],
	[2465737.5, 247, 2, 20],
	[2486076.5 , 302, 11, 1]
);

my @roman = (
	[1507231.5, 167, 7, 30],
	[1660037.5 , 585, 12, 8],
	[1746893.5, 823, 9, 26],
	[1770641.5 , 888, 10, 3],
	[1892731.5 , 1223, 1, 7],
	[1931579.5, 1329, 5, 18],
	[1974851.5 , 1447, 11, 7],
	[2091164.5, 1766, 4, 19],
	[2121509.5, 1849, 5, 18],
	[2155779.5, 1943, 3, 16],
	[2174029.5 , 1993, 3, 3],
	[2191584.5, 2041, 3, 26],
	[2195261.5, 2051, 4, 20],
	[2229274.5 , 2144, 6, 4],
	[2245580.5, 2189, 1, 25],
	[2266100.5, 2245, 3, 31],
	[2288542.5 , 2306, 9, 9],
	[2290901.5, 2313, 2, 24],
	[2323140.5, 2401, 5, 31],
	[2334848.5, 2433, 6, 20],
	[2348020.5, 2469, 7, 13],
	[2366978.5 , 2521, 6, 8],
	[2385648.5, 2572, 7, 21],
	[2392825.5, 2592, 3, 15],
	[2416223.5 , 2656, 4, 6],
	[2425848.5, 2682, 8, 12],
	[2430266.5, 2694, 9, 16],
	[2430833.5 , 2696, 4, 6],
	[2431004.5, 2696, 9, 24],
	[2448698.5 , 2745, 3, 4],
	[2450138.5, 2749, 2, 12],
	[2465737.5, 2791, 10, 28],
	[2486076.5 , 2847, 7, 5]
);

my @saka = (
	[1507231.5 , -664, 5, 2],
	[1660037.5, -246, 9, 14],
	[1746893.5 , -8, 7, 2],
	[1770641.5, 57, 7, 10],
	[1892731.5, 391, 10, 18],
	[1931579.5, 498, 2, 30],
	[1974851.5, 616, 8, 19],
	[2091164.5 , 935, 2, 5],
	[2121509.5 , 1018, 3, 3],
	[2155779.5 , 1112, 1, 2],
	[2174029.5, 1161, 12, 20],
	[2191584.5, 1210, 1, 13],
	[2195261.5 , 1220, 2, 7],
	[2229274.5, 1313, 3, 22],
	[2245580.5, 1357, 11, 14],
	[2266100.5, 1414, 1, 20],
	[2288542.5, 1475, 6, 28],
	[2290901.5, 1481, 12, 15],
	[2323140.5, 1570, 3, 20],
	[2334848.5 , 1602, 4, 9],
	[2348020.5 , 1638, 5, 2],
	[2366978.5, 1690, 3, 29],
	[2385648.5, 1741, 5, 11],
	[2392825.5 , 1761, 1, 6],
	[2416223.5, 1825, 1, 29],
	[2425848.5 , 1851, 6, 3],
	[2430266.5 , 1863, 7, 7],
	[2430833.5, 1865, 1, 29],
	[2431004.5, 1865, 7, 15],
	[2448698.5, 1913, 12, 27],
	[2450138.5 , 1917, 12, 6],
	[2465737.5, 1960, 8, 19],
	[2486076.5, 2016, 4, 27]
);

my @syrian = (
	[1507231.5, -275, 10, 30],
	[1660037.5 ,  144, 3, 8],
	[1746893.5,  381, 12, 26],
	[1770641.5 ,  447, 1, 3],
	[1892731.5 ,  781, 4, 7],
	[1931579.5,  887, 8, 18],
	[1974851.5 , 1006, 2, 7],
	[2091164.5, 1324, 7, 19],
	[2121509.5, 1407, 8, 18],
	[2155779.5, 1501, 6, 16],
	[2174029.5 , 1551, 6, 3],
	[2191584.5, 1599, 6, 26],
	[2195261.5, 1609, 7, 20],
	[2229274.5 , 1702, 9, 4],
	[2245580.5, 1747, 4, 25],
	[2266100.5, 1803, 6, 31],
	[2288542.5 , 1864, 12, 9],
	[2290901.5, 1871, 5, 24],
	[2323140.5, 1959, 8, 31],
	[2334848.5, 1991, 9, 20],
	[2348020.5, 2027, 10, 13],
	[2366978.5 , 2079, 9, 8],
	[2385648.5, 2130, 10, 21],
	[2392825.5, 2150, 6, 15],
	[2416223.5 , 2214, 7, 6],
	[2425848.5, 2240, 11, 12],
	[2430266.5, 2252, 12, 16],
	[2430833.5 , 2254, 7, 6],
	[2431004.5, 2254, 12, 24],
	[2448698.5 , 2303, 6, 4],
	[2450138.5, 2307, 5, 12],
	[2465737.5, 2350, 1, 28],
	[2486076.5 , 2405, 10, 5]
);

my @tamil = (
	[1507231.5, 2515, 5, 19],
	[1660037.5, 2933, 9, 25],
	[1746893.5, 3171, 7, 10],
	[1770641.5, 3236, 7, 16],
	[1892731.5, 3570, 10, 19],
	[1931579.5, 3677, 2, 27],
	[1974851.5, 3795, 8, 16],
	[2091164.5, 4114, 1, 24],
	[2121509.5, 4197, 2, 22],
	[2155779.5, 4290, 12, 19],
	[2174029.5 , 4340, 12, 6],
	[2191584.5, 4388, 12, 29],
	[2195261.5, 4399, 1, 22],
	[2229274.5 , 4492, 3, 6],
	[2245580.5, 4536, 10, 28],
	[2266100.5, 4592, 12, 32],
	[2288542.5, 4654, 6, 10],
	[2290901.5, 4660, 11, 26],
	[2323140.5, 4749, 2, 31],
	[2334848.5, 4781, 3, 20],
	[2348020.5, 4817, 4, 12],
	[2366978.5 , 4869, 3, 8],
	[2385648.5, 4920, 4, 18],
	[2392825.5, 4939, 12, 13],
	[2416223.5 , 5004, 1, 3],
	[2425848.5, 5030, 5, 10],
	[2430266.5, 5042, 6, 14],
	[2430833.5 , 5044, 1, 2],
	[2431004.5, 5044, 6, 21],
	[2448698.5, 5092, 11, 31],
	[2450138.5, 5096, 11, 10],
	[2465737.5, 5139, 7, 25],
	[2486076.5, 5195, 3, 31]
);

my @zoroastrian = (
	[1660037.5 ,  220, 12, 5],
	[1746893.5,  458, 11, 21],
	[1770641.5,  523, 12, 14],
	[1892731.5 ,  858, 6, 9],
	[1931579.5,  964, 11, 17],
	[1974851.5 , 1083, 6, 4],
	[2091164.5 , 1402, 2, 2],
	[2121509.5, 1485, 3, 22],
	[2155779.5, 1579, 2, 12],
	[2174029.5, 1629, 2, 12],
	[2191584.5, 1677, 3, 17],
	[2195261.5, 1687, 4, 14],
	[2229274.5, 1780, 6, 22],
	[2245580.5, 1825, 2, 23],
	[2266100.5, 1881, 5, 13],
	[2288542.5, 1942, 11, 10],
	[2290901.5, 1949, 4, 24],
	[2323140.5, 2037, 8, 23],
	[2334848.5, 2069, 9, 21],
	[2348020.5, 2105, 10, 23],
	[2366978.5 , 2157, 10, 1],
	[2385648.5, 2208, 11, 26],
	[2392825.5, 2228, 7, 23],
	[2416223.5 , 2292, 9, 1],
	[2425848.5, 2319, 1, 11],
	[2430266.5, 2331, 2, 19],
	[2430833.5, 2332, 9, 11],
	[2431004.5, 2333, 2, 27],
	[2448698.5, 2381, 8, 21],
	[2450138.5 , 2385, 8, 1],
	[2465737.5, 2428, 4, 25],
	[2486076.5, 2484, 1, 14]
);

for my $calendar (@list) {
    my $Calendar = ucfirst $calendar;
    eval "use Date::Converter::$Calendar";

    my @data;
    eval "\@data = \@$calendar";

    for my $item (@data) {
        my $jed = $item->[0];
        my ($y, $m, $d);
        eval "(\$y, \$m, \$d) = Date::Converter::${Calendar}::jed_to_ymdf($jed)";
        
        ok($y == $item->[1] && $m == $item->[2] && $d == $item->[3], "$Calendar JED=$jed, $y ($item->[1]) / $m ($item->[2]) / $d ($item->[3])");
    }
}
