#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util::GMP qw/prime_count/;

my %pivals = (
                   1 => 0,
                  10 => 4,
                 100 => 25,
                1000 => 168,
               10000 => 1229,
               65535 => 6542,
);

# Generated with:
#  perl -Mbigint -MMath::Prime::Util -E 'foreach my $e (64 .. 120) { my $start = 2**$e + int(rand(2**($e-1))); my $end = $start + int(rand(2000)); my $c = Math::Prime::Util::PP::prime_count($start, $end); say "  [\"$start\", \"$end\", $c]," }'
my @tests = (
  ["24113483758197309440", "24113483758197310396", 23],
  ["45490240575506677760", "45490240575506679266", 45],
  ["75458848506302300160", "75458848506302301114", 18],
  ["161891136728481923072", "161891136728481923850", 18],
  ["342679779996280025856", "342679779996280027487", 36],
  ["759817770139002651712", "759817770139002652700", 26],
  ["1747599191389174303424", "1747599191389174303464", 1],
  ["3277252439479060606848", "3277252439479060607688", 12],
  ["6887003433586725213696", "6887003433586725213705", 0],
  ["9515645314265862127392", "9515645314265862128163", 15],
  ["26114788673620260854784", "26114788673620260855763", 17],
  ["50021095190478561709568", "50021095190478561710552", 16],
  ["99293609391529723419136", "99293609391529723420902", 20],
  ["192328541043198946838272", "192328541043198946839023", 18],
  ["386730387965240293676544", "386730387965240293678117", 29],
  ["735479117913496587353088", "735479117913496587354687", 32],
  ["1330998807397722174706176", "1330998807397722174706347", 3],
  ["2904510561226220349412352", "2904510561226220349413930", 21],
  ["6847845859597286698824704", "6847845859597286698826460", 26],
  ["9880100064397462397649408", "9880100064397462397650566", 17],
  ["27282839498809356795298816", "27282839498809356795300564", 23],
  ["41281035060688503590597632", "41281035060688503590598867", 15],
  ["90374604407955267181195264", "90374604407955267181195457", 2],
  ["200915297903707834362390528", "200915297903707834362391737", 22],
  ["407168505212786768724781056", "407168505212786768724782199", 16],
  ["817226365950024137449562112", "817226365950024137449563070", 14],
  ["1621795554319024274899124224", "1621795554319024274899125678", 18],
  ["3660769329531840549798248448", "3660769329531840549798250278", 23],
  ["7314734077273801099596496896", "7314734077273801099596498034", 16],
  ["10921064834678012199192993792", "10921064834678012199192994171", 5],
  ["24344155473536054398385987584", "24344155473536054398385988831", 14],
  ["46348470312928428796771975168", "46348470312928428796771976813", 28],
  ["90920702154966737593543950336", "90920702154966737593543951561", 19],
  ["233651247954773375187087900672", "233651247954773375187087901872", 16],
  ["396231658265327350374175801344", "396231658265327350374175803015", 25],
  ["734317226076915700748351602688", "734317226076915700748351602878", 0],
  ["1696551122155337401496703205376", "1696551122155337401496703205528", 1],
  ["3100618561736693802993406410752", "3100618561736693802993406411961", 22],
  ["6306554584349917605986812821504", "6306554584349917605986812822041", 9],
  ["12897043632271155211973625643008", "12897043632271155211973625643214", 3],
  ["27070533331838590423947251286016", "27070533331838590423947251286519", 5],
  ["44933719679228300847894502572032", "44933719679228300847894502574007", 26],
  ["92067632902534481695789005144064", "92067632902534481695789005144486", 7],
  ["219741981610812063391578010288128", "219741981610812063391578010289366", 22],
  ["441164516482197726783156020576256", "441164516482197726783156020576737", 5],
  ["783694033185045453566312041152512", "783694033185045453566312041152692", 1],
  ["1754258052575393907132624082305024", "1754258052575393907132624082305337", 4],
  ["3291172491135828814265248164610048", "3291172491135828814265248164611897", 21],
  ["5255505796082429028530496329220096", "5255505796082429028530496329221910", 27],
  ["12176969828012415257060992658440192", "12176969828012415257060992658440427", 5],
  ["22889636161029770514121985316880384", "22889636161029770514121985316881826", 17],
  ["44359130889092671028243970633760768", "44359130889092671028243970633762444", 17],
  ["94248617103459242056487941267521536", "94248617103459242056487941267522522", 16],
  ["191861723074481884112975882535043072", "191861723074481884112975882535043603", 10],
  ["396766049747924068225951765070086144", "396766049747924068225951765070087394", 10],
  ["884985931172514936451903530140172288", "884985931172514936451903530140172881", 9],
  ["1969978340430920872903807060280344576", "1969978340430920872903807060280346393", 17],
);


plan tests => 4 + scalar (keys %pivals) + scalar @tests;


# TODO: error cases
is( prime_count(0,1), 0, "prime_count(0,1) == 0");
is( prime_count(0,2), 1, "prime_count(0,2) == 1");
is( prime_count(0,3), 2, "prime_count(0,3) == 2");
is( prime_count(2,2), 1, "prime_count(2,2) == 2");
while (my($n, $pin) = each (%pivals)) {
  is( prime_count(2, $n), $pin, "Pi($n) = $pin" );
}

foreach my $t (@tests) {
  is( prime_count($t->[0], $t->[1]),
      $t->[2],
      "prime_count($t->[0],$t->[1]) = $t->[2]" );
}
