package OpenSky::API::Core;

use Moose;
use OpenSky::API::Types qw(
  ArrayRef
  Defined
  InstanceOf
  Num
  PositiveOrZeroInt
  Str
  Undef
);
our $VERSION = '0.002';
use experimental qw(signatures);

around 'BUILDARGS' => sub ( $orig, $class, $state ) {
    my %value_for;
    @value_for{ $class->_get_params } = @$state;
    return $class->$orig(%value_for);
};

sub _get_params ($class) {
    croak("You must override _get_params in $class");
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

OpenSky::API::Core

=head1 VERSION

version 0.002

=head1 AUTHOR

Curtis "Ovid" Poe <curtis.poe@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Curtis "Ovid" Poe.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
