# Generated by default/object.tt
package Paws::CloudFront::OriginRequestPolicyHeadersConfig;
  use Moose;
  has HeaderBehavior => (is => 'ro', isa => 'Str', required => 1);
  has Headers => (is => 'ro', isa => 'Paws::CloudFront::Headers');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::OriginRequestPolicyHeadersConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::OriginRequestPolicyHeadersConfig object:

  $service_obj->Method(Att1 => { HeaderBehavior => $value, ..., Headers => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::OriginRequestPolicyHeadersConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->HeaderBehavior

=head1 DESCRIPTION

An object that determines whether any HTTP headers (and if so, which
headers) are included in requests that CloudFront sends to the origin.

=head1 ATTRIBUTES


=head2 B<REQUIRED> HeaderBehavior => Str

Determines whether any HTTP headers are included in requests that
CloudFront sends to the origin. Valid values are:

=over

=item *

C<none> E<ndash> HTTP headers are not included in requests that
CloudFront sends to the origin. Even when this field is set to C<none>,
any headers that are listed in a C<CachePolicy> I<are> included in
origin requests.

=item *

C<whitelist> E<ndash> The HTTP headers that are listed in the
C<Headers> type are included in requests that CloudFront sends to the
origin.

=item *

C<allViewer> E<ndash> All HTTP headers in viewer requests are included
in requests that CloudFront sends to the origin.

=item *

C<allViewerAndWhitelistCloudFront> E<ndash> All HTTP headers in viewer
requests and the additional CloudFront headers that are listed in the
C<Headers> type are included in requests that CloudFront sends to the
origin. The additional headers are added by CloudFront.

=back



=head2 Headers => L<Paws::CloudFront::Headers>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

