#!/usr/bin/perl

use strict;
use warnings;
use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC'; use Test::More;
use Test::Differences;
use MIME::Base64;
use Crypt::OpenToken;

###############################################################################
# TEST DATA
my @test_data = (
    {   # generated w/PingFederate
        password_base64 => 'ZGV2bnVsbA==',
        token => 'T1RLAQIuM613CkMJieBnFdjLq6Mo86mIHxABH-fPXvA5XjmfNu0fN5seAACgFPRXq3zvqry6g1AedGjUmBxVaKp2yAnN0dKrJ6FtLdG0ZFD6eV9FAW3eFOULExTiJNBBVe2qu7w3Csk7CzNRt0YXQMEsd_UDe0qpqWI2Wfd68CUr3OJuKMS6O5_3dYLscoyD4-QZNxGXkPkZZsMYiE2-vxIUlNazwyLTdBZ3K26tkER71siWwKUbsOA1H2Sexzk6iDCWpAtzo407lIJT6w**',
        data  => {
            'subject'         => 'devnull1@socialtext.com',
            'not-on-or-after' => '2010-09-10T21:53:43Z',
            'not-before'      => '2010-09-10T21:48:43Z',
            'authnContext'    => 'urn:oasis:names:tc:SAML:2.0:ac:classes:Password',
            'renew-until'     => '2010-09-11T09:48:43Z',
        },
    },
);

###############################################################################
# How many tests are we running?
eval { require Crypt::Rijndael; }
    or plan skip_all => 'Crypt::Rijndael not installed';
plan tests => (scalar @test_data * 2);

###############################################################################
# Decryption; can we parse an OpenToken generated by another implementation?
decryption: {
    foreach my $suite (@test_data) {
        my $token    = $suite->{token};
        my $data     = $suite->{data};
        my $password = decode_base64($suite->{password_base64});

        my $factory   = Crypt::OpenToken->new(password => $password);
        my $decrypted = $factory->parse($token);
        eq_or_diff $decrypted->data(), $data,
            'AES-256; decrypt externally generated data';
    }
}

###############################################################################
# Round-trip; if we encrypt/decrypt the data, do we get the data back out?
round_trip: {
    foreach my $suite (@test_data) {
        my $token    = $suite->{token};
        my $data     = $suite->{data};
        my $password = decode_base64($suite->{password_base64});

        my $factory   = Crypt::OpenToken->new(password => $password);
        my $encrypted = $factory->create(Crypt::OpenToken::CIPHER_AES256, $data);
        my $decrypted = $factory->parse($encrypted);
        eq_or_diff $decrypted->data(), $data,
            'AES-256; encryption/decryption round-trip';
    }
}
