# NAME

ore

# ABSTRACT

Sugar for Perl 5 one-liners

# SYNOPSIS

    BEGIN {
      $ENV{New_File_Temp} = 'ft';
    }

    use ore;

    $ft

# DESCRIPTION

This package provides automatic object instantiation based on environment
variables. This package exists because I was bored and inspired by [new](https://metacpan.org/pod/new).

## examples

Simple command-line example using env vars to drive object instantiation:

    $ New_File_Temp=ft perl -More -e 'dd $ft'

    # "File::Temp"

Another simple command-line example using env vars to return a
[Data::Object::Space](https://metacpan.org/pod/Data::Object::Space) object which calls `children` and returns an arrayref
of [Data::Object::Space](https://metacpan.org/pod/Data::Object::Space) objects:

    $ Use_DBI=dbi perl -More -e 'dd $dbi->children'

    # [
    #   ...,
    #   "DBI/DBD",
    #   "DBI/Profile",
    #   "DBI/ProfileData",
    #   "DBI/ProfileDumper",
    #   ...,
    # ]

Here's another simple command-line example using args as env vars with ordered
variable interpolation:

    $ perl -More -E 'dd $pt' New_File_Temp=ft New_Path_Tiny='pt; $ft'

    # /var/folders/pc/v4xb_.../T/JtYaKLTTSo

# AUTHOR

Al Newkirk, `awncorp@cpan.org`

# LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the ["license
file"](https://github.com/iamalnewkirk/ore/blob/master/LICENSE).

# PROJECT

[Wiki](https://github.com/iamalnewkirk/ore/wiki)

[Project](https://github.com/iamalnewkirk/ore)

[Initiatives](https://github.com/iamalnewkirk/ore/projects)

[Milestones](https://github.com/iamalnewkirk/ore/milestones)

[Contributing](https://github.com/iamalnewkirk/ore/blob/master/CONTRIBUTE.md)

[Issues](https://github.com/iamalnewkirk/ore/issues)
