package Acme::MetaSyntactic::lotr;
use strict;
use Acme::MetaSyntactic::MultiList;
our @ISA = qw( Acme::MetaSyntactic::MultiList );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::lotr - The Lord of the Rings theme

=head1 DESCRIPTION

Many characters of J. R. R. Tolkien's I<Lord of the Rings> bear several
names. This theme collects some of the main characters names.

The names of Sauron, Gandalf and Aragorn come from Robert Foster's I<Complete Guide to Middle-Earth>.
Turin's names were found in I<The Silmarillion>.

=head1 CONTRIBUTOR

Jean Forget

=head1 CHANGES

=over 4

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-06-19

Introduced in Acme-MetaSyntactic version 0.79.

=item *

2005-09-12

Jean Forget provided the names of Turin and Sauron.

=item *

2005-08-05

Jean Forget provided the idea for the theme,
along with the names of Gandalf and Aragorn.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::MultiList>.

=cut

__DATA__
# default
sauron
# names sauron
Sauron
Thauron
Gorthaur_the_Cruel
Sauron_the_Deceiver
the_Lord_of_the_Earth
the_Enemy
the_Master
the_Dark_Power
the_Dark_Lord
the_Lord_of_Mordor
the_Dark_Lord_of_Mordor
the_Power_of_the_Black_Land
the_Black_Master
the_Black_One
the_Lord_of_Barad_dur
the_Lord_of_the_Dark_Tower
the_Shadow
the_Great_Eye
the_Red_Eye
the_Eye_of_Barad_dur
the_Lidless_Eye
the_Evil_Eye
the_Nameless
the_Nameless_One
the_Nameless_Eye
He
Him
the_Lord_of_the_Ring
the_Lord_of_the_Rings
the_Ring_Maker
the_Black_Hand
# names gandalf
Gandalf
Mithrandir
Grey_Wanderer
Grey_Pilgrim
Tharkun
Incanus
Gandalf_Greyhame
Stormcrow
Lathspell
the_Grey_Fool
the_Enemy_of_Sauron
the_White_Rider
Olorin
# names aragorn
Aragorn
Elessar
Elfstone
Strider
Telcontar
Isildur_s_Heir
the_Renewer
Longshanks
Wing_foot
# names turin
Turin
Neithian
Gorthol
Argwaen_son_of_Urmarth
Adanedhel
Mormegil
Wildman_of_the_Woods
Turambar
Dagnir_Glaurunga
