package Kids::Soap;

use strict;
use warnings;

use base 'Kids::GEN::Soap';

#-----------------------------------------------------------------
# $self->namespace(  )
#-----------------------------------------------------------------
# This method inherited from Kids::GEN::Soap

#-----------------------------------------------------------------
# $self->get_soap_ops(  )
#-----------------------------------------------------------------
# This method inherited from Kids::GEN::Soap

#-----------------------------------------------------------------
# $self->getBirthDay(  )
#-----------------------------------------------------------------
sub getBirthDay {
    my ( $self, $input ) = @_;

    my $child_name = uc $input->{ childName };

    my %children = (
        'JOEY' => '2006-12-19',
        'SUZY' => '2003-02-02',
    );

    return {
        childNameReturn => $children{ $child_name } || 'no_such_child'
    };
} # END getBirthDay

1;

=head1 NAME

Kids::Soap - A controller in the Kids application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use Kids::Soap;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'Kids::Soap',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use Kids::Soap;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler Kids::Soap
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item getBirthDay

=item get_orm_helper


=back


=head1 METHODS INHERITED FROM Kids::GEN::Soap

=over 4

=item namespace

=item get_soap_ops


=back


=head1 DEPENDENCIES

    Kids
    Kids::GEN::Soap

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
