#!/usr/bin/perl
# based on fl6.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

$MPEG::Audio::Frame::lax = 1;

my $last;
for (1 .. $n){ SKIP: {
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	skip "bad file?" => 7 if $_ == 36;
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 44100, "sample rate");
	ok($frame->stereo, "stereo");
}}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
X                        d<N@=O p `  0   @  `Chp / E8	 @%l X @a }{63H9`@?C ]?0{), GoР|@~- 0vuѠn=Po@zР,J.q͠kРnDFkܠx7ؠEk˦|hߠw/Jƌ蠠.lnb).ń*c3
2C#CіB Ǡkݓ]1s栨n5˳r7&!Vcqf
u>Ƞ\vz_          mݠݠ                        c<O<8Nנ/
ﶠc
"?7|ߠvԮlŠeI@~^Y8k:W2J(pя21hKv&-)OU^6iΖ}Ҡrנ[$X/<]NǠ,JxF(|h&c!k˝P_h] ϪE=VYo.d
sy"}-ٱ*J1ݠcCY_M?ظ𠿗R3pTѠᦡfQ~86fz-Bi优֜5Q*ؠ懠|	Qqebcؙ!
ixzו~Z1                              )̠̠                        c8<M4Pj54t/ĠJkTwY3ItZzwNFz lG3K^D0bFﾠ0`Xʗ͠ZԠS-d?&ޠW*נKXVʠlȠI܇"#F^2S/^{ǇjsoU
i*ؠzdEw8*6^@V=)쟠JT&Ӡk'dj"(iԩqz<11o h39٠7
'nur3Ė`G=b.1h	d`堔\~&KR
N5ƠQV                                                          zA                c
88ӎ0N8à8ӏ4N8~J
]?ev.xV{UBྠ=Ycָah2kIV&X5EY_z`ul^۠wy@sD%Π:y;~(:nҲpPPH=v2̠@+X4$AM5ؠF)\-C(]mYU
lt #
`,%@⠛t頻
TMHf Vktu%aQQZ߮9ZĠ8ge%Pf)csr:Dgty>كe dki|DT'w44Uie瞠ߠuHPc"e%YhU                  """"""""                cN4ND800
,<^"
\	ἠujC<FK}7{]/Р#3i$ʛAE3A  >/Š (]T|^砪BW(3&_KxE*#噠砷K_נ5a+yq$DҸy^[^+MǠM:(V#ciaR<ryTQ͠IZ۠z8
[י|扬^8%Q#DʜmZ5Xhmȗtj]-VX㼠sS%Y'P49\bs jEnlbT.ԝVd3Ơ׎Q):V]O&:[=(:L!                      晙33333333                c08M8N4㠏4M8N<M7%V`lxE~gxlF`uG{x|cԞ"Z[WT5AKW2<लᠡ')u=ʊU$,xA9cƹ erW]kԠi<=WV;tc;Uǂh}{Z&vFG~+gWm(_?wzҶW9删:xpvQHf<u>Ǡa琠be
QΠHZi;|c:u]YSʴhffY^.k<ڠm砻iٔ("$X9'RjeAZij׷y{!)eɠx3R&ɠ˪HVIP                  d4DDDDDDDD                c0Ë0K@L8㠍8L8K4NktXba9&чs^(50/e٤'fv&.2C 堹h٠j3o4eΚW,?nFF_kB	kfӠso(ˠtğ*+ܽq Vl,Y!U@nՠajEvlnE'ߠɴ4"mu'IQT!5BpK҂렾snd&N<#c O u(]Ǡdn6iJ'(Ġ-俠Ӆ;4ݠAAEhUw9
w&5M*
6;rkW ํ?B7h;*MaZqbPˠ=iBď]'                      wwwwwwwwUUUUUUUU                cO<4O4N80O84ߠQ㉢ԋxY}"TtDSllw yn T.ҕw5w𠝷9}SqCl4'
4j_$m7kTf1^àbzǜ3Eg堬YrPs7xwJbࠀ|w`5qeg#栻R$T8M/p7xvEnXՠgl˖Zh3I4L0}٠ۚ)[mWzIQ8VؠluI%4'||vDrmWg@=nE`/lPngڠcF7`z{tf2.)񠽑"                  rNffffffffffffffff                c40N88Ӡ,ӌ84瞠qVMZp4̠ffʨ([
.=Ӷop[d͠נqȀ&rN1ŧ/٠v|19R58ⅠQGCײh-çcRqr-ҳغ2QǗ*ݠVȠHl2uYTڠ+*MLϤgtF)./Fota=m+
2VMtZRi+E޷>10AmBa	R֠QvXtAƸdjMPΠ8/3֠QUȓ4l4Π*Π~\Q^&XA۠%ؠǠiQܠb"a;"l8#+:屠Kͽ)U~T@MˮS,                      q;UUUUUUUUwwwwwwww                c
8ӎ854ODӋ84
ÇjoZ>([R͜pZvai9؃*2vV!፠ht\u0zuƠ[Q+נ6]s`TtHצܠ`àؖAՠ
ЃٕtׇنV(osmP<^VRWwMp+z\u`G9}ٶ`ϘX4Z;<g<s<VB vyB{6]tebƠ
Π%\c~k ϦR&QǠCAbk*ϼ,cشxҏos%x\xjזP85 àToSc}L\DdǠ!uPi2ތJ$o]kq                  DDDDDDDD                c<K8L<Ӎ0M4Π@Ӎ4Nh&gS#A^7UxqgJcy	dGBsV6at':_PPGlɠ̉NyúSǠ@]E-!Ơ
p,נJQnmuTݖݐ*es]X#&젲GzVg㿠ܠHRE#֠(%..РL
ˠ(I,ցY-SJ4+l	cR
:K#֒"Dk^@
UfX0cCܲqb'y8'<VkMzZ>M+ߠ=IР,W2kݠPzuƢ|RSygTeFѠ+J$                      33333333                c<ӎ848㠐8Ϡ0@ݱĔʳ|oZa;1!)}*h(ՠҎZ̠<%nzۏؠwv1YIe
̝֠ɠZى9S5fd͉9PG*J1E/BjzViW aiN"X~gYeSLh$ߜ|:Ơct"TIŠInJ6+ޠnUHMތeS+,MT)YhUWGi<HW*UCZ[sܗ0q|遠=KBs15sdGۘ]x֖Dh̠F ᠅u]fTkdft2*)Mՠ
#ֶr                  """"""""                cM@
-
48㠏0͠@Ӎ4El\4[&FÙSdο	4I&'ʠ#k&䠏KSڬ
	G?DӖ)LP\$&e-y%؈͠ˠtT֐ZjnؠMJŦ,7c5,r>jCVhfYpX
lLkqY:>?rA92fxr(sꅠϠk\v0]jZtR_uD|}?e	s
һiAj4rv[̠(*ŠGdK4X4DF!$ɠ/cXuGn;GضU\b(I)Ƞ]h	CR>                      p                c0M0<8Ӡ8N48ӌAdfyEPH;FMz
\cݥIe	)wbz*Eנj U\U6yygdSdEZ&\)lkcVFo$ǘlhY].pBz/	P*Xx{'haY<%HR{LMw&x!Wޠ$Ddb\$^5q+slu7و6Be`ij)+S+HJgàˡAhM&Dd,Ϭgw0	굠KeefGT_{<])}W%UBID1ߪm`#m{t7Ƞhb<7rHvU G]w                          ̠̠                4
8M4Î4-MpN4T
-HQ4M*G0uIM[ .W2D$rh6
C]_yE3@c,8b?.⠙7Į	y1bנA14y6FԠ$)	&à
81J«7hx𧠨ZJTͭ9:|=L-Ƿڠ7Ջ&"RVF*TEgv+鮁gMDݠ69tYA2Qʠr}	8=w+ݨ֠`Rl
TZ2k</ǠmVlq3qG_`2'ǠZ                                                                  ݠݠ                80Î8M<ΛMWq徠yK f/Uhޠ4ɪ2REZkJἆ׵m,znI7ՠ@P
!נBDGJGçXv\!+}(<ess{;*R$9X^78lx}pBh6Uaʠ?t S^gt7FqpӮ+]acfPen_=c۠*tw͖ؠ/@ZCt;eԠĤ		9
8dNYPeW[@
`[ҠIGv8(VMG@ܽ#šE1Ȭ9s5$JnFGt姠+GԠbE^s0%|                              "                        4N0Ϡ<
4ӌ AGB6iٺO^$q
AAHfݡy.K=Lg^W_fEݲ0)l:ɠ9렿#r#`5ܠʬ۽%+nk`,
	Mk5\/9Ԡ%l.P>TCi߻R"gW._r3n"gxKޠAR̠wΠz
цQA/_"Y%3?i8̸md}@1Ӡ',\ƠMԴ?[iu?9}e/q FYDQ {]Ӡ	3 $
0Kp..lic^K}w9jA          g                        0M4㍠84Mވb^GxkrQ2ja$,MOhGk`sjʠ9{Ih/MSU)v/kZx12#*
(bRaHKn7%D|z0KPJ<mALKTɜ Ġ][_c٠*6+t㤠l.@[ێ>hc 7o/߶ޠ'abs]*6Np7p%;kҠg! `T*ZDvz==PРr
{4h:~.KFk?5tNK4-0N8X͠X-̃L1sF/Sf|f	n(ɠ,ޠB>|D\FȠ
Nv      M                ݠݠ        88N@M8OvbN%BUzՊ*׸e|!JӝKLwXBa"Xɠ`{0̠@NF|PeITQvd<QȠE-oQuo}HsB&7BBg}pOE9a򠇐:㤠Dڠǯ gDUګG*n=\Y&SPs
-uY۠Z&o^$~AT/0-bpA%8UP *].xYr٠8s(ZxaPh\=y^5GyƠsҠTlĠZVDߠXJ"9̠ylśpI̠QyN
sOkafXՠ                                  .                ̠̠        84㍠449'>N7p[jmw}J[m
,ՠN[?`ޠ9wYQiq l'Vj=Ӡ})l#t
@'hR,6?N!>^i3͠DՠXqQzY]
 WO*W'ك8۠&Ҡ?7Qԩ2K!umR&?Klt ѪРҠC}wE[3/M󰐠4=
.sŠJe"X+#)=jVȠƸ토dؠު@"VbxcuXyX'P1                                                                      4Ӡ4͠84L0Ӡ<M0ӏ4m"^bk-1ՠaA7U7QĠӠWbUݰK4UUHaXb 8EMN|`T[6p=yU=j11;c^0gFUbol@碬\t󫠃ww>FVU#ɠ&Ԡkؠl\s̠IGiD@Ԡ%gaktF @*xFՠzu QtI`}aƐ]>qOpIiYVŜ.LTΠlљԊܠϠHU=$3b6$DzoYVVUf?9:}%T|878.VFA}HCUڵxPX8^ѠTܠhUXV                      1                """"""""<Ӡ<4L48Ġ0ӏ<8RɠNsX%ze1T̠geĠ̭HՠLm$&QHc al7S8J$<L\Ơ+@C!ʠ%Z
qvaFOmQZKu =&EmVנX'sI$wCɠM۠.&Xuj_q?VJ)~/ꠍ4]Z]	RyS@X4o:F栮 R+Ѡ:
pI21|oY@殠,([)d0-ܓd.;5I>e]`D&`aМ謠OfnN<.>c)SJFB,tTL{0CpsFۥmȘ(.
t8eqN65                  Y?                3333333384004㠎,ӏ8Ӎ8XJRicfdq̠eSᘠޯUxܚh}Fpo~ዠFĜ>#әdY{~$痉%
TxРw蠪QSYÅ57MQN蠏rjxUw{ߠ)L e+ƠYHGIjƠ~L vqExJ&٠Rӥ6[Xʒ+fo->`Ri)iǎɠ>TT;`W/1m砊xxZc*ԠG7*T(fҁwefD!q%HWS\]FM!=OJ]ĠLi>y +Ǯxbf
GO_>zZ
fdZ                                       DDDDDDDD8<㏠<,
@8Ӎ4L48
S#	sMx:ʅk8+3fẠP[H=+XfV~tӻk2Jkzw"FѠG1$4i֩v̬c<

E.
][?Cՠ+*ph{Ŋ^笠@[\YРE݃~4J{fae]0(`'٩Fق|mנU۠rY` keL{9)}a1Ss
>Od%ܠUˠnV`L(Pʌe'+SyD>n29z.Zi$S(Hޠo^
1t(EJɠ%rhL(,H6                                  wwwwwwwwUUUUUUUU8ӠN<
4Ӌ<ӏ<5N<8$OΠVf9W))Z&,QlTv~V
_Ik*'@}ӨbQ^x\wsLBr	#40PSowtbcw
|_-[P-֠rr Yޣ7gѠ̪점}ggpv6Zn)]عȠ^IC]ϕP.Sj$P@˓rP!jJnPhN8lƧffΠu&OUXnd@4z
Ji{Lꠇdie.⊖`gR8V8EZ>Ҡfv|n`xvlVXX}1XIeVLJ                                      ffffffffffffffff8N4M44ӑ@Ӡ0͠@K0@
M0v}נ)ӅӠ6ջW=nnyVdRrw&oe+/:"잠jdѻx_e.1S}ܠ:I=$(^%h*Txh=.fnUtFP8̔	gdL,Br&f&̟u2Kw@|a֠-\(Ŏ͠};ܠJ`t.bKv0vp87f&Iʐ*g5>3alDhٵt6@v=I٠M7!UgU}!v@{<+	TTjbnrd\|ɠ @-ǣQӎOg}ޠ-/kݓQCR                                  UUUUUUUUwwwwwwww8Ӡ@ӎ8@N<Ӡ448vD9ks&Ӯ\jxFn堛){Ѡ]'X&[Xk !ee[U9	^Ɩ,^ucL~QTǡm@)%_DNOlDkfF\\TנluNr41OBH yjbMP5<soa)ŋQ=v咠eǅ$ÄDQg SZũm^Rz5T/	+P&IР|q~\DrA=FWt`W۠emΠxֈfX=[u+M㠚386Q2X'.nSScaX6@NРRr@		T:&                      }C                DDDDDDDD0ӠM4Ϡ8P<O4ӠO<0Ӎ8ޖ&S`,V;㸠Mj"0͠Tk3B236QBkCc+=R.wO*Yu^'9Aܠ֬޶!Ǯ2t+i]a91H_V5?3D	L<0ՠPM顠ҷڕ51B[IYӓMǠx-&]> |+^7B	càQ0lՙTesHZ67{SK*],3Р_9t{d=j_T.mC`%vj>d:jJL6Gճq~b8UVzGj͠ǪH&HP                                  333333338㠍<Π<ӌ<N8Ġ
88ӌ8NE%`A{}j杠TE)X$%ÊڅPs5&󣅠jg[޻وZ"gh0ta7
'!-b
*Q~K>i/ؠa.G$6C;x9~y&pK*tBӄ}ƠɠcIsGlTG9gV@UiOusgpɚY\pRCNȫڠh(RS[-norV]LcWX;9%Π4(!zGw͠T`2pPzq좠*tWu++eZ5MX;goi/ŠIFv                      1\                """"""""8Ӡ4Ì5N0ӏ0Ԡ888ӍdBnS술8yU
KĠTܲ[
6zȞqSʉfRe_ dmHrVܠ.ؠ
gJƠu
T/_mLP47^FmON1Aqk4ʠɨs>9Ac5k]rb%nN8M4۠iǠx;Рuz~M+nզ7v7P=N`Ѣ9=ihĠRB~v
"ݛ.rL[aEp7XDѨ>Qq+aMĠΓFHיxBlq젉S㠜Lq6
(:6p\殠dJ8f\1h ͊PV                  R                8ӠM<͠088@
@N8ӏaRVw6HPXbHxU+FwwԏVD
ϧ"`e蠵Y%UgmU7٠.r4
L baq"P!nFZɭƮ0EXRhfj-{àR6V
waJb`'DJ
?9aϠ1}ĹhDUjӠ~V(Ty(Mt̂HE%]T5p,HvkVYFDqɏԶzߜՠՃ-` D MĠ#8eTXM7ӹ!Q&F82io)rʛio6UVDGݠ^DIzWCK͠g_֠9I                      w                        ̠̠8Ӡ4M8M4Md%PӠ9wTCs~,;:jJKG:Z02철S2P+oƠnlzߠQ}0ݕƑIV.駠vitРoI`)*X(bla-Y`}#k݂]7fWHp[3p'6xS^k_Y;ecc9ΓJtጠmFW\EРV)r?Sݱ,y>Y~+fPRG{QyҦXh[,r|w!ՠ.\9\:?km{7h/D}/ムh
̪ <2                                                                              ݠݠ4Ӡ
0㏠88N7j}([:
池lɠƷĠN
ܠmvz
zK5@`ޠQj]N;o) n]G^ĥj0{B)7L~Z)v&IAE=T)fp<s7/#u]qi&"*=xנt&<akSezpbfb:Q}ڠJF^4U,|Pl^gH2^𠜚Jɠ
767ϒ{an#xH6f&ӚQdڮɠ領㠅9xQS۠=9eѩޠNiNIO-]ɠ{VT[|VbQ\]Cb                                  O-                        4Ӡ0O88=*a?[e]5cˠh@'IY|Y9ʶ
ϯES_܋eCKOK\G͠r[~̠XOGPxe90KV)! :aWJs j᠙3]iF^"6wu0p}Ma!yK9mz4yeA}֗͠BP ezBŠ7=i)ƠL+Ήn{R#p(f!3y;N28Ӣ{Y8F3ie+{nsљEoD8V# àx6IT>[ӡMO sjE[A;;OY蠮:~Ah)sO-Hfؠ1uA	      X                        T8㏠48N!
=P')N9UY~(aO~䥉2f7T:JG0xݠ!ytGKd8Nwҝ Ơ!`fmvϠATf\2z`B EI篠4Qe
\8Ǡe*1ېzvQOՠ5qs+Pf)YkN'NAD .%=u)Uˆ=֠~I8wBId]0k0[-x!I6ѻѠ
I&#m:8"+Yw{ OKa=v̜;s8[^8P]hY
 =+GuOg	i-!_s[<          mݠݠ                        c
1<Ӎ8+~]< RPp	ˠO7T+w&O͠,F/7AOa`uŠSX
kNSFA*#:n͠ۏZؠtXȠ|盠If#>̠s`\Ekd_F>ՠ秠lҠS(v5ɜ$ⓠH,sI%Ʋ0y[hw.v&W󓠙g
jz5`Cuf![,8S[h~:!pNC~޻G[dF*`MB(8b;&oSR[+Ye2tlG?~j%YYꬠfyIBaX̠                              )̠̠                        c0M0<MƠQXCm)P̌fc1 ݠ_P&ݯW"^^VSÈD
àUȗmN.%CŠ(`'R1+'՜+6B-ݠZ#*XPN堌R@̤~}޶_W۠dVLZs%iiԟtg&w%fWFBن^ՠ ~_m~r[1|ǔN
g+c>,֠|Qs%W=w-
Š`DT̺{V;2OE3~4*M%I?wԠz!U_&͠ShEsQ֠Aޠ                                                          zA                cN8L8<ӏ0<N04Ӿ@\uUSgЁeOEI>B	Wj7qd}lڠ (Z3g.&8Vz8V{(eA׭e~9FW();1PZYmiȠ[OL9IwP!fUNϬ7"y ,7)4*HYĎ[ǛCܴ/?}ȠȲ7Tdb~1E~jgx&XDٟE9[հWqz.tl{6
U`A?Ɔ~+
>;>x+Q+
`*ETjی[54}l]QFRdZY0
,t6dmfEeUE                  """"""""                cN9#N,0<Ҡ@O4N4.8thڠ)M1	OSrҋH&Π[ju.t]H1FR]KvR߼a_RrPA1umR Ic9^Q]]<à(j>:wz۠nSZ:!_gËϠ'hca\̪l;*כhr#vàg3aI{$94:QΠ`ݑˈ$Ѻ֠T*V:T}祠Vߠ޳(VTdX\ڝZ_PX&I~㙠
[.abMē>Z1}Ǡ]L*A$ɜݠW׿=`OՠbܑLL                      晙33333333                cM4͠<4M8Ӡ44Ӎ4Lyu6
sʛaߠ9v'lݭE&	wd>WtVTZjo*$/5͠$sdN㘠zrX~)u7΢&y^'aҠzxth0٠|'Rt/e}9wʠBJ8}*.Z$ϕR)렒XZ۠ayUA )]=Wu<t2x`H3{--Ca̠MGz;xYwri n ҧfi+CwYb7TV2bfHI4tfuݹxQӠVޑu,PDՕ=uC*kBW
ڠGևx8                  d4DDDDDDDD                c0Ӎ8Í8@Ӡ4̠1M8VɠmͷAXzݛJf{w
6Jz(%TQl`Ġ(M0VFU&[T池 ڠR񠩩,
osfv<
}pq+ǆz
UMF\;^`s#B1
^	Zxh	, ,\4à  kerٌԠ fdy^W6>kFntixU6|Q	nǠQq},ɀaRIEqcpMSzN@Mv.1v@YkiJ -ܠ" T'k                      wwwwwwwwUUUUUUUU                cO,0N<4ӠN5N89VՓF5k^Y؇.lY ]4j$epX)ؐT7ݠ[A+Y3Jӗ_BohVQjX"렗^:<Z_,ݠKrh֠\aeJ#Ϡ_j@fvuǮjlTɠ&	̠I5@cU)@mg[xʹ۠wD:XVBEl/~#}ΠWm{c
ET U۠̅ħs}lلq5ֵ.ؠ9׬-:g(}X_Xw̠r~􇠊,`s2ur                  rNffffffffffffffff                c=048Ԡ
=N8ӎ4Ǡ=
2'8SpǠdU1L2ccos!{BwL,Nu4ܠ4Rcr|<9[孠1`\Q%ybͻ^SQKqĠ}2A2ᯠxPsC2w"FR}lCW-4Ki)bޅ\LYQ`_Т攠b0SW0x'ɠƍL<hӌ,܎>1gVڠؠM v7rϠ~
EBmɡi0ת|,zW׌mioՠiH렴_a/UޠEr
8ѠK&|.                      q;UUUUUUUUwwwwwwww                c0L8<N4㠏<4O0z%" bix kQ0vHݚ0.۸!]vp3F|B|tࠬgLr
נ7p`Fh_Ѡp裂M(Uvב/>UzrspqFt'^K]갠tjuz8Ιՠ祠.rxD=@|qߥSI@Z\+{aw9J5<;T~Cmuڠ`ҩJCV㕠{F۠HpY~s3Iu``aos%vf	f<zBNr
y@u
@t翭wA:a>                  DDDDDDDD                c,N=80Ӡ8Ñ88N >cV"?tooc܅&i@#D
pMHQyy'#=GM@(?srܠX['RtjAjҸZQi <p5֠eGnM.3ƭ\F^'RNf8Í(=@#M(S-Ѡ*UN"	<QC&Q%	*5儠{rq.A1f<nw\*b-;ޠ̶X"<ލIƧ2H4'W#
.b	 i
aY(A-)vG.֐SvCh#11M;G7 *ȠKy                      33333333                c59
44㠍4ӎ8O8N]nsꗠ%Ma#]V,3z>""O࿠)nS堸yfhrǉӠ8N.Vgk8*ؠZHsMp綠afWquX OGlUCDZe0kuhb7gנM{(fI9J\YS{d:BaP^|[Ѡsy[2yk䠸fFw
UoGm#mEl;Ҡ."o*~JHCed$:w{O^Alf@AZ:dXpS/vYQ\V1j$v`}8H<hW                  """"""""                cN8M8Ӎ8N<㠍<ӌ94R&rU!Sq8	WHܝW$nՠ}F,,Ԍ۠֯ٶQR*FG&.jU$^ݠN#Ġi2dOz7!
Rcs=xO6]n0"K[\-ʠ|B0ŠS(ΠN˯lPr Qgؑ$h´c%X=o
B bN*KDMrrwmV I/ՠ
!+S[젮1s
sz+eb4H%UJ8-l#68 %jLX>,6ɐΠڹezP@(%Dt9?LbR                      p                c9Π84@N84
=M&d9zKxH"9)WdwseTxӠIkloJ۠_ޯOmPFǠnMBEà$0XE	8ǟeEX)Roצq:. s+QKϠct
sE;Ij_
I	tN:UN,\c{ۏVT%_"T:
s*mlȠ7	AaؠF!7vxo7a6FyϠ_e&]KTn듛5Fҋ'$$Uw-˷K_.ؠvߦebdn$⠈B}r3~6v:V/@zoRؖ횠T%ɠfP?                          ̠̠                0Ӡ0ӎ8N4NӠkhM0DةVI3V1٠<2:.+S)%ؽFM^sbàHٔnx
 q<I{^^TIQVh$4k1ʠ2iqrҠXڠN]rΠh+ؠwkl(90݅pzϊؠEZAOAWxMzgNy^vjuŌqߠ9zAkSz:	/QR砪ܬ_#LD^dKK:1teCO)>jㄠ■U4TՃy1hk6:*:""x_F
Ġ"YnAz                                                       
