# Generated by default/object.tt
package Paws::Snowball::TargetOnDeviceService;
  use Moose;
  has ServiceName => (is => 'ro', isa => 'Str');
  has TransferOption => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Snowball::TargetOnDeviceService

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Snowball::TargetOnDeviceService object:

  $service_obj->Method(Att1 => { ServiceName => $value, ..., TransferOption => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Snowball::TargetOnDeviceService object:

  $result = $service_obj->Method(...);
  $result->Att1->ServiceName

=head1 DESCRIPTION

An object that represents the service or services on the Snow Family
device that your transferred data will be exported from or imported
into. AWS Snow Family supports Amazon S3 and NFS (Network File System).

=head1 ATTRIBUTES


=head2 ServiceName => Str

Specifies the name of the service on the Snow Family device that your
transferred data will be exported from or imported into.


=head2 TransferOption => Str

Specifies whether the data is being imported or exported. You can
import or export the data, or use it locally on the device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Snowball>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

