# Generated by default/object.tt
package Paws::ElasticInference::AcceleratorType;
  use Moose;
  has AcceleratorTypeName => (is => 'ro', isa => 'Str', request_name => 'acceleratorTypeName', traits => ['NameInRequest']);
  has MemoryInfo => (is => 'ro', isa => 'Paws::ElasticInference::MemoryInfo', request_name => 'memoryInfo', traits => ['NameInRequest']);
  has ThroughputInfo => (is => 'ro', isa => 'ArrayRef[Paws::ElasticInference::KeyValuePair]', request_name => 'throughputInfo', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElasticInference::AcceleratorType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElasticInference::AcceleratorType object:

  $service_obj->Method(Att1 => { AcceleratorTypeName => $value, ..., ThroughputInfo => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElasticInference::AcceleratorType object:

  $result = $service_obj->Method(...);
  $result->Att1->AcceleratorTypeName

=head1 DESCRIPTION

The details of an Elastic Inference Accelerator type.

=head1 ATTRIBUTES


=head2 AcceleratorTypeName => Str

The name of the Elastic Inference Accelerator type.


=head2 MemoryInfo => L<Paws::ElasticInference::MemoryInfo>

The memory information of the Elastic Inference Accelerator type.


=head2 ThroughputInfo => ArrayRef[L<Paws::ElasticInference::KeyValuePair>]

The throughput information of the Elastic Inference Accelerator type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElasticInference>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

