# Generated by default/object.tt
package Paws::ES::PackageDetails;
  use Moose;
  has AvailablePackageVersion => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has ErrorDetails => (is => 'ro', isa => 'Paws::ES::ErrorDetails');
  has LastUpdatedAt => (is => 'ro', isa => 'Str');
  has PackageDescription => (is => 'ro', isa => 'Str');
  has PackageID => (is => 'ro', isa => 'Str');
  has PackageName => (is => 'ro', isa => 'Str');
  has PackageStatus => (is => 'ro', isa => 'Str');
  has PackageType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::PackageDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::PackageDetails object:

  $service_obj->Method(Att1 => { AvailablePackageVersion => $value, ..., PackageType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::PackageDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailablePackageVersion

=head1 DESCRIPTION

Basic information about a package.

=head1 ATTRIBUTES


=head2 AvailablePackageVersion => Str




=head2 CreatedAt => Str

Timestamp which tells creation date of the package.


=head2 ErrorDetails => L<Paws::ES::ErrorDetails>

Additional information if the package is in an error state. Null
otherwise.


=head2 LastUpdatedAt => Str




=head2 PackageDescription => Str

User-specified description of the package.


=head2 PackageID => Str

Internal ID of the package.


=head2 PackageName => Str

User specified name of the package.


=head2 PackageStatus => Str

Current state of the package. Values are
COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED


=head2 PackageType => Str

Currently supports only TXT-DICTIONARY.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

