# Generated by default/object.tt
package Paws::AuditManager::ControlSet;
  use Moose;
  has Controls => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::Control]', request_name => 'controls', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::ControlSet

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::ControlSet object:

  $service_obj->Method(Att1 => { Controls => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::ControlSet object:

  $result = $service_obj->Method(...);
  $result->Att1->Controls

=head1 DESCRIPTION

A set of controls in AWS Audit Manager.

=head1 ATTRIBUTES


=head2 Controls => ArrayRef[L<Paws::AuditManager::Control>]

The list of controls within the control set.


=head2 Id => Str

The identifier of the control set in the assessment. This is the
control set name in a plain string format.


=head2 Name => Str

The name of the control set.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

