# Generated by default/object.tt
package Paws::Athena::DataCatalogSummary;
  use Moose;
  has CatalogName => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::DataCatalogSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::DataCatalogSummary object:

  $service_obj->Method(Att1 => { CatalogName => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::DataCatalogSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CatalogName

=head1 DESCRIPTION

The summary information for the data catalog, which includes its name
and type.

=head1 ATTRIBUTES


=head2 CatalogName => Str

The name of the data catalog.


=head2 Type => Str

The data catalog type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

