
package Paws::Quicksight::DescribeAccountSettings;
  use Moose;
  has AwsAccountId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'AwsAccountId', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeAccountSettings');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/accounts/{AwsAccountId}/settings');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Quicksight::DescribeAccountSettingsResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::DescribeAccountSettings - Arguments for method DescribeAccountSettings on L<Paws::Quicksight>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeAccountSettings on the
L<Amazon QuickSight|Paws::Quicksight> service. Use the attributes of this class
as arguments to method DescribeAccountSettings.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeAccountSettings.

=head1 SYNOPSIS

    my $quicksight = Paws->service('Quicksight');
    my $DescribeAccountSettingsResponse = $quicksight->DescribeAccountSettings(
      AwsAccountId => 'MyAwsAccountId',

    );

    # Results:
    my $AccountSettings = $DescribeAccountSettingsResponse->AccountSettings;
    my $RequestId       = $DescribeAccountSettingsResponse->RequestId;
    my $Status          = $DescribeAccountSettingsResponse->Status;

    # Returns a L<Paws::Quicksight::DescribeAccountSettingsResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/quicksight/DescribeAccountSettings>

=head1 ATTRIBUTES


=head2 B<REQUIRED> AwsAccountId => Str

The ID for the AWS account that contains the settings that you want to
list.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeAccountSettings in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

