# Generated by default/object.tt
package Paws::Glue::SchemaVersionErrorItem;
  use Moose;
  has ErrorDetails => (is => 'ro', isa => 'Paws::Glue::ErrorDetails');
  has VersionNumber => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::SchemaVersionErrorItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::SchemaVersionErrorItem object:

  $service_obj->Method(Att1 => { ErrorDetails => $value, ..., VersionNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::SchemaVersionErrorItem object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorDetails

=head1 DESCRIPTION

An object that contains the error details for an operation on a schema
version.

=head1 ATTRIBUTES


=head2 ErrorDetails => L<Paws::Glue::ErrorDetails>

The details of the error for the schema version.


=head2 VersionNumber => Int

The version number of the schema.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

