# Generated by default/object.tt
package Paws::DMS::ReplicationTaskAssessmentRun;
  use Moose;
  has AssessmentProgress => (is => 'ro', isa => 'Paws::DMS::ReplicationTaskAssessmentRunProgress');
  has AssessmentRunName => (is => 'ro', isa => 'Str');
  has LastFailureMessage => (is => 'ro', isa => 'Str');
  has ReplicationTaskArn => (is => 'ro', isa => 'Str');
  has ReplicationTaskAssessmentRunArn => (is => 'ro', isa => 'Str');
  has ReplicationTaskAssessmentRunCreationDate => (is => 'ro', isa => 'Str');
  has ResultEncryptionMode => (is => 'ro', isa => 'Str');
  has ResultKmsKeyArn => (is => 'ro', isa => 'Str');
  has ResultLocationBucket => (is => 'ro', isa => 'Str');
  has ResultLocationFolder => (is => 'ro', isa => 'Str');
  has ServiceAccessRoleArn => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::ReplicationTaskAssessmentRun

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::ReplicationTaskAssessmentRun object:

  $service_obj->Method(Att1 => { AssessmentProgress => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::ReplicationTaskAssessmentRun object:

  $result = $service_obj->Method(...);
  $result->Att1->AssessmentProgress

=head1 DESCRIPTION

Provides information that describes a premigration assessment run that
you have started using the C<StartReplicationTaskAssessmentRun>
operation.

Some of the information appears based on other operations that can
return the C<ReplicationTaskAssessmentRun> object.

=head1 ATTRIBUTES


=head2 AssessmentProgress => L<Paws::DMS::ReplicationTaskAssessmentRunProgress>

Indication of the completion progress for the individual assessments
specified to run.


=head2 AssessmentRunName => Str

Unique name of the assessment run.


=head2 LastFailureMessage => Str

Last message generated by an individual assessment failure.


=head2 ReplicationTaskArn => Str

ARN of the migration task associated with this premigration assessment
run.


=head2 ReplicationTaskAssessmentRunArn => Str

Amazon Resource Name (ARN) of this assessment run.


=head2 ReplicationTaskAssessmentRunCreationDate => Str

Date on which the assessment run was created using the
C<StartReplicationTaskAssessmentRun> operation.


=head2 ResultEncryptionMode => Str

Encryption mode used to encrypt the assessment run results.


=head2 ResultKmsKeyArn => Str

ARN of the AWS KMS encryption key used to encrypt the assessment run
results.


=head2 ResultLocationBucket => Str

Amazon S3 bucket where AWS DMS stores the results of this assessment
run.


=head2 ResultLocationFolder => Str

Folder in an Amazon S3 bucket where AWS DMS stores the results of this
assessment run.


=head2 ServiceAccessRoleArn => Str

ARN of the service role used to start the assessment run using the
C<StartReplicationTaskAssessmentRun> operation.


=head2 Status => Str

Assessment run status.

This status can have one of the following values:

=over

=item *

C<"cancelling"> E<ndash> The assessment run was canceled by the
C<CancelReplicationTaskAssessmentRun> operation.

=item *

C<"deleting"> E<ndash> The assessment run was deleted by the
C<DeleteReplicationTaskAssessmentRun> operation.

=item *

C<"failed"> E<ndash> At least one individual assessment completed with
a C<failed> status.

=item *

C<"error-provisioning"> E<ndash> An internal error occurred while
resources were provisioned (during C<provisioning> status).

=item *

C<"error-executing"> E<ndash> An internal error occurred while
individual assessments ran (during C<running> status).

=item *

C<"invalid state"> E<ndash> The assessment run is in an unknown state.

=item *

C<"passed"> E<ndash> All individual assessments have completed, and
none has a C<failed> status.

=item *

C<"provisioning"> E<ndash> Resources required to run individual
assessments are being provisioned.

=item *

C<"running"> E<ndash> Individual assessments are being run.

=item *

C<"starting"> E<ndash> The assessment run is starting, but resources
are not yet being provisioned for individual assessments.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

