# -*-perl-*-

# $Id: 04_random_key.t,v 3.1 2004/02/26 02:02:30 lachoy Exp $

use strict;
use Test::More tests => 6;

do "t/config.pl";

{
    my %config = (
      test => {
         class    => 'LoopbackTest',
         isa      => [ qw( SPOPS::Key::Random SPOPS::Loopback ) ],
         field    => [ qw( id_field field_name ) ],
         id_field => 'id_field',
      },
    );

    # Create our test class using the loopback

    # TEST: 1
    require_ok( 'SPOPS::Initialize' );

    # TEST: 2-3
    my $class_init_list = eval { SPOPS::Initialize->process({ config => \%config }) };
    ok( ! $@, "Initialize process run $@" );
    is( $class_init_list->[0], 'LoopbackTest', 'Loopback initialized' );

    # Create an object and save it, checking to see if {id_field} was
    # generated by SPOPS::Key::Random

    # TEST: 4
    my $item = eval { LoopbackTest->new };
    ok( ! $@, "Create object" );

    # TEST: 5
    eval { $item->save };
    $item->save;
    ok( $item->{id_field}, "Random key generate on save()" );

    # Now just call it directly and ensure they're unique

    # TEST: 6
    my %track = ();
    for ( 1..100 ) {
        my ( $new_key, $n ) = SPOPS::Key::Random->pre_fetch_id;
        $track{ $new_key }++;
    }
    is( scalar keys %track, 100, "Unique keys generated" );
}
