/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BrowserCompatSpec;

class HtmlUnitBrowserCompatCookieSpec
extends BrowserCompatSpec {
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new CookiePathComparator();
    private static final Date DATE_1_1_1970;
    private static final String[] DEFAULT_DATE_PATTERNS;

    HtmlUnitBrowserCompatCookieSpec(IncorrectnessListener incorrectnessListener) {
        BasicPathHandler pathHandler = new BasicPathHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }
        };
        this.registerAttribHandler("path", (CookieAttributeHandler)pathHandler);
        final CookieAttributeHandler originalExpiresHandler = this.getAttribHandler("expires");
        CookieAttributeHandler wrapperExpiresHandler = new CookieAttributeHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                originalExpiresHandler.validate(cookie, origin);
            }

            public void parse(SetCookie cookie, String value) throws MalformedCookieException {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                value = value.replaceAll("[ ,:-]+", " ");
                cookie.setExpiryDate(DateUtils.parseDate((String)value, (String[])DEFAULT_DATE_PATTERNS, (Date)DATE_1_1_1970));
            }

            public boolean match(Cookie cookie, CookieOrigin origin) {
                return originalExpiresHandler.match(cookie, origin);
            }
        };
        this.registerAttribHandler("expires", wrapperExpiresHandler);
        CookieAttributeHandler httpOnlyHandler = new CookieAttributeHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }

            public void parse(SetCookie cookie, String value) throws MalformedCookieException {
                ((BasicClientCookie)cookie).setAttribute("httponly", "true");
            }

            public boolean match(Cookie cookie, CookieOrigin origin) {
                return true;
            }
        };
        this.registerAttribHandler("httponly", httpOnlyHandler);
    }

    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        List cookies = super.parse(header, origin);
        for (Cookie c : cookies) {
            if (!header.getValue().contains(c.getName() + "=\"" + c.getValue())) continue;
            ((BasicClientCookie)c).setValue('\"' + c.getValue() + '\"');
        }
        return cookies;
    }

    public List<Header> formatCookies(List<Cookie> cookies) {
        Collections.sort(cookies, COOKIE_COMPARATOR);
        return super.formatCookies(cookies);
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(1970, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DATE_1_1_1970 = calendar.getTime();
        DEFAULT_DATE_PATTERNS = new String[]{"EEE dd MMM yy HH mm ss zzz", "EEE dd MMM yyyy HH mm ss zzz", "EEE MMM d HH mm ss yyyy", "EEE dd MMM yy HH mm ss z ", "EEE dd MMM yyyy HH mm ss z ", "EEE dd MM yy HH mm ss z ", "EEE dd MM yyyy HH mm ss z ", "d/M/yyyy"};
    }
}

