
use strict;
use warnings;

use Test::More;
use Test::DZil qw( Builder simple_ini );
use Test::Differences qw( eq_or_diff );
use Path::Tiny qw( path );
require Module::Install;

# ABSTRACT: Really basic test to make sure this works

my $ini = simple_ini( [ 'GatherDir', {} ], [ 'ModuleInstall', {} ] );

my $test = Builder->from_config(
  { dist_root => 'invalid' },
  {
    add_files => { path( 'source', 'dist.ini' ) => $ini },
  }
);

$test->chrome->logger->set_debug(1);
$test->build();

pass("Dist built Ok");
{
  my $distini = path( $test->tempdir, 'build', 'dist.ini' );
  ok( $distini->exists, 'dist.ini in built tree' );
  eq_or_diff( $distini->slurp_raw, $ini, 'ini is expected content' );
}

{
  my $mkf     = path( $test->tempdir, 'build', 'Makefile.PL' );
  my $version = $Dist::Zilla::Plugin::ModuleInstall::VERSION;
  my $miver   = $Module::Install::VERSION;

  my $expected = <<"EOF";
use strict;
use warnings;
use lib './'; # Required for -Ddefault_inc_excludes_dot
# Warning: This code was generated by Dist::Zilla::Plugin::ModuleInstall Version ${version}
# As part of Dist::Zilla's build generation.
# Do not modify this file, instead, modify the dist.ini that configures its generation.
use inc::Module::Install $miver;
name 'DZT-Sample';

abstract "Sample\\ DZ\\ Dist";

author "E\\.\\ Xavier\\ Ample\\ \\<example\\\@example\\.org\\>";

version "0\\.001";

license "perl";


# configure requires => configure_requires
configure_requires  "ExtUtils\\:\\:MakeMaker" => "6\\.42";


# build requires => requires
requires  "ExtUtils\\:\\:MakeMaker" => "6\\.42";


# runtime requires => requires

# runtime recommends => recommends

# test requires => test_requires

# :ExecFiles
WriteAll();
EOF
  $expected =~ s{\r?\n}{$/}g;
  my $got = $mkf->slurp_raw;
  $got =~ s{\r?\n}{$/}g;
  eq_or_diff( $got, $expected, 'Makefile.PL is expected content' );
}

my ( $msg, ) = grep { $_->{level} eq 'info' and $_->{message} =~ q^inc/Module/Install\.pm^ } @{ $test->log_events };

ok( $msg, "Notice about adding inc::Module::Install" );

note explain $test->log_messages;
done_testing;
