/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.io.IOUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    public static final Set<String> breakingTags = new HashSet<String>(Arrays.asList("blockquote", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "p", "pre", "ul", "tr", "td"));

    private XMLUtils() {
    }

    public static String stripTags(Reader r, List<Integer> mapBack, boolean markLineBreaks) {
        if (mapBack != null) {
            mapBack.clear();
        }
        StringBuilder result = new StringBuilder();
        int position = 0;
        try {
            while (true) {
                String tag;
                String text;
                if ((text = XMLUtils.readUntilTag(r)).length() > 0) {
                    for (int i = 0; i < text.length(); ++i) {
                        result.append(text.charAt(i));
                        if (mapBack == null) continue;
                        mapBack.add(position + i);
                    }
                    position += text.length();
                }
                if ((tag = XMLUtils.readTag(r)) != null) {
                    if (markLineBreaks && XMLUtils.isBreaking(XMLUtils.parseTag(tag))) {
                        result.append("\n");
                        if (mapBack != null) {
                            mapBack.add(-position);
                        }
                    }
                    position += tag.length();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println("Error reading string");
            e.printStackTrace();
        }
        return result.toString();
    }

    public static boolean isBreaking(String tag) {
        return breakingTags.contains(tag);
    }

    public static boolean isBreaking(XMLTag tag) {
        return breakingTags.contains(tag.name);
    }

    public static String readUntilTag(Reader r) throws IOException {
        if (!r.ready()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int c = r.read();
        while (c >= 0 && c != 60) {
            b.append((char)c);
            c = r.read();
        }
        return b.toString();
    }

    public static XMLTag readAndParseTag(Reader r) throws Exception {
        String s = XMLUtils.readTag(r);
        if (s == null) {
            return null;
        }
        return new XMLTag(s);
    }

    public static String unescapeStringForXML(String s) {
        Pattern p = Pattern.compile("\\&.+?;");
        StringBuilder result = new StringBuilder();
        Matcher m = p.matcher(s);
        int end = 0;
        while (m.find()) {
            int start = m.start();
            result.append(s.substring(end, start));
            end = m.end();
            result.append(XMLUtils.translate(s.substring(start, end)));
        }
        result.append(s.substring(end, s.length()));
        return result.toString();
    }

    private static char translate(String s) {
        if (s.equals("&amp;")) {
            return '&';
        }
        if (s.equals("&lt;") || s.equals("&Lt;")) {
            return '<';
        }
        if (s.equals("&gt;") || s.equals("&Gt;")) {
            return '>';
        }
        if (s.equals("&quot;")) {
            return '\"';
        }
        if (s.equals("&apos;")) {
            return '\'';
        }
        if (s.equals("&ast;") || s.equals("&sharp;")) {
            return '-';
        }
        if (s.equals("&equals;")) {
            return '=';
        }
        if (s.equals("&nbsp;")) {
            return '\u00a0';
        }
        if (s.equals("&iexcl;")) {
            return '\u00a1';
        }
        if (s.equals("&cent;") || s.equals("&shilling;")) {
            return '\u00a2';
        }
        if (s.equals("&pound;")) {
            return '\u00a3';
        }
        if (s.equals("&curren;")) {
            return '\u00a4';
        }
        if (s.equals("&yen;")) {
            return '\u00a5';
        }
        if (s.equals("&brvbar;")) {
            return '\u00a6';
        }
        if (s.equals("&sect;")) {
            return '\u00a7';
        }
        if (s.equals("&uml;")) {
            return '\u00a8';
        }
        if (s.equals("&copy;")) {
            return '\u00a9';
        }
        if (s.equals("&ordf;")) {
            return '\u00aa';
        }
        if (s.equals("&laquo; ")) {
            return '\u00ab';
        }
        if (s.equals("&not;")) {
            return '\u00ac';
        }
        if (s.equals("&shy; ")) {
            return '\u00ad';
        }
        if (s.equals("&reg;")) {
            return '\u00ae';
        }
        if (s.equals("&macr;")) {
            return '\u00af';
        }
        if (s.equals("&deg;")) {
            return '\u00b0';
        }
        if (s.equals("&plusmn;")) {
            return '\u00b1';
        }
        if (s.equals("&sup2;")) {
            return '\u00b2';
        }
        if (s.equals("&sup3;")) {
            return '\u00b3';
        }
        if (s.equals("&acute;")) {
            return '\u00b4';
        }
        if (s.equals("&micro;")) {
            return '\u00b5';
        }
        if (s.equals("&middot;")) {
            return '\u00b7';
        }
        if (s.equals("&cedil;")) {
            return '\u00b8';
        }
        if (s.equals("&sup1;")) {
            return '\u00b9';
        }
        if (s.equals("&ordm;")) {
            return '\u00ba';
        }
        if (s.equals("&raquo;")) {
            return '\u00bb';
        }
        if (s.equals("&frac14; ")) {
            return '\u00bc';
        }
        if (s.equals("&frac12;")) {
            return '\u00bd';
        }
        if (s.equals("&frac34; ")) {
            return '\u00be';
        }
        if (s.equals("&iquest;")) {
            return '\u00bf';
        }
        if (s.equals("&Agrave;")) {
            return '\u00c0';
        }
        if (s.equals("&Aacute;")) {
            return '\u00c1';
        }
        if (s.equals("&Acirc;")) {
            return '\u00c2';
        }
        if (s.equals("&Atilde;")) {
            return '\u00c3';
        }
        if (s.equals("&Auml;")) {
            return '\u00c4';
        }
        if (s.equals("&Aring;")) {
            return '\u00c5';
        }
        if (s.equals("&AElig;")) {
            return '\u00c6';
        }
        if (s.equals("&Ccedil;")) {
            return '\u00c7';
        }
        if (s.equals("&Egrave;")) {
            return '\u00c8';
        }
        if (s.equals("&Eacute;")) {
            return '\u00c9';
        }
        if (s.equals("&Ecirc;")) {
            return '\u00ca';
        }
        if (s.equals("&Euml;")) {
            return '\u00cb';
        }
        if (s.equals("&Igrave;")) {
            return '\u00cc';
        }
        if (s.equals("&Iacute;")) {
            return '\u00cd';
        }
        if (s.equals("&Icirc;")) {
            return '\u00ce';
        }
        if (s.equals("&Iuml;")) {
            return '\u00cf';
        }
        if (s.equals("&ETH;")) {
            return '\u00d0';
        }
        if (s.equals("&Ntilde;")) {
            return '\u00d1';
        }
        if (s.equals("&Ograve;")) {
            return '\u00d2';
        }
        if (s.equals("&Oacute;")) {
            return '\u00d3';
        }
        if (s.equals("&Ocirc;")) {
            return '\u00d4';
        }
        if (s.equals("&Otilde;")) {
            return '\u00d5';
        }
        if (s.equals("&Ouml;")) {
            return '\u00d6';
        }
        if (s.equals("&times;")) {
            return '\u00d7';
        }
        if (s.equals("&Oslash;")) {
            return '\u00d8';
        }
        if (s.equals("&Ugrave;")) {
            return '\u00d9';
        }
        if (s.equals("&Uacute;")) {
            return '\u00da';
        }
        if (s.equals("&Ucirc;")) {
            return '\u00db';
        }
        if (s.equals("&Uuml;")) {
            return '\u00dc';
        }
        if (s.equals("&Yacute;")) {
            return '\u00dd';
        }
        if (s.equals("&THORN;")) {
            return '\u00de';
        }
        if (s.equals("&szlig;")) {
            return '\u00df';
        }
        if (s.equals("&agrave;")) {
            return '\u00e0';
        }
        if (s.equals("&aacute;")) {
            return '\u00e1';
        }
        if (s.equals("&acirc;")) {
            return '\u00e2';
        }
        if (s.equals("&atilde;")) {
            return '\u00e3';
        }
        if (s.equals("&auml;")) {
            return '\u00e4';
        }
        if (s.equals("&aring;")) {
            return '\u00e5';
        }
        if (s.equals("&aelig;")) {
            return '\u00e6';
        }
        if (s.equals("&ccedil;")) {
            return '\u00e7';
        }
        if (s.equals("&egrave;")) {
            return '\u00e8';
        }
        if (s.equals("&eacute;")) {
            return '\u00e9';
        }
        if (s.equals("&ecirc;")) {
            return '\u00ea';
        }
        if (s.equals("&euml; ")) {
            return '\u00eb';
        }
        if (s.equals("&igrave;")) {
            return '\u00ec';
        }
        if (s.equals("&iacute;")) {
            return '\u00ed';
        }
        if (s.equals("&icirc;")) {
            return '\u00ee';
        }
        if (s.equals("&iuml;")) {
            return '\u00ef';
        }
        if (s.equals("&eth;")) {
            return '\u00f0';
        }
        if (s.equals("&ntilde;")) {
            return '\u00f1';
        }
        if (s.equals("&ograve;")) {
            return '\u00f2';
        }
        if (s.equals("&oacute;")) {
            return '\u00f3';
        }
        if (s.equals("&ocirc;")) {
            return '\u00f4';
        }
        if (s.equals("&otilde;")) {
            return '\u00f5';
        }
        if (s.equals("&ouml;")) {
            return '\u00f6';
        }
        if (s.equals("&divide;")) {
            return '\u00f7';
        }
        if (s.equals("&oslash;")) {
            return '\u00f8';
        }
        if (s.equals("&ugrave;")) {
            return '\u00f9';
        }
        if (s.equals("&uacute;")) {
            return '\u00fa';
        }
        if (s.equals("&ucirc;")) {
            return '\u00fb';
        }
        if (s.equals("&uuml;")) {
            return '\u00fc';
        }
        if (s.equals("&yacute;")) {
            return '\u00fd';
        }
        if (s.equals("&thorn;")) {
            return '\u00fe';
        }
        if (s.equals("&yuml;")) {
            return '\u00ff';
        }
        if (s.equals("&OElig;")) {
            return '\u0152';
        }
        if (s.equals("&oelig;")) {
            return '\u0153';
        }
        if (s.equals("&Scaron;")) {
            return '\u0160';
        }
        if (s.equals("&scaron;")) {
            return '\u0161';
        }
        if (s.equals("&Yuml;")) {
            return '\u0178';
        }
        if (s.equals("&circ;")) {
            return '\u02c6';
        }
        if (s.equals("&tilde;")) {
            return '\u02dc';
        }
        if (s.equals("&lrm;")) {
            return '\u200e';
        }
        if (s.equals("&rlm;")) {
            return '\u200f';
        }
        if (s.equals("&ndash;")) {
            return '\u2013';
        }
        if (s.equals("&mdash;")) {
            return '\u2014';
        }
        if (s.equals("&lsquo;")) {
            return '\u2018';
        }
        if (s.equals("&rsquo;")) {
            return '\u2019';
        }
        if (s.equals("&sbquo;")) {
            return '\u201a';
        }
        if (s.equals("&ldquo;") || s.equals("&bquo;") || s.equals("&bq;")) {
            return '\u201c';
        }
        if (s.equals("&rdquo;") || s.equals("&equo;")) {
            return '\u201d';
        }
        if (s.equals("&bdquo;")) {
            return '\u201e';
        }
        if (s.equals("&sim;")) {
            return '\u223c';
        }
        if (s.equals("&radic;")) {
            return '\u221a';
        }
        if (s.equals("&le;")) {
            return '\u2264';
        }
        if (s.equals("&ge;")) {
            return '\u2265';
        }
        if (s.equals("&larr;")) {
            return '\u2190';
        }
        if (s.equals("&darr;")) {
            return '\u2193';
        }
        if (s.equals("&rarr;")) {
            return '\u2192';
        }
        if (s.equals("&hellip;")) {
            return '\u2026';
        }
        if (s.equals("&prime;")) {
            return '\u2032';
        }
        if (s.equals("&Prime;") || s.equals("&ins;")) {
            return '\u2033';
        }
        if (s.equals("&trade;")) {
            return '\u2122';
        }
        if (s.equals("&Alpha;") || s.equals("&Agr;")) {
            return '\u0391';
        }
        if (s.equals("&Beta;") || s.equals("&Bgr;")) {
            return '\u0392';
        }
        if (s.equals("&Gamma;") || s.equals("&Ggr;")) {
            return '\u0393';
        }
        if (s.equals("&Delta;") || s.equals("&Dgr;")) {
            return '\u0394';
        }
        if (s.equals("&Epsilon;") || s.equals("&Egr;")) {
            return '\u0395';
        }
        if (s.equals("&Zeta;") || s.equals("&Zgr;")) {
            return '\u0396';
        }
        if (s.equals("&Eta;")) {
            return '\u0397';
        }
        if (s.equals("&Theta;") || s.equals("&THgr;")) {
            return '\u0398';
        }
        if (s.equals("&Iota;") || s.equals("&Igr;")) {
            return '\u0399';
        }
        if (s.equals("&Kappa;") || s.equals("&Kgr;")) {
            return '\u039a';
        }
        if (s.equals("&Lambda;") || s.equals("&Lgr;")) {
            return '\u039b';
        }
        if (s.equals("&Mu;") || s.equals("&Mgr;")) {
            return '\u039c';
        }
        if (s.equals("&Nu;") || s.equals("&Ngr;")) {
            return '\u039d';
        }
        if (s.equals("&Xi;") || s.equals("&Xgr;")) {
            return '\u039e';
        }
        if (s.equals("&Omicron;") || s.equals("&Ogr;")) {
            return '\u039f';
        }
        if (s.equals("&Pi;") || s.equals("&Pgr;")) {
            return '\u03a0';
        }
        if (s.equals("&Rho;") || s.equals("&Rgr;")) {
            return '\u03a1';
        }
        if (s.equals("&Sigma;") || s.equals("&Sgr;")) {
            return '\u03a3';
        }
        if (s.equals("&Tau;") || s.equals("&Tgr;")) {
            return '\u03a4';
        }
        if (s.equals("&Upsilon;") || s.equals("&Ugr;")) {
            return '\u03a5';
        }
        if (s.equals("&Phi;") || s.equals("&PHgr;")) {
            return '\u03a6';
        }
        if (s.equals("&Chi;") || s.equals("&KHgr;")) {
            return '\u03a7';
        }
        if (s.equals("&Psi;") || s.equals("&PSgr;")) {
            return '\u03a8';
        }
        if (s.equals("&Omega;") || s.equals("&OHgr;")) {
            return '\u03a9';
        }
        if (s.equals("&alpha;") || s.equals("&agr;")) {
            return '\u03b1';
        }
        if (s.equals("&beta;") || s.equals("&bgr;")) {
            return '\u03b2';
        }
        if (s.equals("&gamma;") || s.equals("&ggr;")) {
            return '\u03b3';
        }
        if (s.equals("&delta;") || s.equals("&dgr;")) {
            return '\u03b4';
        }
        if (s.equals("&epsilon;") || s.equals("&egr;")) {
            return '\u03b5';
        }
        if (s.equals("&zeta;") || s.equals("&zgr;")) {
            return '\u03b6';
        }
        if (s.equals("&eta;") || s.equals("&eegr;")) {
            return '\u03b7';
        }
        if (s.equals("&theta;") || s.equals("&thgr;")) {
            return '\u03b8';
        }
        if (s.equals("&iota;") || s.equals("&igr;")) {
            return '\u03b9';
        }
        if (s.equals("&kappa;") || s.equals("&kgr;")) {
            return '\u03ba';
        }
        if (s.equals("&lambda;") || s.equals("&lgr;")) {
            return '\u03bb';
        }
        if (s.equals("&mu;") || s.equals("&mgr;")) {
            return '\u03bc';
        }
        if (s.equals("&nu;") || s.equals("&ngr;")) {
            return '\u03bd';
        }
        if (s.equals("&xi;") || s.equals("&xgr;")) {
            return '\u03be';
        }
        if (s.equals("&omicron;") || s.equals("&ogr;")) {
            return '\u03bf';
        }
        if (s.equals("&pi;") || s.equals("&pgr;")) {
            return '\u03c0';
        }
        if (s.equals("&rho;") || s.equals("&rgr;")) {
            return '\u03c1';
        }
        if (s.equals("&sigma;") || s.equals("&sgr;")) {
            return '\u03c3';
        }
        if (s.equals("&tau;") || s.equals("&tgr;")) {
            return '\u03c4';
        }
        if (s.equals("&upsilon;") || s.equals("&ugr;")) {
            return '\u03c5';
        }
        if (s.equals("&phi;") || s.equals("&phgr;")) {
            return '\u03c6';
        }
        if (s.equals("&chi;") || s.equals("&khgr;")) {
            return '\u03c7';
        }
        if (s.equals("&psi;") || s.equals("&psgr;")) {
            return '\u03c8';
        }
        if (s.equals("&omega;") || s.equals("&ohgr;")) {
            return '\u03c9';
        }
        if (s.equals("&bull;")) {
            return '\u2022';
        }
        if (s.equals("&percnt;")) {
            return '%';
        }
        if (s.equals("&plus;")) {
            return '+';
        }
        if (s.equals("&dash;")) {
            return '-';
        }
        if (s.equals("&abreve;") || s.equals("&amacr;") || s.equals("&ape;") || s.equals("&aogon;") || s.equals("&aring;")) {
            return 'a';
        }
        if (s.equals("&Amacr;")) {
            return 'A';
        }
        if (s.equals("&cacute;") || s.equals("&ccaron;") || s.equals("&ccirc;")) {
            return 'c';
        }
        if (s.equals("&Ccaron;")) {
            return 'C';
        }
        if (s.equals("&dcaron;")) {
            return 'd';
        }
        if (s.equals("&ecaron;") || s.equals("&emacr;") || s.equals("&eogon;")) {
            return 'e';
        }
        if (s.equals("&Emacr;") || s.equals("&Ecaron;")) {
            return 'E';
        }
        if (s.equals("&lacute;")) {
            return 'l';
        }
        if (s.equals("&Lacute;")) {
            return 'L';
        }
        if (s.equals("&nacute;") || s.equals("&ncaron;") || s.equals("&ncedil;")) {
            return 'n';
        }
        if (s.equals("&rcaron;") || s.equals("&racute;")) {
            return 'r';
        }
        if (s.equals("&Rcaron;")) {
            return 'R';
        }
        if (s.equals("&omacr;")) {
            return 'o';
        }
        if (s.equals("&imacr;")) {
            return 'i';
        }
        if (s.equals("&sacute;") || s.equals("&scedil;") || s.equals("&scirc;")) {
            return 's';
        }
        if (s.equals("&Sacute") || s.equals("&Scedil;")) {
            return 'S';
        }
        if (s.equals("&tcaron;") || s.equals("&tcedil;")) {
            return 't';
        }
        if (s.equals("&umacr;") || s.equals("&uring;")) {
            return 'u';
        }
        if (s.equals("&wcirc;")) {
            return 'w';
        }
        if (s.equals("&Ycirc;")) {
            return 'Y';
        }
        if (s.equals("&ycirc;")) {
            return 'y';
        }
        if (s.equals("&zcaron;") || s.equals("&zacute;")) {
            return 'z';
        }
        if (s.equals("&Zcaron;")) {
            return 'Z';
        }
        if (s.equals("&hearts;")) {
            return '\u2665';
        }
        if (s.equals("&infin;")) {
            return '\u221e';
        }
        if (s.equals("&dollar;")) {
            return '$';
        }
        if (s.equals("&sub;") || s.equals("&lcub;")) {
            return '\u2282';
        }
        if (s.equals("&sup;") || s.equals("&rcub;")) {
            return '\u2283';
        }
        if (s.equals("&lsqb;")) {
            return '[';
        }
        if (s.equals("&rsqb;")) {
            return ']';
        }
        return ' ';
    }

    public static String escapeXML(String in) {
        int leng = in.length();
        StringBuilder sb = new StringBuilder(leng);
        for (int i = 0; i < leng; ++i) {
            char c = in.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeElementXML(String in) {
        int leng = in.length();
        StringBuilder sb = new StringBuilder(leng);
        for (int i = 0; i < leng; ++i) {
            char c = in.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeAttributeXML(String in) {
        int leng = in.length();
        StringBuilder sb = new StringBuilder(leng);
        for (int i = 0; i < leng; ++i) {
            char c = in.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeTextAroundXMLTags(String s) {
        StringBuilder result = new StringBuilder();
        StringReader r = new StringReader(s);
        try {
            while (true) {
                String text = XMLUtils.readUntilTag(r);
                result.append(XMLUtils.escapeXML(text));
                XMLTag tag = XMLUtils.readAndParseTag(r);
                if (tag != null) {
                    result.append(tag.toString());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println("Error reading string");
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String readTag(Reader r) throws IOException {
        if (!r.ready()) {
            return null;
        }
        StringBuilder b = new StringBuilder("<");
        int c = r.read();
        while (c >= 0) {
            b.append((char)c);
            if (c == 62) break;
            c = r.read();
        }
        if (b.length() == 1) {
            return null;
        }
        return b.toString();
    }

    public static XMLTag parseTag(String tagString) throws Exception {
        if (tagString == null || tagString.length() == 0) {
            return null;
        }
        return new XMLTag(tagString);
    }

    public static Document readDocumentFromFile(String filename) throws Exception {
        InputSource in = new InputSource(new FileReader(filename));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder db = factory.newDocumentBuilder();
        db.setErrorHandler(new SAXErrorHandler());
        return db.parse(in);
    }

    public static Document readDocumentFromString(String s) throws Exception {
        InputSource in = new InputSource(new StringReader(s));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        return factory.newDocumentBuilder().parse(in);
    }

    public static void main(String[] args) throws Exception {
        if (args[0].equals("-readDoc")) {
            Document doc = XMLUtils.readDocumentFromFile(args[1]);
            System.out.println(doc);
        } else {
            String s = IOUtils.slurpFile(args[0]);
            StringReader r = new StringReader(s);
            String tag = XMLUtils.readTag(r);
            while (tag.length() > 0) {
                XMLUtils.readUntilTag(r);
                tag = XMLUtils.readTag(r);
                if (tag.length() == 0) break;
                System.out.println("got tag=" + new XMLTag(tag));
            }
        }
    }

    private static class SAXErrorHandler
    implements ErrorHandler {
        private SAXErrorHandler() {
        }

        public static String makeBetterErrorString(String msg, SAXParseException ex) {
            StringBuilder sb = new StringBuilder(msg);
            sb.append(": ");
            String str = ex.getMessage();
            if (str.lastIndexOf(".") == str.length() - 1) {
                str = str.substring(0, str.length() - 1);
            }
            sb.append(str);
            sb.append(" at document line ").append(ex.getLineNumber());
            sb.append(", column ").append(ex.getColumnNumber());
            if (ex.getSystemId() != null) {
                sb.append(" in entity from systemID ").append(ex.getSystemId());
            } else if (ex.getPublicId() != null) {
                sb.append(" in entity from publicID ").append(ex.getPublicId());
            }
            sb.append(".");
            return sb.toString();
        }

        public void warning(SAXParseException exception) {
            System.err.println(SAXErrorHandler.makeBetterErrorString("Warning", exception));
        }

        public void error(SAXParseException exception) {
            System.err.println(SAXErrorHandler.makeBetterErrorString("Error", exception));
        }

        public void fatalError(SAXParseException ex) throws SAXParseException {
            throw new SAXParseException(SAXErrorHandler.makeBetterErrorString("Fatal Error", ex), ex.getPublicId(), ex.getSystemId(), ex.getLineNumber(), ex.getColumnNumber());
        }
    }

    public static class XMLTag {
        public String text;
        public String name;
        public Map<String, String> attributes;
        public boolean isEndTag;
        public boolean isSingleTag;

        public XMLTag(String tag) throws Exception {
            if (tag == null || tag.length() == 0) {
                throw new Exception("Can't parse tag");
            }
            this.text = tag;
            int begin = 1;
            if (tag.charAt(1) == '/') {
                begin = 2;
                this.isEndTag = true;
            } else {
                this.isEndTag = false;
            }
            int end = tag.length() - 1;
            if (tag.charAt(tag.length() - 2) == '/') {
                end = tag.length() - 2;
                this.isSingleTag = true;
            } else {
                this.isSingleTag = false;
            }
            tag = tag.substring(begin, end);
            this.attributes = new HashMap<String, String>();
            begin = 0;
            end = tag.indexOf(32);
            if (end < 0) {
                this.name = tag;
            } else {
                this.name = tag.substring(begin, end);
                do {
                    begin = end + 1;
                    while (tag.charAt(begin) < '!') {
                        ++begin;
                    }
                    end = tag.indexOf(61, begin);
                    if (end < 0) break;
                    String att = tag.substring(begin, end);
                    begin = end + 1;
                    String value = null;
                    if (tag.length() > begin) {
                        if (tag.charAt(begin) == '\"') {
                            if ((end = tag.indexOf(34, ++begin)) < 0) break;
                            value = tag.substring(begin, end);
                            ++end;
                        } else {
                            end = tag.indexOf(32, begin);
                            if (end < 0) {
                                end = tag.length();
                            }
                            value = tag.substring(begin, end);
                        }
                    }
                    this.attributes.put(att, value);
                } while (end < tag.length() - 3);
            }
        }

        public String toString() {
            return this.text;
        }
    }
}

