/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.trees.PennTreebankTokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class ArabicTreebankTokenizer
extends PennTreebankTokenizer {
    public ArabicTreebankTokenizer(Reader r) {
        super(r);
        this.st.eolIsSignificant(true);
    }

    public String getNext() {
        try {
            int nextToken;
            block8: while (true) {
                this.st.nextToken();
                nextToken = this.st.ttype;
                switch (nextToken) {
                    case -3: {
                        if (this.st.sval.equals(":::") || this.st.sval.equals(";;")) {
                            do {
                                this.st.nextToken();
                            } while ((nextToken = this.st.ttype) != 10);
                            continue block8;
                        }
                        return this.st.sval;
                    }
                    case -2: {
                        return Double.toString(this.st.nval);
                    }
                    case 10: {
                        continue block8;
                    }
                    case -1: {
                        return null;
                    }
                }
                break;
            }
            char[] t = new char[]{(char)nextToken};
            return new String(t);
        }
        catch (IOException e) {
            System.err.printf("%s: Unknown exception in input stream\n", this.getClass().getName());
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        ArabicTreebankTokenizer att = new ArabicTreebankTokenizer(new FileReader(args[0]));
        while (att.hasNext()) {
            System.out.print((String)att.next());
        }
    }
}

