/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.movetrees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.movetrees.HasTrace;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeLeaf;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyTreeLeaf<EmptyType>
extends LabeledScoredTreeLeaf
implements HasTrace {
    private static final long serialVersionUID = 77798427030716852L;
    static final String STANDIN = "standin";
    private Tree movedTree;
    private EmptyType emptyType;

    public EmptyType emptyType() {
        return this.emptyType;
    }

    public void setEmptyType(EmptyType o) {
        this.emptyType = o;
    }

    @Override
    public Tree traceTo() {
        return this.movedTree;
    }

    public void setTraceTo(Tree t) {
        this.movedTree = t;
    }

    @Override
    public <T> List<T> yield(List<T> y) {
        return y;
    }

    @Override
    public List<LabeledWord> labeledYield(List<LabeledWord> y) {
        return y;
    }

    @Override
    public String toString() {
        String str = ((Object)this.label()).toString() + "_" + this.emptyType().toString();
        if (this.traceTo() != null) {
            if (this.traceTo().dominates(this)) {
                System.err.println("Warning -- trace points to self-dominating node");
            }
            str = str + "[" + this.traceTo().label() + " " + this.traceTo().yield() + "]";
        }
        return str;
    }

    @Override
    public TreeFactory treeFactory() {
        return new TreeFactory(){
            TreeFactory lstf = new LabeledScoredTreeFactory();

            @Override
            public Tree newLeaf(Label l) {
                return new EmptyTreeLeaf(l, EmptyTreeLeaf.this.emptyType(), EmptyTreeLeaf.this.traceTo());
            }

            @Override
            public Tree newLeaf(String str) {
                return new EmptyTreeLeaf(new StringLabel(str), EmptyTreeLeaf.this.emptyType(), EmptyTreeLeaf.this.traceTo());
            }

            @Override
            public Tree newTreeNode(Label l, List<Tree> kids) {
                return this.lstf.newTreeNode(l, kids);
            }

            @Override
            public Tree newTreeNode(String str, List<Tree> kids) {
                return this.lstf.newTreeNode(str, kids);
            }
        };
    }

    public EmptyTreeLeaf(Label label, EmptyType type, Tree t) {
        this(label, type);
        this.movedTree = t;
    }

    public EmptyTreeLeaf(Label label, EmptyType type) {
        super(label);
        this.emptyType = type;
        this.movedTree = null;
    }
}

