/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HandshakeResponse;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;

class JsonWireProtocolResponse
implements HandshakeResponse {
    JsonWireProtocolResponse() {
    }

    @Override
    public Function<InitialHandshakeResponse, ProtocolHandshake.Result> errorHandler() {
        return tuple -> {
            if (!tuple.getData().containsKey("status")) {
                return null;
            }
            Object rawStatus = tuple.getData().get("status");
            if (!(rawStatus instanceof Number)) {
                return null;
            }
            if (((Number)rawStatus).intValue() == 0) {
                return null;
            }
            if (!tuple.getData().containsKey("value")) {
                return null;
            }
            Object value = tuple.getData().get("value");
            if (!(value instanceof Map)) {
                return null;
            }
            Response response = new Response(null);
            response.setStatus(((Number)rawStatus).intValue());
            response.setValue(value);
            new ErrorHandler().throwIfResponseFailed(response, tuple.getRequestDuration().toMillis());
            return null;
        };
    }

    @Override
    public Function<InitialHandshakeResponse, ProtocolHandshake.Result> successHandler() {
        return tuple -> {
            Object rawStatus = tuple.getData().get("status");
            if (!(rawStatus instanceof Number)) {
                return null;
            }
            if (0 != ((Number)rawStatus).intValue()) {
                return null;
            }
            Object rawSessionId = tuple.getData().get("sessionId");
            Object rawCapabilities = tuple.getData().get("value");
            if (!(rawSessionId instanceof String) || !(rawCapabilities instanceof Map)) {
                return null;
            }
            for (Object key : ((Map)rawCapabilities).keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            Map caps = (Map)rawCapabilities;
            String sessionId = (String)rawSessionId;
            return new ProtocolHandshake.Result(Dialect.OSS, sessionId, caps);
        };
    }
}

