/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DefaultSession;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;

public class DefaultDriverSessions
implements DriverSessions {
    private final DriverFactory factory;
    private final Cache<SessionId, Session> sessionIdToDriver;

    public DefaultDriverSessions(DriverFactory factory, long inactiveSessionTimeoutMs) {
        this.factory = factory;
        RemovalListener listener = notification -> {
            Session session = (Session)notification.getValue();
            session.close();
            PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
            logHandler.transferThreadTempLogsToSessionLogs(session.getSessionId());
            logHandler.removeSessionLogs(session.getSessionId());
        };
        this.sessionIdToDriver = CacheBuilder.newBuilder().removalListener(listener).expireAfterAccess(inactiveSessionTimeoutMs, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> driverClass) {
        this.factory.registerDriverProvider(new DefaultDriverProvider(capabilities, driverClass));
    }

    @Override
    public SessionId newSession(Stream<Capabilities> desiredCapabilities) throws Exception {
        Session session = DefaultSession.createSession(this.factory, TemporaryFilesystem.getTmpFsBasedOn(Files.createTempDir()), desiredCapabilities.findFirst().orElseThrow(() -> new SessionNotCreatedException("Unable to determine capabilities for session")));
        this.sessionIdToDriver.put(session.getSessionId(), session);
        return session.getSessionId();
    }

    @Override
    public Session get(SessionId sessionId) {
        return this.sessionIdToDriver.getIfPresent(sessionId);
    }

    @Override
    public void deleteSession(SessionId sessionId) {
        this.sessionIdToDriver.invalidate(sessionId);
    }

    @Override
    public Set<SessionId> getSessions() {
        return ImmutableSet.copyOf(this.sessionIdToDriver.asMap().keySet());
    }
}

