/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodAccessorFactory;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface DefaultMethod {
    public boolean cached() default true;

    public Class<?> targetType() default void.class;

    public boolean nullIfImpossible() default false;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<DefaultMethod>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape CACHED;
        private static final MethodDescription.InDefinedShape TARGET_TYPE;
        private static final MethodDescription.InDefinedShape NULL_IF_IMPOSSIBLE;

        @Override
        public Class<DefaultMethod> getHandledType() {
            return DefaultMethod.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<DefaultMethod> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            if (!target.getType().asErasure().isAssignableFrom(Method.class)) {
                throw new IllegalStateException("Cannot assign Method type to " + target);
            }
            if (source.isMethod()) {
                TypeDescription typeDescription = annotation.getValue(TARGET_TYPE).resolve(TypeDescription.class);
                Implementation.SpecialMethodInvocation specialMethodInvocation = (typeDescription.represents(Void.TYPE) ? MethodLocator.ForImplicitType.INSTANCE : new MethodLocator.ForExplicitType(typeDescription)).resolve(implementationTarget, source);
                if (specialMethodInvocation.isValid()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(new DelegationMethod(specialMethodInvocation, annotation.getValue(CACHED).resolve(Boolean.class)));
                }
                if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
                }
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
            }
            return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        static {
            MethodList<MethodDescription.InDefinedShape> methodList = new TypeDescription.ForLoadedType(DefaultMethod.class).getDeclaredMethods();
            CACHED = (MethodDescription.InDefinedShape)((MethodList)methodList.filter(ElementMatchers.named("cached"))).getOnly();
            TARGET_TYPE = (MethodDescription.InDefinedShape)((MethodList)methodList.filter(ElementMatchers.named("targetType"))).getOnly();
            NULL_IF_IMPOSSIBLE = (MethodDescription.InDefinedShape)((MethodList)methodList.filter(ElementMatchers.named("nullIfImpossible"))).getOnly();
        }

        protected static class DelegationMethod
        implements StackManipulation {
            private final Implementation.SpecialMethodInvocation specialMethodInvocation;
            private final boolean cached;

            protected DelegationMethod(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean cached) {
                this.specialMethodInvocation = specialMethodInvocation;
                this.cached = cached;
            }

            @Override
            public boolean isValid() {
                return this.specialMethodInvocation.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                MethodConstant.CanCache stackManipulation = MethodConstant.forMethod(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC));
                return (this.cached ? FieldAccess.forField(implementationContext.cache(stackManipulation, new TypeDescription.ForLoadedType(Method.class))).read() : stackManipulation).apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DelegationMethod)) {
                    return false;
                }
                DelegationMethod other = (DelegationMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Implementation.SpecialMethodInvocation this$specialMethodInvocation = this.specialMethodInvocation;
                Implementation.SpecialMethodInvocation other$specialMethodInvocation = other.specialMethodInvocation;
                if (this$specialMethodInvocation == null ? other$specialMethodInvocation != null : !this$specialMethodInvocation.equals(other$specialMethodInvocation)) {
                    return false;
                }
                return this.cached == other.cached;
            }

            protected boolean canEqual(Object other) {
                return other instanceof DelegationMethod;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Implementation.SpecialMethodInvocation $specialMethodInvocation = this.specialMethodInvocation;
                result = result * 59 + ($specialMethodInvocation == null ? 43 : $specialMethodInvocation.hashCode());
                result = result * 59 + (this.cached ? 79 : 97);
                return result;
            }
        }

        protected static interface MethodLocator {
            public Implementation.SpecialMethodInvocation resolve(Implementation.Target var1, MethodDescription var2);

            public static class ForExplicitType
            implements MethodLocator {
                private final TypeDescription typeDescription;

                protected ForExplicitType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Implementation.SpecialMethodInvocation resolve(Implementation.Target implementationTarget, MethodDescription source) {
                    if (!this.typeDescription.isInterface()) {
                        throw new IllegalStateException(source + " method carries default method call parameter on non-interface type");
                    }
                    return implementationTarget.invokeDefault(source.asSignatureToken(), TargetType.resolve(this.typeDescription, implementationTarget.getInstrumentedType()));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForExplicitType)) {
                        return false;
                    }
                    ForExplicitType other = (ForExplicitType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForExplicitType;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }

            public static enum ForImplicitType implements MethodLocator
            {
                INSTANCE;


                @Override
                public Implementation.SpecialMethodInvocation resolve(Implementation.Target implementationTarget, MethodDescription source) {
                    return implementationTarget.invokeDefault(source.asSignatureToken());
                }
            }
        }
    }
}

