/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;

public class SafariOptions
extends MutableCapabilities {
    static final String SAFARI_TECH_PREVIEW = "Safari Technology Preview";
    @Deprecated
    public static final String CAPABILITY = "safari.options";
    private Map<String, Object> options = new TreeMap<String, Object>();

    public SafariOptions() {
        this.setUseTechnologyPreview(false);
        this.setCapability("browserName", "safari");
    }

    public SafariOptions(Capabilities source) {
        this();
        source.asMap().forEach((key, value) -> {
            if (CAPABILITY.equals(key) && value instanceof Map) {
                Map map = (Map)value;
                this.options.putAll(map);
            } else if (value != null) {
                this.setCapability((String)key, value);
            }
        });
    }

    @Override
    public SafariOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        if (capabilities instanceof SafariOptions) {
            return (SafariOptions)capabilities;
        }
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            return SafariOptions.fromJsonMap((Map)cap);
        }
        return new SafariOptions();
    }

    public SafariOptions setAutomaticInspection(boolean automaticInspection) {
        this.setCapability("safari:automaticInspection", automaticInspection);
        return this;
    }

    public SafariOptions setAutomaticProfiling(boolean automaticProfiling) {
        this.setCapability("safari:automaticProfiling", automaticProfiling);
        return this;
    }

    public SafariOptions setUseTechnologyPreview(boolean useTechnologyPreview) {
        this.options.put("technologyPreview", useTechnologyPreview);
        super.setCapability("browserName", useTechnologyPreview ? SAFARI_TECH_PREVIEW : "safari");
        return this;
    }

    @Override
    public void setCapability(String key, Object value) {
        if ("technologyPreview".equals(key)) {
            this.setUseTechnologyPreview(Boolean.valueOf(value.toString()));
        } else {
            super.setCapability(key, value);
        }
    }

    @Override
    public void setCapability(String key, boolean value) {
        if ("technologyPreview".equals(key)) {
            this.setUseTechnologyPreview(value);
        } else {
            super.setCapability(key, value);
        }
    }

    public SafariOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    public boolean getAutomaticInspection() {
        return Boolean.TRUE.equals(this.getCapability("safari:automaticInspection"));
    }

    public boolean getAutomaticProfiling() {
        return Boolean.TRUE.equals(this.is("safari:automaticProfiling"));
    }

    public boolean getUseTechnologyPreview() {
        return SAFARI_TECH_PREVIEW.equals(this.getBrowserName()) || this.options.get("technologyPreview") == Boolean.TRUE;
    }

    private static SafariOptions fromJsonMap(Map<?, ?> options) {
        SafariOptions safariOptions = new SafariOptions();
        Object useTechnologyPreview = options.get("technologyPreview");
        if (useTechnologyPreview instanceof Boolean) {
            safariOptions.setUseTechnologyPreview((Boolean)useTechnologyPreview);
        }
        return safariOptions;
    }

    @Override
    protected int amendHashCode() {
        return this.options.hashCode();
    }

    @Override
    public Map<String, Object> asMap() {
        return ((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)ImmutableSortedMap.naturalOrder().putAll(super.asMap())).put(CAPABILITY, this.options)).build();
    }

    private static interface Option {
        @Deprecated
        public static final String TECHNOLOGY_PREVIEW = "technologyPreview";
        public static final String AUTOMATIC_INSPECTION = "safari:automaticInspection";
        public static final String AUTOMATIC_PROFILING = "safari:automaticProfiling";
    }
}

