/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.Maps;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.AddFindsByCss;
import org.openqa.selenium.remote.AddFindsChildByCss;
import org.openqa.selenium.remote.AddRemoteTouchScreen;
import org.openqa.selenium.remote.AddRotatable;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.html5.AddApplicationCache;
import org.openqa.selenium.remote.html5.AddLocationContext;
import org.openqa.selenium.remote.html5.AddWebStorage;
import org.openqa.selenium.remote.mobile.AddNetworkConnection;

public abstract class BaseAugmenter {
    private final Map<String, AugmenterProvider> driverAugmentors = Maps.newHashMap();
    private final Map<String, AugmenterProvider> elementAugmentors = Maps.newHashMap();

    public BaseAugmenter() {
        this.addDriverAugmentation("cssSelectorsEnabled", new AddFindsByCss());
        this.addDriverAugmentation("locationContextEnabled", new AddLocationContext());
        this.addDriverAugmentation("applicationCacheEnabled", new AddApplicationCache());
        this.addDriverAugmentation("networkConnectionEnabled", new AddNetworkConnection());
        this.addDriverAugmentation("webStorageEnabled", new AddWebStorage());
        this.addDriverAugmentation("rotatable", new AddRotatable());
        this.addDriverAugmentation("hasTouchScreen", new AddRemoteTouchScreen());
        this.addElementAugmentation("cssSelectorsEnabled", new AddFindsChildByCss());
    }

    public void addDriverAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.driverAugmentors.put(capabilityName, handlerClass);
    }

    public void addElementAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.elementAugmentors.put(capabilityName, handlerClass);
    }

    public WebDriver augment(WebDriver driver) {
        RemoteWebDriver remoteDriver = this.extractRemoteWebDriver(driver);
        if (remoteDriver == null) {
            return driver;
        }
        return this.create(remoteDriver, this.driverAugmentors, driver);
    }

    public WebElement augment(RemoteWebElement element) {
        RemoteWebDriver parent = (RemoteWebDriver)element.getWrappedDriver();
        if (parent == null) {
            return element;
        }
        return this.create(parent, this.elementAugmentors, element);
    }

    protected abstract <X> X create(RemoteWebDriver var1, Map<String, AugmenterProvider> var2, X var3);

    protected abstract RemoteWebDriver extractRemoteWebDriver(WebDriver var1);
}

