/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.awt.Color;
import java.util.Map;

public class HtmlColorInput
extends HtmlInput {
    HtmlColorInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        if (this.getValueAttribute() == ATTRIBUTE_NOT_DEFINED && !this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START)) {
            this.setValueAttribute("#" + Integer.toHexString(Color.black.getRGB()).substring(2));
        }
    }

    @Override
    public void setValueAttribute(String newValue) {
        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START) || HtmlColorInput.isValid(newValue)) {
            super.setValueAttribute(newValue);
        }
    }

    private static boolean isValid(String value) {
        boolean valid = false;
        if (value.length() == 7 && value.charAt(0) == '#') {
            try {
                new Color(Integer.valueOf(value.substring(1, 3), 16), Integer.valueOf(value.substring(3, 5), 16), Integer.valueOf(value.substring(5, 7), 16));
                valid = true;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return valid;
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

