/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.Messages;
import java.io.PrintWriter;

public class WriterReportImpl
implements Report {
    private PrintWriter out;
    private int errorCount;
    private int warningCount;
    private int exceptionCount;
    private boolean quiet;

    public WriterReportImpl(PrintWriter out) {
        this(out, false);
    }

    public WriterReportImpl(PrintWriter out, boolean quiet) {
        this(out, null, quiet);
    }

    public WriterReportImpl(PrintWriter out, String info) {
        this(out, info, false);
    }

    public WriterReportImpl(PrintWriter out, String info, boolean quiet) {
        this.out = out;
        if (info != null) {
            this.warning("", 0, 0, info);
        }
        this.errorCount = 0;
        this.warningCount = 0;
        this.exceptionCount = 0;
        this.quiet = quiet;
    }

    private String fixMessage(String message) {
        return message.replaceAll("[\\s]+", " ");
    }

    @Override
    public void error(String resource, int line, int column, String message) {
        ++this.errorCount;
        message = this.fixMessage(message);
        this.out.println("ERROR: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public void warning(String resource, int line, int column, String message) {
        ++this.warningCount;
        message = this.fixMessage(message);
        this.out.println("WARNING: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public void exception(String resource, Exception e) {
        ++this.exceptionCount;
        this.out.println("EXCEPTION: " + (resource == null ? "" : "/" + resource) + ": " + e.getMessage());
    }

    @Override
    public int getExceptionCount() {
        return this.exceptionCount;
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        if (feature == FeatureEnum.FORMAT_VERSION && !this.quiet) {
            this.out.println("INFO: " + String.format(Messages.VALIDATING_VERSION_MESSAGE, value));
        }
    }

    @Override
    public void hint(String resource, int line, int column, String message) {
        if (!this.quiet) {
            this.out.println("HINT: " + (resource == null ? "[top level]" : resource) + (line <= 0 ? "" : "(" + line + (column <= 0 ? "" : "," + column) + ")") + ": " + message);
        }
    }
}

