/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.util.StringUtil;

public class SingleTestSuiteResourceHandler
extends ResourceHandler {
    private static final String HTML = "<html>\n<head>\n<title>{0} Suite</title>\n</head>\n<body>\n<table cellpadding=\"1\" cellspacing=\"1\" border=\"1\">\n<tbody>\n<tr><td><b>{0} Suite</b></td></tr>\n<tr><td><a href=\"{1}\">{0}</a></td></tr>\n</tbody>\n</table>\n</body>\n</html>";

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (!pathInContext.startsWith("/singleTest/")) {
            return;
        }
        request.setHandled(true);
        String url = pathInContext.substring("/singleTest/".length());
        OutputStream outStream = response.getOutputStream();
        if (url == null) {
            outStream.write("No singleTest was specified!".getBytes());
            outStream.flush();
            return;
        }
        response.setContentType("text/html");
        String suiteName = this.getSuiteName(url);
        OutputStreamWriter writer = new OutputStreamWriter(response.getOutputStream(), StringUtil.__ISO_8859_1);
        writer.write(MessageFormat.format(HTML, suiteName, url));
        ((Writer)writer).flush();
    }

    private String getSuiteName(String path) {
        int lastSlash = path.lastIndexOf(47);
        String fileName = path.substring(lastSlash + 1);
        return fileName;
    }
}

