# Generated by default/object.tt
package Paws::IoTAnalytics::ChannelMessages;
  use Moose;
  has S3Paths => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 's3Paths', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTAnalytics::ChannelMessages

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTAnalytics::ChannelMessages object:

  $service_obj->Method(Att1 => { S3Paths => $value, ..., S3Paths => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTAnalytics::ChannelMessages object:

  $result = $service_obj->Method(...);
  $result->Att1->S3Paths

=head1 DESCRIPTION

Specifies one or more sets of channel messages.

=head1 ATTRIBUTES


=head2 S3Paths => ArrayRef[Str|Undef]

Specifies one or more keys that identify the Amazon Simple Storage
Service (Amazon S3) objects that save your channel messages.

You must use the full path for the key.

Example path: C<channel/mychannel/__dt=2020-02-29
00:00:00/1582940490000_1582940520000_123456789012_mychannel_0_2118.0.json.gz>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

