# Generated by default/object.tt
package Paws::Organizations::Tag;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Organizations::Tag

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Organizations::Tag object:

  $service_obj->Method(Att1 => { Key => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Organizations::Tag object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

A custom key-value pair associated with a resource within your
organization.

You can attach tags to any of the following organization resources.

=over

=item *

AWS account

=item *

Organizational unit (OU)

=item *

Organization root

=item *

Policy

=back


=head1 ATTRIBUTES


=head2 B<REQUIRED> Key => Str

The key identifier, or name, of the tag.


=head2 B<REQUIRED> Value => Str

The string value that's associated with the key of the tag. You can set
the value of a tag to an empty string, but you can't set the value of a
tag to null.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Organizations>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

