use strict;
use warnings;
use Test::More;
use Digest::Keccak qw(keccak_256 keccak_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Keccak->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            keccak_256_hex($data), $digest,
            "keccak_256_hex: $len bits of $msg"
        );
        ok(
            keccak_256($data) eq pack('H*', $digest),
            "keccak_256: $len bits of $msg"
        );
    }

    my $md = Digest::Keccak->new(256)->add_bits($data, $len)
        ->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|C5D2460186F7233C927E7DB2DCC703C0E500B653CA82273B7BFAD8045D85A470
00|C3E5CB55999EEFF4E07B7EFFEC77582D0A5A11A94FC268A872493099273992E1
C0|3A1108D4A90A31B85A10BDCE77F4BFBDCC5B1D70DD405686F8BBDE834AA1A410
C0|7384D12118DA4AD51A519806E2529FB2548B5DCE2A87122B8507F71A28A35DEB
80|53E5E48805AE70306BF9DDC26E9EE2DB87AFE95EF0BFB9F9C44211BE11A4C810
48|C341F676DA4D10D32D9DAD5140D497FECFE9565C79F4F5AA7F1D3C36B290FE3B
50|80B7ED96C53F37EBD0A0F2F7C63B0B35480F57215AB8C5FDF9F5F6E989A53366
98|ACA86EE608E0A6E31C0173F2EEDEE26C527F108F7F11A19A2E4327116485414C
CC|EEAD6DBFC7340A56CAEDC044696A168870549A6A7F6F56961E84A54BD9970B8A
9800|C4F437FE4FEB0C18374C8DC1ADE599C5E3F1B68A27D25AE5FC63AFF64215DEC0
9D40|347B1E3842FEC39CFD8E4368AC9DED9498C545778C665DE29B355FCD32B968EF
AA80|5C0E432A4CE0D37047442ACCCB27F5BCF8817B085B0C476D83A0324265023A23
9830|5F533B014DD834E4A833CEFD68185B84E4E805DF6DD2DA8D9B891B89BE414516
5030|ADE94E747FC7B97F051467FC4B62799217054CB4DDBA5EED5166522C30671767
4D24|65126BC60DF2CA9FD9BA08D22540CEB67DD9F5A1B90037084A3C2098ADF35AFA
CBDE|CEEF2CC62B98D5BA981C5AA6ADC0CD811D2B703D82A52B741445B756D3A17E9F
41FB|A8EACEDA4D47B3281A795AD9E1EA2122B407BAF9AABCB9E18B5717B7873537D2
4FF400|FEB2D9EE5DB62E192CC136B0328F1A04732CF5CD4DBE067B5FB35E729D9DE106
FD0440|EFDA1D093A29B770CF95BE39BD960165BD7DBBDEC9DECAFFDAEE3E34426CB670
424D00|2967863A3FA769311C98153EA71B2F58FAC2AEFC92D502D2B030DAA097631A09
3FDEE0|8FC23D199D8DB9044B6B313D0789D39EAD31CE7392A5C1F7227810EEE619F949
335768|857E9BC126CE62A333CAAE30B7BA7BD4A84F4E8BCF05A72E4B127FC7A0990B1E
051E7C|DB333F4801AE3F521636EACB798C17BF6C317F2DFCA4A88E2E4D2587A2C5E28E
717F8C|93246A0962C915B7319711C35C5A03B318101C9C970852FDE60A5288CA55054B
1F877C|627D7BC1491B2AB127282827B8DE2D276B13D7D70FB4C5957FDF20655BC7AC30
EB35CF80|4AEE49625742C0E7713DB8409F7B5A0ABEA42A52BE534F2362B30F0BF04AD765
B406C480|5EC09D130EC4396AAE8C7CA02637C572A38BE2499243DABFE8DD04BE24B8CD86
CEE88040|4AE73C07E666D4709C8551A05AB88E36D6F0AFAC66B6603022FA662DC5A15E45
C584DB70|18AB7589FD160AA6E44D7D7E07E271F3B8CE4C92103107C0495366286946B993
53587BC8|4F04A937E7E18C58B575426766B0D94B47CB305CC2205B7CDDD200021F9AED22
69A305B0|C96BF48340982CA3EAD3C1471F2001BC21FCF06771264462EEC6FE9B67048483
C9375ECE|8DE0214DEB21ED025350FCE18E9A53D72B43114AEC720775C62D6CF6C297802A
C1ECFDFC|B149E766D7612EAF7D55F74E1A4FDD63709A8115B14F61FCD22AA4ABC8B8E122
8D73E8A280|EF82B3BF37A2E5E4D8307FEF97979FC369F30F1C5C99C9CE844698244FBA539C
06F2522080|142A5D1A4691A4CB45718917B47A90540C986DB9EA492F952208CD1513A86109
3EF6C36F20|5981816520C69459284F988464C2830BEA42198D07EB616253FF7692EEC2428A
0127A1D340|48D2AA43D1287AE2ED57B900FA0912EB166C6BA25184528C3A7E11A9B5BFF302
6A6AB6C210|D3D34FA208E7F89625E31F13245919A837954B228CDF020DC1C2ACF8DC00829E
AF3175E160|3465375BEB6397B152B56B5945521CA60328E08C3C6F8D2B4994B9BB6FA1D8CD
B66609ED86|3B81E1D58A40849F5F08FD56B1B09547AF3915C9EB955A0C97188462520C5B37
21F134AC57|67F05544DBE97D5D6417C1B1EA9BC0E3A99A541381D1CD9B08A9765687EB5BB4
3DC2AADFFC80|E384EEF58B65B4889D9A573A8D29949D233950E6E35974ADC381F100CAB7457F
9202736D2240|6920522DD6F3233CFC549F354F3C9C559EEDD0C9615F99E447653740F8D10B39
F219BD629820|A32077883406BF909951F6A56D02990954C2450B0FE78DBB08F9117179F3D371
F3511EE2C4B0|FE07FBF11CC5B997881A8ED1539033BF6EADCC5741A38A54BCE59700036C3CF0
3ECAB6BF7720|FE2865FBB5D95F1952EF200F054AF4F2D80E32AB54B0080C3E5DE6861AF0FEEA
CD62F688F498|239BC9DFEAFB7A887C8CE1105CFEFC5D00C27A57A0B0DBA07728007F154B837B
C2CBAA33A9F8|1CE4BC22AEA81814DEFB4612D8114EE71C466336E768A761979652461B2273E0
C6F50BB74E29|923062C4E6F057597220D182DBB10E81CD25F60B54005B2A75DD33D6DAC518D0
79F1B4CCC62A00|33D0AB4E9DA0A2E41B994BCBB41377A8DA5DBEA4B3D77FCFACB69341EBC14059
