package Chart::Plotly::Trace::Choroplethmapbox::Marker;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

use Chart::Plotly::Trace::Choroplethmapbox::Marker::Line;

our $VERSION = '0.040';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace choroplethmapbox.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has line => ( is  => "rw",
              isa => "Maybe[HashRef]|Chart::Plotly::Trace::Choroplethmapbox::Marker::Line", );

has opacity => ( is            => "rw",
                 isa           => "Num|ArrayRef[Num]",
                 documentation => "Sets the opacity of the locations.",
);

has opacitysrc => ( is            => "rw",
                    isa           => "Str",
                    documentation => "Sets the source reference on plot.ly for  opacity .",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Choroplethmapbox::Marker - This attribute is one of the possible options for the trace choroplethmapbox.

=head1 VERSION

version 0.040

=head1 SYNOPSIS

 use Chart::Plotly;
 use Chart::Plotly::Plot;
 use JSON;
 use Chart::Plotly::Trace::Choroplethmapbox;
 
 # Example from https://github.com/plotly/plotly.js/blob/cb202a8e47631e20555de382d2bbc7393625519b/test/image/mocks/mapbox_choropleth0.json
 my $trace1 = Chart::Plotly::Trace::Choroplethmapbox->new({'locations' => ['NY', 'MA', 'VT', ], 'geojson' => 'https://raw.githubusercontent.com/python-visualization/folium/master/examples/data/us-states.json', 'z' => [10, 20, 30, ], });
 
 
 my $plot = Chart::Plotly::Plot->new(
     traces => [$trace1, ],
     layout => 
         {'width' => 600, 'mapbox' => {'style' => 'open-street-map', 'center' => {'lon' => -74.22, 'lat' => 42.35, }, 'zoom' => 3.5, }, }
 ); 
 
 Chart::Plotly::show_plot($plot);

=head1 DESCRIPTION

This attribute is part of the possible options for the trace choroplethmapbox.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#choroplethmapbox>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * line

=item * opacity

Sets the opacity of the locations.

=item * opacitysrc

Sets the source reference on plot.ly for  opacity .

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
