package Microsoft::AdCenter::V8::ReportingService::CampaignPerformanceReportColumn;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V8::ReportingService::CampaignPerformanceReportColumn - Represents "CampaignPerformanceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountName
    AccountNumber
    AdDistribution
    AverageCpc
    AverageCpm
    AveragePosition
    CampaignId
    CampaignName
    Clicks
    ConversionRate
    Conversions
    CostPerConversion
    Ctr
    CurrencyCode
    DeviceOS
    DeviceType
    HistoricKeywordRelevance
    HistoricLandingPageRelevance
    HistoricLandingPageUserExperience
    HistoricQualityScore
    ImpressionLostToBidPercent
    ImpressionLostToBudgetPercent
    ImpressionLostToKeywordRelevancePercent
    ImpressionLostToLandingPageRelevancePercent
    ImpressionLostToOthersPercent
    ImpressionLostToRankPercent
    ImpressionLostToRelevancePercent
    Impressions
    ImpressionSharePercent
    KeywordRelevance
    LandingPageRelevance
    LandingPageUserExperience
    LowQualityClicks
    LowQualityClicksPercent
    LowQualityConversionRate
    LowQualityConversions
    LowQualityImpressions
    LowQualityImpressionsPercent
    QualityScore
    Spend
    Status
    TimePeriod

=cut

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AverageCpm {
    return 'AverageCpm';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub CostPerConversion {
    return 'CostPerConversion';
}

sub Ctr {
    return 'Ctr';
}

sub CurrencyCode {
    return 'CurrencyCode';
}

sub DeviceOS {
    return 'DeviceOS';
}

sub DeviceType {
    return 'DeviceType';
}

sub HistoricKeywordRelevance {
    return 'HistoricKeywordRelevance';
}

sub HistoricLandingPageRelevance {
    return 'HistoricLandingPageRelevance';
}

sub HistoricLandingPageUserExperience {
    return 'HistoricLandingPageUserExperience';
}

sub HistoricQualityScore {
    return 'HistoricQualityScore';
}

sub ImpressionLostToBidPercent {
    return 'ImpressionLostToBidPercent';
}

sub ImpressionLostToBudgetPercent {
    return 'ImpressionLostToBudgetPercent';
}

sub ImpressionLostToKeywordRelevancePercent {
    return 'ImpressionLostToKeywordRelevancePercent';
}

sub ImpressionLostToLandingPageRelevancePercent {
    return 'ImpressionLostToLandingPageRelevancePercent';
}

sub ImpressionLostToOthersPercent {
    return 'ImpressionLostToOthersPercent';
}

sub ImpressionLostToRankPercent {
    return 'ImpressionLostToRankPercent';
}

sub ImpressionLostToRelevancePercent {
    return 'ImpressionLostToRelevancePercent';
}

sub Impressions {
    return 'Impressions';
}

sub ImpressionSharePercent {
    return 'ImpressionSharePercent';
}

sub KeywordRelevance {
    return 'KeywordRelevance';
}

sub LandingPageRelevance {
    return 'LandingPageRelevance';
}

sub LandingPageUserExperience {
    return 'LandingPageUserExperience';
}

sub LowQualityClicks {
    return 'LowQualityClicks';
}

sub LowQualityClicksPercent {
    return 'LowQualityClicksPercent';
}

sub LowQualityConversionRate {
    return 'LowQualityConversionRate';
}

sub LowQualityConversions {
    return 'LowQualityConversions';
}

sub LowQualityImpressions {
    return 'LowQualityImpressions';
}

sub LowQualityImpressionsPercent {
    return 'LowQualityImpressionsPercent';
}

sub QualityScore {
    return 'QualityScore';
}

sub Spend {
    return 'Spend';
}

sub Status {
    return 'Status';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
