package Microsoft::AdCenter::V8::ReportingService::ConversionPerformanceReportColumn;
# Copyright (C) 2011 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V8::ReportingService::ConversionPerformanceReportColumn - Represents "ConversionPerformanceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdGroupId
    AdGroupName
    Assists
    CampaignId
    CampaignName
    Clicks
    ConversionRate
    Conversions
    CostPerAssist
    CostPerConversion
    Ctr
    DeviceType
    ExtendedCost
    Impressions
    Keyword
    KeywordId
    ReturnOnAdSpend
    Revenue
    RevenuePerAssist
    RevenuePerConversion
    Spend
    TimePeriod

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub Assists {
    return 'Assists';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub CostPerAssist {
    return 'CostPerAssist';
}

sub CostPerConversion {
    return 'CostPerConversion';
}

sub Ctr {
    return 'Ctr';
}

sub DeviceType {
    return 'DeviceType';
}

sub ExtendedCost {
    return 'ExtendedCost';
}

sub Impressions {
    return 'Impressions';
}

sub Keyword {
    return 'Keyword';
}

sub KeywordId {
    return 'KeywordId';
}

sub ReturnOnAdSpend {
    return 'ReturnOnAdSpend';
}

sub Revenue {
    return 'Revenue';
}

sub RevenuePerAssist {
    return 'RevenuePerAssist';
}

sub RevenuePerConversion {
    return 'RevenuePerConversion';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
