#!/usr/bin/perl -w

=head2

=item Creator: Andrew Robertson

=back

=item Revised: 20020527

=back

=item License: GPL 2

=back

Description:

	forty_two_random creates a random mahjongg tileset from a set of japanese kanji, oriented around grade.
	The file is created as temp.xpm.  You need to convert is to png and move it to the mahjongg pixmaps
	directory, just like in mahjongg_hirigana.pl.

Syntax:

  forty_two_random <grade>
	Where:
		grade is G1 -> G9.  Where G1-6 are gradeschool characters.  G8 is general use characters.  And, G9 are
		name characters.  There is no G7,  G7 produces strange results.

=cut

use FONT::FT2 ':all';

$retval = init("/usr/share/fonts/ja/TrueType/kochi-mincho.ttf"); #japanese italic
if (!defined($retval)) {
	print "Unable to initialize font!\n";
	exit(0);
}

my %grades = (
          'G8' => [
                    'U4e9c',
                    'U54c0',
                    'U63e1',
                    'U6271',
                    'U4f9d',
                    'U5049',
                    'U5a01',
                    'U5c09',
                    'U6170',
                    'U70ba',
                    'U7dad',
                    'U7def',
                    'U9055',
                    'U4e95',
                    'U58f1',
                    'U9038',
                    'U7a32',
                    'U828b',
                    'U59fb',
                    'U9670',
                    'U96a0',
                    'U97fb',
                    'U6e26',
                    'U6d66',
                    'U5f71',
                    'U8a60',
                    'U92ed',
                    'U75ab',
                    'U60a6',
                    'U8b01',
                    'U8d8a',
                    'U95b2',
                    'U5bb4',
                    'U63f4',
                    'U708e',
                    'U7159',
                    'U733f',
                    'U7e01',
                    'U925b',
                    'U6c5a',
                    'U51f9',
                    'U5965',
                    'U62bc',
                    'U6b27',
                    'U6bb4',
                    'U7fc1',
                    'U6c96',
                    'U61b6',
                    'U4e59',
                    'U5378',
                    'U7a4f',
                    'U4f73',
                    'U5ac1',
                    'U5be1',
                    'U6687',
                    'U67b6',
                    'U798d',
                    'U7a3c',
                    'U7b87',
                    'U83ef',
                    'U83d3',
                    'U868a',
                    'U96c5',
                    'U9913',
                    'U4ecb',
                    'U584a',
                    'U58ca',
                    'U602a',
                    'U6094',
                    'U61d0',
                    'U6212',
                    'U62d0',
                    'U7686',
                    'U52be',
                    'U6168',
                    'U6982',
                    'U6daf',
                    'U8a72',
                    'U57a3',
                    'U5687',
                    'U6838',
                    'U6bbb',
                    'U7372',
                    'U7a6b',
                    'U8f03',
                    'U90ed',
                    'U9694',
                    'U5cb3',
                    'U639b',
                    'U6f5f',
                    'U559d',
                    'U62ec',
                    'U6e07',
                    'U6ed1',
                    'U8910',
                    'U8f44',
                    'U4e14',
                    'U5208',
                    'U4e7e',
                    'U51a0',
                    'U52d8',
                    'U52e7',
                    'U559a',
                    'U582a',
                    'U5bdb',
                    'U60a3',
                    'U61be',
                    'U63db',
                    'U6562',
                    'U68fa',
                    'U6b3e',
                    'U6b53',
                    'U6c57',
                    'U74b0',
                    'U7518',
                    'U76e3',
                    'U7de9',
                    'U7f36',
                    'U809d',
                    'U8266',
                    'U8cab',
                    'U9084',
                    'U9451',
                    'U9591',
                    'U9665',
                    'U542b',
                    'U9811',
                    'U4f01',
                    'U5947',
                    'U5c90',
                    'U5e7e',
                    'U5fcc',
                    'U65e2',
                    'U68cb',
                    'U68c4',
                    'U7948',
                    'U8ecc',
                    'U8f1d',
                    'U98e2',
                    'U9a0e',
                    'U9b3c',
                    'U507d',
                    'U5100',
                    'U5b9c',
                    'U622f',
                    'U64ec',
                    'U6b3a',
                    'U72a0',
                    'U83ca',
                    'U5409',
                    'U55ab',
                    'U8a70',
                    'U5374',
                    'U811a',
                    'U8650',
                    'U4e18',
                    'U53ca',
                    'U673d',
                    'U7aae',
                    'U7cfe',
                    'U5de8',
                    'U62d2',
                    'U62e0',
                    'U865a',
                    'U8ddd',
                    'U4eab',
                    'U51f6',
                    'U53eb',
                    'U5ce1',
                    'U6050',
                    'U606d',
                    'U631f',
                    'U6cc1',
                    'U72c2',
                    'U72ed',
                    'U77ef',
                    'U8105',
                    'U97ff',
                    'U9a5a',
                    'U4ef0',
                    'U51dd',
                    'U6681',
                    'U65a4',
                    'U7434',
                    'U7dca',
                    'U83cc',
                    'U895f',
                    'U8b39',
                    'U541f',
                    'U99c6',
                    'U611a',
                    'U865e',
                    'U5076',
                    'U9047',
                    'U9685',
                    'U5c48',
                    'U6398',
                    'U9774',
                    'U7e70',
                    'U6851',
                    'U52f2',
                    'U85ab',
                    'U50be',
                    'U5211',
                    'U5553',
                    'U5951',
                    'U6075',
                    'U6176',
                    'U61a9',
                    'U63b2',
                    'U643a',
                    'U6e13',
                    'U7d99',
                    'U830e',
                    'U86cd',
                    'U9d8f',
                    'U8fce',
                    'U9be8',
                    'U6483',
                    'U5091',
                    'U5039',
                    'U517c',
                    'U5263',
                    'U570f',
                    'U5805',
                    'U5acc',
                    'U61f8',
                    'U732e',
                    'U80a9',
                    'U8b19',
                    'U8ce2',
                    'U8ed2',
                    'U9063',
                    'U9855',
                    'U5e7b',
                    'U5f26',
                    'U7384',
                    'U5b64',
                    'U5f27',
                    'U67af',
                    'U8a87',
                    'U96c7',
                    'U9867',
                    'U9f13',
                    'U4e92',
                    'U5449',
                    'U5a2f',
                    'U5fa1',
                    'U609f',
                    'U7881',
                    'U4faf',
                    'U5751',
                    'U5b54',
                    'U5de7',
                    'U6052',
                    'U614c',
                    'U6297',
                    'U62d8',
                    'U63a7',
                    'U653b',
                    'U66f4',
                    'U6c5f',
                    'U6d2a',
                    'U6e9d',
                    'U7532',
                    'U786c',
                    'U7a3f',
                    'U7d5e',
                    'U7db1',
                    'U80af',
                    'U8352',
                    'U8861',
                    'U8ca2',
                    'U8cfc',
                    'U90ca',
                    'U9175',
                    'U9805',
                    'U9999',
                    'U525b',
                    'U62f7',
                    'U8c6a',
                    'U514b',
                    'U9177',
                    'U7344',
                    'U8170',
                    'U8fbc',
                    'U58be',
                    'U5a5a',
                    'U6068',
                    'U61c7',
                    'U6606',
                    'U7d3a',
                    'U9b42',
                    'U4f50',
                    'U5506',
                    'U8a50',
                    'U9396',
                    'U50b5',
                    'U50ac',
                    'U5bb0',
                    'U5f69',
                    'U683d',
                    'U6b73',
                    'U7815',
                    'U658e',
                    'U8f09',
                    'U5264',
                    'U54b2',
                    'U5d0e',
                    'U524a',
                    'U643e',
                    'U7d22',
                    'U932f',
                    'U64ae',
                    'U64e6',
                    'U5098',
                    'U60e8',
                    'U685f',
                    'U66ab',
                    'U4f3a',
                    'U523a',
                    'U55e3',
                    'U65bd',
                    'U65e8',
                    'U7949',
                    'U7d2b',
                    'U80a2',
                    'U8102',
                    'U8aee',
                    'U8cdc',
                    'U96cc',
                    'U4f8d',
                    'U6148',
                    'U6ecb',
                    'U74bd',
                    'U8ef8',
                    'U57f7',
                    'U6e7f',
                    'U6f06',
                    'U75be',
                    'U829d',
                    'U8d66',
                    'U659c',
                    'U716e',
                    'U906e',
                    'U86c7',
                    'U90aa',
                    'U52fa',
                    'U7235',
                    'U914c',
                    'U91c8',
                    'U5bc2',
                    'U6731',
                    'U6b8a',
                    'U72e9',
                    'U73e0',
                    'U8da3',
                    'U5112',
                    'U5bff',
                    'U9700',
                    'U56da',
                    'U6101',
                    'U79c0',
                    'U81ed',
                    'U821f',
                    'U8972',
                    'U916c',
                    'U919c',
                    'U5145',
                    'U67d4',
                    'U6c41',
                    'U6e0b',
                    'U7363',
                    'U9283',
                    'U53d4',
                    'U6dd1',
                    'U7c9b',
                    'U587e',
                    'U4fca',
                    'U77ac',
                    'U51c6',
                    'U5faa',
                    'U65ec',
                    'U6b89',
                    'U6f64',
                    'U76fe',
                    'U5de1',
                    'U9075',
                    'U5eb6',
                    'U7dd2',
                    'U53d9',
                    'U5f90',
                    'U511f',
                    'U5320',
                    'U5347',
                    'U53ec',
                    'U5968',
                    'U5bb5',
                    'U5c1a',
                    'U5e8a',
                    'U5f70',
                    'U6284',
                    'U638c',
                    'U6607',
                    'U6676',
                    'U6cbc',
                    'U6e09',
                    'U7126',
                    'U75c7',
                    'U785d',
                    'U7901',
                    'U7965',
                    'U79f0',
                    'U7ca7',
                    'U7d39',
                    'U8096',
                    'U885d',
                    'U8a1f',
                    'U8a54',
                    'U8a73',
                    'U9418',
                    'U4e08',
                    'U5197',
                    'U5270',
                    'U58cc',
                    'U5b22',
                    'U6d44',
                    'U7573',
                    'U8b72',
                    'U91b8',
                    'U9320',
                    'U5631',
                    'U98fe',
                    'U6b96',
                    'U89e6',
                    'U8fb1',
                    'U4f38',
                    'U4fb5',
                    'U5507',
                    'U5a20',
                    'U5bdd',
                    'U5be9',
                    'U614e',
                    'U632f',
                    'U6d78',
                    'U7d33',
                    'U85aa',
                    'U8a3a',
                    'U8f9b',
                    'U9707',
                    'U5203',
                    'U5c0b',
                    'U751a',
                    'U5c3d',
                    'U8fc5',
                    'U9663',
                    'U9162',
                    'U5439',
                    'U5e25',
                    'U708a',
                    'U7761',
                    'U7c8b',
                    'U8870',
                    'U9042',
                    'U9154',
                    'U9318',
                    'U968f',
                    'U9ac4',
                    'U5d07',
                    'U67a2',
                    'U636e',
                    'U6749',
                    'U6f84',
                    'U702c',
                    'U755d',
                    'U662f',
                    'U59d3',
                    'U5f81',
                    'U7272',
                    'U8a93',
                    'U8acb',
                    'U901d',
                    'U6589',
                    'U96bb',
                    'U60dc',
                    'U65a5',
                    'U6790',
                    'U7c4d',
                    'U8de1',
                    'U62d9',
                    'U6442',
                    'U7a83',
                    'U4ed9',
                    'U5360',
                    'U6247',
                    'U6813',
                    'U6f5c',
                    'U65cb',
                    'U7e4a',
                    'U85a6',
                    'U8df5',
                    'U9077',
                    'U9291',
                    'U9bae',
                    'U6f38',
                    'U7985',
                    'U7e55',
                    'U5851',
                    'U63aa',
                    'U758e',
                    'U790e',
                    'U79df',
                    'U7c97',
                    'U8a34',
                    'U963b',
                    'U50e7',
                    'U53cc',
                    'U55aa',
                    'U58ee',
                    'U635c',
                    'U6383',
                    'U633f',
                    'U66f9',
                    'U69fd',
                    'U71e5',
                    'U8358',
                    'U846c',
                    'U85fb',
                    'U906d',
                    'U971c',
                    'U9a12',
                    'U618e',
                    'U8d08',
                    'U4fc3',
                    'U5373',
                    'U4fd7',
                    'U8cca',
                    'U5815',
                    'U59a5',
                    'U60f0',
                    'U99c4',
                    'U8010',
                    'U6020',
                    'U66ff',
                    'U6cf0',
                    'U6ede',
                    'U80ce',
                    'U888b',
                    'U902e',
                    'U6edd',
                    'U5353',
                    'U629e',
                    'U62d3',
                    'U6ca2',
                    'U6fef',
                    'U8a17',
                    'U6fc1',
                    'U8afe',
                    'U4f46',
                    'U596a',
                    'U8131',
                    'U68da',
                    'U4e39',
                    'U5606',
                    'U6de1',
                    'U7aef',
                    'U80c6',
                    'U935b',
                    'U58c7',
                    'U5f3e',
                    'U6065',
                    'U75f4',
                    'U7a1a',
                    'U81f4',
                    'U9045',
                    'U755c',
                    'U84c4',
                    'U9010',
                    'U79e9',
                    'U7a92',
                    'U5ae1',
                    'U62bd',
                    'U8877',
                    'U92f3',
                    'U99d0',
                    'U5f14',
                    'U5f6b',
                    'U5fb4',
                    'U61f2',
                    'U6311',
                    'U773a',
                    'U8074',
                    'U8139',
                    'U8d85',
                    'U8df3',
                    'U52c5',
                    'U6715',
                    'U6c88',
                    'U73cd',
                    'U93ae',
                    'U9673',
                    'U6d25',
                    'U589c',
                    'U585a',
                    'U6f2c',
                    'U576a',
                    'U91e3',
                    'U4ead',
                    'U5075',
                    'U8c9e',
                    'U5448',
                    'U5824',
                    'U5e1d',
                    'U5ef7',
                    'U62b5',
                    'U7de0',
                    'U8247',
                    'U8a02',
                    'U9013',
                    'U90b8',
                    'U6ce5',
                    'U6458',
                    'U6ef4',
                    'U54f2',
                    'U5fb9',
                    'U64a4',
                    'U8fed',
                    'U6dfb',
                    'U6bbf',
                    'U5410',
                    'U5857',
                    'U6597',
                    'U6e21',
                    'U9014',
                    'U5974',
                    'U6012',
                    'U5012',
                    'U51cd',
                    'U5510',
                    'U5854',
                    'U60bc',
                    'U642d',
                    'U6843',
                    'U68df',
                    'U76d7',
                    'U75d8',
                    'U7b52',
                    'U5230',
                    'U8b04',
                    'U8e0f',
                    'U9003',
                    'U900f',
                    'U9676',
                    'U9a30',
                    'U95d8',
                    'U6d1e',
                    'U80f4',
                    'U5ce0',
                    'U533f',
                    'U7763',
                    'U7be4',
                    'U51f8',
                    'U7a81',
                    'U5c6f',
                    'U8c5a',
                    'U66c7',
                    'U920d',
                    'U7e04',
                    'U8edf',
                    'U5c3c',
                    'U5f10',
                    'U5982',
                    'U5c3f',
                    'U598a',
                    'U5fcd',
                    'U5be7',
                    'U732b',
                    'U7c98',
                    'U60a9',
                    'U6fc3',
                    'U628a',
                    'U8987',
                    'U5a46',
                    'U5ec3',
                    'U6392',
                    'U676f',
                    'U8f29',
                    'U57f9',
                    'U5a92',
                    'U8ce0',
                    'U966a',
                    'U4f2f',
                    'U62cd',
                    'U6cca',
                    'U8236',
                    'U8584',
                    'U8feb',
                    'U6f20',
                    'U7206',
                    'U7e1b',
                    'U808c',
                    'U9262',
                    'U9aea',
                    'U4f10',
                    'U7f70',
                    'U629c',
                    'U95a5',
                    'U4f34',
                    'U5e06',
                    'U642c',
                    'U7554',
                    'U7e41',
                    'U822c',
                    'U85e9',
                    'U8ca9',
                    'U7bc4',
                    'U7169',
                    'U9812',
                    'U76e4',
                    'U86ee',
                    'U5351',
                    'U5983',
                    'U5f7c',
                    'U6249',
                    'U62ab',
                    'U6ccc',
                    'U75b2',
                    'U7891',
                    'U7f77',
                    'U88ab',
                    'U907f',
                    'U5c3e',
                    'U5fae',
                    'U5339',
                    'U59eb',
                    'U6f02',
                    'U63cf',
                    'U82d7',
                    'U6d5c',
                    'U8cd3',
                    'U983b',
                    'U654f',
                    'U74f6',
                    'U6016',
                    'U6276',
                    'U6577',
                    'U666e',
                    'U6d6e',
                    'U7b26',
                    'U8150',
                    'U819a',
                    'U8b5c',
                    'U8ce6',
                    'U8d74',
                    'U9644',
                    'U4fae',
                    'U821e',
                    'U5c01',
                    'U4f0f',
                    'U5e45',
                    'U8986',
                    'U6255',
                    'U6cb8',
                    'U5674',
                    'U58b3',
                    'U61a4',
                    'U7d1b',
                    'U96f0',
                    'U4e19',
                    'U4f75',
                    'U5840',
                    'U5e63',
                    'U5f0a',
                    'U67c4',
                    'U58c1',
                    'U7656',
                    'U504f',
                    'U904d',
                    'U8217',
                    'U6355',
                    'U7a42',
                    'U52df',
                    'U6155',
                    'U7c3f',
                    'U5023',
                    'U4ff8',
                    'U5949',
                    'U5cf0',
                    'U5d29',
                    'U62b1',
                    'U6ce1',
                    'U7832',
                    'U7e2b',
                    'U80de',
                    'U82b3',
                    'U8912',
                    'U90a6',
                    'U98fd',
                    'U4e4f',
                    'U508d',
                    'U5256',
                    'U574a',
                    'U59a8',
                    'U5e3d',
                    'U5fd9',
                    'U623f',
                    'U67d0',
                    'U5192',
                    'U7d21',
                    'U80aa',
                    'U81a8',
                    'U8b00',
                    'U50d5',
                    'U58a8',
                    'U64b2',
                    'U6734',
                    'U6ca1',
                    'U5800',
                    'U5954',
                    'U7ffb',
                    'U51e1',
                    'U76c6',
                    'U6469',
                    'U78e8',
                    'U9b54',
                    'U9ebb',
                    'U57cb',
                    'U819c',
                    'U53c8',
                    'U62b9',
                    'U7e6d',
                    'U6162',
                    'U6f2b',
                    'U9b45',
                    'U5cac',
                    'U5999',
                    'U7720',
                    'U77db',
                    'U9727',
                    'U5a7f',
                    'U5a18',
                    'U9298',
                    'U6ec5',
                    'U514d',
                    'U8302',
                    'U5984',
                    'U731b',
                    'U76f2',
                    'U7db2',
                    'U8017',
                    'U9ed9',
                    'U623b',
                    'U7d0b',
                    'U5301',
                    'U5384',
                    'U8e8d',
                    'U67f3',
                    'U6109',
                    'U7652',
                    'U8aed',
                    'U552f',
                    'U5e7d',
                    'U60a0',
                    'U6182',
                    'U7336',
                    'U88d5',
                    'U8a98',
                    'U96c4',
                    'U878d',
                    'U4e0e',
                    'U8a89',
                    'U5eb8',
                    'U63da',
                    'U63fa',
                    'U64c1',
                    'U6eb6',
                    'U7aaf',
                    'U8b21',
                    'U8e0a',
                    'U6291',
                    'U7ffc',
                    'U7f85',
                    'U88f8',
                    'U983c',
                    'U96f7',
                    'U7d61',
                    'U916a',
                    'U6b04',
                    'U6feb',
                    'U540f',
                    'U5c65',
                    'U75e2',
                    'U96e2',
                    'U786b',
                    'U7c92',
                    'U9686',
                    'U7adc',
                    'U616e',
                    'U865c',
                    'U4e86',
                    'U50da',
                    'U5bee',
                    'U6dbc',
                    'U731f',
                    'U7642',
                    'U7ce7',
                    'U9675',
                    'U502b',
                    'U5398',
                    'U96a3',
                    'U5841',
                    'U6d99',
                    'U7d2f',
                    'U52b1',
                    'U9234',
                    'U96b7',
                    'U96f6',
                    'U970a',
                    'U9e97',
                    'U9f62',
                    'U66a6',
                    'U52a3',
                    'U70c8',
                    'U88c2',
                    'U5ec9',
                    'U604b',
                    'U932c',
                    'U7089',
                    'U9732',
                    'U5eca',
                    'U697c',
                    'U6d6a',
                    'U6f0f',
                    'U90ce',
                    'U8cc4',
                    'U60d1',
                    'U67a0',
                    'U6e7e',
                    'U8155'
                  ],
          'G1' => [
                    'U4e00',
                    'U53f3',
                    'U96e8',
                    'U5186',
                    'U738b',
                    'U97f3',
                    'U4e0b',
                    'U706b',
                    'U82b1',
                    'U8c9d',
                    'U5b66',
                    'U6c17',
                    'U4f11',
                    'U7389',
                    'U91d1',
                    'U4e5d',
                    'U7a7a',
                    'U6708',
                    'U72ac',
                    'U898b',
                    'U4e94',
                    'U53e3',
                    'U6821',
                    'U5de6',
                    'U4e09',
                    'U5c71',
                    'U56db',
                    'U5b50',
                    'U7cf8',
                    'U5b57',
                    'U8033',
                    'U4e03',
                    'U8eca',
                    'U624b',
                    'U5341',
                    'U51fa',
                    'U5973',
                    'U5c0f',
                    'U4e0a',
                    'U68ee',
                    'U4eba',
                    'U6c34',
                    'U6b63',
                    'U751f',
                    'U9752',
                    'U77f3',
                    'U8d64',
                    'U5148',
                    'U5343',
                    'U5ddd',
                    'U65e9',
                    'U8349',
                    'U8db3',
                    'U6751',
                    'U5927',
                    'U7537',
                    'U7af9',
                    'U4e2d',
                    'U866b',
                    'U753a',
                    'U5929',
                    'U7530',
                    'U571f',
                    'U4e8c',
                    'U65e5',
                    'U5165',
                    'U5e74',
                    'U767d',
                    'U516b',
                    'U767e',
                    'U6587',
                    'U672c',
                    'U540d',
                    'U6728',
                    'U76ee',
                    'U5915',
                    'U7acb',
                    'U529b',
                    'U6797',
                    'U516d'
                  ],
          'G2' => [
                    'U5f15',
                    'U7fbd',
                    'U96f2',
                    'U5712',
                    'U9060',
                    'U9ec4',
                    'U4f55',
                    'U590f',
                    'U5bb6',
                    'U79d1',
                    'U6b4c',
                    'U753b',
                    'U4f1a',
                    'U56de',
                    'U6d77',
                    'U7d75',
                    'U5916',
                    'U89d2',
                    'U697d',
                    'U6d3b',
                    'U9593',
                    'U4e38',
                    'U5ca9',
                    'U9854',
                    'U5e30',
                    'U6c7d',
                    'U8a18',
                    'U5f13',
                    'U725b',
                    'U9b5a',
                    'U4eac',
                    'U5f37',
                    'U6559',
                    'U8fd1',
                    'U5144',
                    'U5f62',
                    'U8a08',
                    'U5143',
                    'U539f',
                    'U8a00',
                    'U53e4',
                    'U6238',
                    'U5348',
                    'U5f8c',
                    'U8a9e',
                    'U4ea4',
                    'U5149',
                    'U516c',
                    'U5de5',
                    'U5e83',
                    'U8003',
                    'U884c',
                    'U9ad8',
                    'U5408',
                    'U56fd',
                    'U9ed2',
                    'U4eca',
                    'U624d',
                    'U7d30',
                    'U4f5c',
                    'U7b97',
                    'U59c9',
                    'U5e02',
                    'U601d',
                    'U6b62',
                    'U7d19',
                    'U5bfa',
                    'U6642',
                    'U81ea',
                    'U5ba4',
                    'U793e',
                    'U5f31',
                    'U9996',
                    'U79cb',
                    'U9031',
                    'U6625',
                    'U66f8',
                    'U5c11',
                    'U5834',
                    'U8272',
                    'U98df',
                    'U5fc3',
                    'U65b0',
                    'U89aa',
                    'U56f3',
                    'U6570',
                    'U661f',
                    'U6674',
                    'U58f0',
                    'U897f',
                    'U5207',
                    'U96ea',
                    'U7dda',
                    'U8239',
                    'U524d',
                    'U7d44',
                    'U8d70',
                    'U591a',
                    'U592a',
                    'U4f53',
                    'U53f0',
                    'U8c37',
                    'U77e5',
                    'U5730',
                    'U6c60',
                    'U8336',
                    'U663c',
                    'U671d',
                    'U9577',
                    'U9ce5',
                    'U76f4',
                    'U901a',
                    'U5f1f',
                    'U5e97',
                    'U70b9',
                    'U96fb',
                    'U51ac',
                    'U5200',
                    'U6771',
                    'U5f53',
                    'U7b54',
                    'U982d',
                    'U540c',
                    'U9053',
                    'U8aad',
                    'U5185',
                    'U5357',
                    'U8089',
                    'U99ac',
                    'U8cb7',
                    'U58f2',
                    'U9ea6',
                    'U534a',
                    'U756a',
                    'U7236',
                    'U98a8',
                    'U5206',
                    'U805e',
                    'U7c73',
                    'U6b69',
                    'U6bcd',
                    'U65b9',
                    'U5317',
                    'U59b9',
                    'U6bce',
                    'U4e07',
                    'U660e',
                    'U9cf4',
                    'U6bdb',
                    'U9580',
                    'U591c',
                    'U91ce',
                    'U77e2',
                    'U53cb',
                    'U66dc',
                    'U7528',
                    'U6765',
                    'U7406',
                    'U91cc',
                    'U8a71'
                  ],
          'G9' => [
                    'U963f',
                    'U8475',
                    'U831c',
                    'U6e25',
                    'U65ed',
                    'U6893',
                    'U7d62',
                    'U7dbe',
                    'U9b8e',
                    'U674f',
                    'U4f0a',
                    'U60df',
                    'U4ea5',
                    'U90c1',
                    'U78ef',
                    'U5141',
                    'U80e4',
                    'U536f',
                    'U4e11',
                    'U5504',
                    'U53e1',
                    'U745b',
                    'U8276',
                    'U82d1',
                    'U65bc',
                    'U65fa',
                    'U4f3d',
                    'U5609',
                    'U8304',
                    'U971e',
                    'U9b41',
                    'U51f1',
                    'U99a8',
                    'U53f6',
                    'U6a3a',
                    'U938c',
                    'U8305',
                    'U4f83',
                    'U839e',
                    'U5dcc',
                    'U4f0e',
                    'U5b09',
                    'U6bc5',
                    'U7a00',
                    'U4e80',
                    'U8abc',
                    'U97a0',
                    'U6a58',
                    'U4ea8',
                    'U5321',
                    'U55ac',
                    'U5c2d',
                    'U6850',
                    'U9326',
                    'U6b23',
                    'U6b3d',
                    'U82b9',
                    'U887f',
                    'U7396',
                    'U77e9',
                    'U99d2',
                    'U718a',
                    'U6817',
                    'U8888',
                    'U572d',
                    'U6167',
                    'U6842',
                    'U62f3',
                    'U7d43',
                    'U80e1',
                    'U864e',
                    'U4f0d',
                    'U543e',
                    'U68a7',
                    'U745a',
                    'U9bc9',
                    'U5016',
                    'U5b8f',
                    'U5f18',
                    'U6602',
                    'U6643',
                    'U6d69',
                    'U7d18',
                    'U9d3b',
                    'U5d6f',
                    'U6c99',
                    'U7473',
                    'U88df',
                    'U54c9',
                    'U91c7',
                    'U51b4',
                    'U6714',
                    'U7b39',
                    'U7690',
                    'U71e6',
                    'U723e',
                    'U8494',
                    'U6c50',
                    'U9e7f',
                    'U5072',
                    'U7d17',
                    'U6d32',
                    'U5cfb',
                    'U7ae3',
                    'U821c',
                    'U99ff',
                    'U6df3',
                    'U9187',
                    'U66d9',
                    'U6e1a',
                    'U6055',
                    'U5e84',
                    'U6377',
                    'U660c',
                    'U68a2',
                    'U83d6',
                    'U8549',
                    'U4e1e',
                    'U7a63',
                    'U664b',
                    'U699b',
                    'U79e6',
                    'U9808',
                    'U7fe0',
                    'U745e',
                    'U5d69',
                    'U96db',
                    'U78a9',
                    'U723d',
                    'U60e3',
                    'U7d9c',
                    'U8061',
                    'U84bc',
                    'U6c70',
                    'U9edb',
                    'U9bdb',
                    'U9df9',
                    'U5544',
                    'U7422',
                    'U53ea',
                    'U8fb0',
                    'U5dfd',
                    'U65e6',
                    'U6a80',
                    'U667a',
                    'U732a',
                    'U66a2',
                    'U8776',
                    'U690e',
                    'U69fb',
                    'U8526',
                    'U693f',
                    'U7d2c',
                    'U9db4',
                    'U608c',
                    'U6c40',
                    'U798e',
                    'U675c',
                    'U85e4',
                    'U61a7',
                    'U77b3',
                    'U5bc5',
                    'U9149',
                    'U60c7',
                    'U6566',
                    'U5948',
                    'U90a3',
                    'U51ea',
                    'U637a',
                    'U6960',
                    'U8679',
                    'U4e43',
                    'U4e4b',
                    'U5df4',
                    'U8429',
                    'U8087',
                    'U9ce9',
                    'U96bc',
                    'U6590',
                    'U7dcb',
                    'U7709',
                    'U67ca',
                    'U5f66',
                    'U5a9b',
                    'U5f6a',
                    'U5f6c',
                    'U8299',
                    'U6953',
                    'U8557',
                    'U78a7',
                    'U752b',
                    'U8f14',
                    'U670b',
                    'U840c',
                    'U9cf3',
                    'U9d6c',
                    'U7766',
                    'U69d9',
                    'U67fe',
                    'U4ea6',
                    'U9ebf',
                    'U5df3',
                    'U7a14',
                    'U690b',
                    'U5b5f',
                    'U4e5f',
                    'U51b6',
                    'U8036',
                    'U5f25',
                    'U9756',
                    'U4f51',
                    'U5ba5',
                    'U67da',
                    'U6e67',
                    'U7950',
                    'U9091',
                    'U694a',
                    'U8000',
                    'U84c9',
                    'U9065',
                    'U5d50',
                    'U85cd',
                    'U862d',
                    'U674e',
                    'U68a8',
                    'U7483',
                    'U7409',
                    'U4eae',
                    'U51cc',
                    'U77ad',
                    'U7a1c',
                    'U8ad2',
                    'U907c',
                    'U7433',
                    'U9e9f',
                    'U7460',
                    'U4f36',
                    'U5dba',
                    'U601c',
                    'U73b2',
                    'U84ee',
                    'U5442',
                    'U7984',
                    'U502d',
                    'U4e98',
                    'U4f91',
                    'U52c1',
                    'U594e',
                    'U5d1a',
                    'U5f57',
                    'U6634',
                    'U664f',
                    'U6668',
                    'U665f',
                    'U6689',
                    'U681e',
                    'U6930',
                    'U6bec',
                    'U6d38',
                    'U6d35',
                    'U6ec9',
                    'U6f31',
                    'U6faa',
                    'U71ce',
                    'U71ff',
                    'U7476',
                    'U7693',
                    'U7738',
                    'U7b19',
                    'U7dba',
                    'U7db8',
                    'U7fd4',
                    'U8129',
                    'U8309',
                    'U8389',
                    'U83eb',
                    'U8a62',
                    'U8ac4',
                    'U8d73',
                    'U8fea',
                    'U980c',
                    'U98af',
                    'U9ece',
                    'U51dc',
                    'U7199'
                  ],
          'G3' => [
                    'U60aa',
                    'U5b89',
                    'U6697',
                    'U59d4',
                    'U610f',
                    'U533b',
                    'U80b2',
                    'U54e1',
                    'U98f2',
                    'U9662',
                    'U904b',
                    'U6cf3',
                    'U99c5',
                    'U592e',
                    'U6a2a',
                    'U5c4b',
                    'U6e29',
                    'U5316',
                    'U8377',
                    'U754c',
                    'U958b',
                    'U968e',
                    'U5bd2',
                    'U611f',
                    'U6f22',
                    'U9928',
                    'U5cb8',
                    'U671f',
                    'U8d77',
                    'U5ba2',
                    'U5bae',
                    'U6025',
                    'U7403',
                    'U7a76',
                    'U7d1a',
                    'U53bb',
                    'U6a4b',
                    'U696d',
                    'U5c40',
                    'U66f2',
                    'U9280',
                    'U533a',
                    'U82e6',
                    'U5177',
                    'U541b',
                    'U4fc2',
                    'U8efd',
                    'U6c7a',
                    'U8840',
                    'U7814',
                    'U770c',
                    'U5eab',
                    'U6e56',
                    'U5411',
                    'U5e78',
                    'U6e2f',
                    'U53f7',
                    'U6839',
                    'U796d',
                    'U5742',
                    'U76bf',
                    'U4ed5',
                    'U4f7f',
                    'U59cb',
                    'U6307',
                    'U6b7b',
                    'U8a69',
                    'U6b6f',
                    'U4e8b',
                    'U6301',
                    'U6b21',
                    'U5f0f',
                    'U5b9f',
                    'U5199',
                    'U8005',
                    'U4e3b',
                    'U53d6',
                    'U5b88',
                    'U9152',
                    'U53d7',
                    'U5dde',
                    'U62fe',
                    'U7d42',
                    'U7fd2',
                    'U96c6',
                    'U4f4f',
                    'U91cd',
                    'U5bbf',
                    'U6240',
                    'U6691',
                    'U52a9',
                    'U52dd',
                    'U5546',
                    'U662d',
                    'U6d88',
                    'U7ae0',
                    'U4e57',
                    'U690d',
                    'U6df1',
                    'U7533',
                    'U771f',
                    'U795e',
                    'U8eab',
                    'U9032',
                    'U4e16',
                    'U6574',
                    'U6614',
                    'U5168',
                    'U60f3',
                    'U76f8',
                    'U9001',
                    'U606f',
                    'U901f',
                    'U65cf',
                    'U4ed6',
                    'U6253',
                    'U5bfe',
                    'U5f85',
                    'U4ee3',
                    'U7b2c',
                    'U984c',
                    'U70ad',
                    'U77ed',
                    'U8ac7',
                    'U7740',
                    'U67f1',
                    'U6ce8',
                    'U4e01',
                    'U5e33',
                    'U8abf',
                    'U8ffd',
                    'U5b9a',
                    'U5ead',
                    'U7b1b',
                    'U9244',
                    'U8ee2',
                    'U767b',
                    'U90fd',
                    'U5ea6',
                    'U5cf6',
                    'U6295',
                    'U6e6f',
                    'U7b49',
                    'U8c46',
                    'U52d5',
                    'U7ae5',
                    'U8fb2',
                    'U6ce2',
                    'U914d',
                    'U500d',
                    'U7bb1',
                    'U7551',
                    'U767a',
                    'U53cd',
                    'U677f',
                    'U60b2',
                    'U76ae',
                    'U7f8e',
                    'U9f3b',
                    'U7b46',
                    'U6c37',
                    'U8868',
                    'U75c5',
                    'U79d2',
                    'U54c1',
                    'U8ca0',
                    'U90e8',
                    'U670d',
                    'U798f',
                    'U7269',
                    'U5e73',
                    'U8fd4',
                    'U52c9',
                    'U653e',
                    'U5473',
                    'U547d',
                    'U9762',
                    'U554f',
                    'U5f79',
                    'U85ac',
                    'U6cb9',
                    'U6709',
                    'U7531',
                    'U904a',
                    'U4e88',
                    'U69d8',
                    'U6d0b',
                    'U7f8a',
                    'U8449',
                    'U967d',
                    'U843d',
                    'U6d41',
                    'U65c5',
                    'U4e21',
                    'U7dd1',
                    'U793c',
                    'U5217',
                    'U7df4',
                    'U8def',
                    'U548c'
                  ],
          'G4' => [
                    'U611b',
                    'U6848',
                    'U4ee5',
                    'U4f4d',
                    'U56f2',
                    'U80c3',
                    'U8863',
                    'U5370',
                    'U6804',
                    'U82f1',
                    'U5869',
                    'U5104',
                    'U52a0',
                    'U679c',
                    'U8ab2',
                    'U8ca8',
                    'U82bd',
                    'U6539',
                    'U68b0',
                    'U5bb3',
                    'U8857',
                    'U5404',
                    'U899a',
                    'U5b8c',
                    'U5b98',
                    'U7ba1',
                    'U89b3',
                    'U95a2',
                    'U9858',
                    'U559c',
                    'U5668',
                    'U5e0c',
                    'U65d7',
                    'U6a5f',
                    'U5b63',
                    'U7d00',
                    'U8b70',
                    'U6551',
                    'U6c42',
                    'U6ce3',
                    'U7d66',
                    'U6319',
                    'U6f01',
                    'U7af6',
                    'U5171',
                    'U5354',
                    'U93e1',
                    'U6975',
                    'U8a13',
                    'U8ecd',
                    'U90e1',
                    'U578b',
                    'U5f84',
                    'U666f',
                    'U82b8',
                    'U6b20',
                    'U7d50',
                    'U5065',
                    'U5efa',
                    'U9a13',
                    'U56fa',
                    'U5019',
                    'U529f',
                    'U597d',
                    'U5eb7',
                    'U822a',
                    'U544a',
                    'U5dee',
                    'U6700',
                    'U83dc',
                    'U6750',
                    'U6628',
                    'U5237',
                    'U5bdf',
                    'U672d',
                    'U6bba',
                    'U53c2',
                    'U6563',
                    'U7523',
                    'U6b8b',
                    'U53f8',
                    'U53f2',
                    'U58eb',
                    'U6c0f',
                    'U8a66',
                    'U5150',
                    'U6cbb',
                    'U8f9e',
                    'U5931',
                    'U501f',
                    'U7a2e',
                    'U5468',
                    'U795d',
                    'U9806',
                    'U521d',
                    'U5531',
                    'U677e',
                    'U713c',
                    'U7167',
                    'U7701',
                    'U7b11',
                    'U8c61',
                    'U8cde',
                    'U4fe1',
                    'U81e3',
                    'U6210',
                    'U6e05',
                    'U9759',
                    'U5e2d',
                    'U7a4d',
                    'U6298',
                    'U7bc0',
                    'U8aac',
                    'U6226',
                    'U6d45',
                    'U9078',
                    'U7136',
                    'U5009',
                    'U5de3',
                    'U4e89',
                    'U5074',
                    'U675f',
                    'U7d9a',
                    'U5352',
                    'U5b6b',
                    'U5e2f',
                    'U968a',
                    'U9054',
                    'U5358',
                    'U7f6e',
                    'U4ef2',
                    'U8caf',
                    'U5146',
                    'U8178',
                    'U4f4e',
                    'U505c',
                    'U5e95',
                    'U7684',
                    'U5178',
                    'U4f1d',
                    'U5f92',
                    'U52aa',
                    'U706f',
                    'U50cd',
                    'U5802',
                    'U5f97',
                    'U7279',
                    'U6bd2',
                    'U71b1',
                    'U5ff5',
                    'U6557',
                    'U6885',
                    'U535a',
                    'U98ef',
                    'U8cbb',
                    'U98db',
                    'U5fc5',
                    'U6a19',
                    'U7968',
                    'U4e0d',
                    'U4ed8',
                    'U592b',
                    'U5e9c',
                    'U526f',
                    'U7c89',
                    'U5175',
                    'U5225',
                    'U5909',
                    'U8fba',
                    'U4fbf',
                    'U5305',
                    'U6cd5',
                    'U671b',
                    'U7267',
                    'U672b',
                    'U6e80',
                    'U672a',
                    'U8108',
                    'U6c11',
                    'U7121',
                    'U7d04',
                    'U52c7',
                    'U8981',
                    'U990a',
                    'U6d74',
                    'U5229',
                    'U9678',
                    'U6599',
                    'U826f',
                    'U91cf',
                    'U8f2a',
                    'U985e',
                    'U4ee4',
                    'U4f8b',
                    'U51b7',
                    'U6b74',
                    'U9023',
                    'U52b4',
                    'U8001',
                    'U9332'
                  ],
          'G5' => [
                    'U5727',
                    'U6613',
                    'U79fb',
                    'U56e0',
                    'U55b6',
                    'U6c38',
                    'U885b',
                    'U6db2',
                    'U76ca',
                    'U6f14',
                    'U5f80',
                    'U5fdc',
                    'U6069',
                    'U4eee',
                    'U4fa1',
                    'U53ef',
                    'U6cb3',
                    'U904e',
                    'U8cc0',
                    'U89e3',
                    'U5feb',
                    'U683c',
                    'U78ba',
                    'U984d',
                    'U520a',
                    'U5e79',
                    'U6163',
                    'U773c',
                    'U57fa',
                    'U5bc4',
                    'U898f',
                    'U6280',
                    'U7fa9',
                    'U9006',
                    'U4e45',
                    'U65e7',
                    'U5c45',
                    'U8a31',
                    'U5883',
                    'U8208',
                    'U5747',
                    'U7981',
                    'U53e5',
                    'U7fa4',
                    'U7d4c',
                    'U6f54',
                    'U4ef6',
                    'U5238',
                    'U691c',
                    'U967a',
                    'U6e1b',
                    'U73fe',
                    'U9650',
                    'U500b',
                    'U6545',
                    'U8b77',
                    'U52b9',
                    'U539a',
                    'U69cb',
                    'U8015',
                    'U8b1b',
                    'U9271',
                    'U6df7',
                    'U67fb',
                    'U518d',
                    'U59bb',
                    'U63a1',
                    'U707d',
                    'U969b',
                    'U5728',
                    'U7f6a',
                    'U8ca1',
                    'U685c',
                    'U96d1',
                    'U8cdb',
                    'U9178',
                    'U5e2b',
                    'U5fd7',
                    'U652f',
                    'U679d',
                    'U8cc7',
                    'U98fc',
                    'U4f3c',
                    'U793a',
                    'U8b58',
                    'U8cea',
                    'U820e',
                    'U8b1d',
                    'U6388',
                    'U4fee',
                    'U8853',
                    'U8ff0',
                    'U6e96',
                    'U5e8f',
                    'U627f',
                    'U62db',
                    'U8a3c',
                    'U5e38',
                    'U60c5',
                    'U6761',
                    'U72b6',
                    'U7e54',
                    'U8077',
                    'U5236',
                    'U52e2',
                    'U6027',
                    'U653f',
                    'U7cbe',
                    'U88fd',
                    'U7a0e',
                    'U7e3e',
                    'U8cac',
                    'U63a5',
                    'U8a2d',
                    'U7d76',
                    'U820c',
                    'U92ad',
                    'U7956',
                    'U7d20',
                    'U7dcf',
                    'U50cf',
                    'U5897',
                    'U9020',
                    'U5247',
                    'U6e2c',
                    'U5c5e',
                    'U640d',
                    'U614b',
                    'U8cb8',
                    'U9000',
                    'U56e3',
                    'U65ad',
                    'U7bc9',
                    'U5f35',
                    'U63d0',
                    'U7a0b',
                    'U6575',
                    'U9069',
                    'U7d71',
                    'U5c0e',
                    'U9285',
                    'U5fb3',
                    'U72ec',
                    'U4efb',
                    'U71c3',
                    'U80fd',
                    'U7834',
                    'U5224',
                    'U7248',
                    'U72af',
                    'U6bd4',
                    'U80a5',
                    'U975e',
                    'U5099',
                    'U4ff5',
                    'U8a55',
                    'U8ca7',
                    'U5a66',
                    'U5bcc',
                    'U5e03',
                    'U6b66',
                    'U5fa9',
                    'U8907',
                    'U4ecf',
                    'U7de8',
                    'U5f01',
                    'U4fdd',
                    'U5893',
                    'U5831',
                    'U8c4a',
                    'U66b4',
                    'U8cbf',
                    'U9632',
                    'U52d9',
                    'U5922',
                    'U8ff7',
                    'U7dbf',
                    'U8f38',
                    'U4f59',
                    'U9810',
                    'U5bb9',
                    'U7387',
                    'U7565',
                    'U7559',
                    'U9818'
                  ],
          'G6' => [
                    'U7570',
                    'U907a',
                    'U57df',
                    'U5b87',
                    'U6620',
                    'U5ef6',
                    'U6cbf',
                    'U6211',
                    'U7070',
                    'U62e1',
                    'U95a3',
                    'U9769',
                    'U5272',
                    'U682a',
                    'U5dfb',
                    'U5e72',
                    'U770b',
                    'U7c21',
                    'U5371',
                    'U63ee',
                    'U673a',
                    'U8cb4',
                    'U7591',
                    'U5438',
                    'U4f9b',
                    'U80f8',
                    'U90f7',
                    'U52e4',
                    'U7b4b',
                    'U656c',
                    'U7cfb',
                    'U8b66',
                    'U5287',
                    'U6fc0',
                    'U7a74',
                    'U61b2',
                    'U6a29',
                    'U7d79',
                    'U53b3',
                    'U6e90',
                    'U547c',
                    'U5df1',
                    'U8aa4',
                    'U540e',
                    'U5b5d',
                    'U7687',
                    'U7d05',
                    'U92fc',
                    'U964d',
                    'U523b',
                    'U7a40',
                    'U9aa8',
                    'U56f0',
                    'U7802',
                    'U5ea7',
                    'U6e08',
                    'U88c1',
                    'U7b56',
                    'U518a',
                    'U8695',
                    'U59ff',
                    'U79c1',
                    'U81f3',
                    'U8996',
                    'U8a5e',
                    'U8a8c',
                    'U78c1',
                    'U5c04',
                    'U6368',
                    'U5c3a',
                    'U82e5',
                    'U6a39',
                    'U53ce',
                    'U5b97',
                    'U5c31',
                    'U8846',
                    'U5f93',
                    'U7e26',
                    'U7e2e',
                    'U719f',
                    'U7d14',
                    'U51e6',
                    'U7f72',
                    'U8af8',
                    'U9664',
                    'U50b7',
                    'U5c06',
                    'U969c',
                    'U57ce',
                    'U84b8',
                    'U91dd',
                    'U4ec1',
                    'U5782',
                    'U63a8',
                    'U5bf8',
                    'U76db',
                    'U8056',
                    'U8aa0',
                    'U5ba3',
                    'U5c02',
                    'U6cc9',
                    'U6d17',
                    'U67d3',
                    'U5584',
                    'U5275',
                    'U594f',
                    'U5c64',
                    'U64cd',
                    'U7a93',
                    'U88c5',
                    'U81d3',
                    'U8535',
                    'U5b58',
                    'U5c0a',
                    'U5b85',
                    'U62c5',
                    'U63a2',
                    'U8a95',
                    'U6696',
                    'U6bb5',
                    'U5024',
                    'U5b99',
                    'U5fe0',
                    'U8457',
                    'U5e81',
                    'U6f6e',
                    'U9802',
                    'U8cc3',
                    'U75db',
                    'U5c55',
                    'U515a',
                    'U7cd6',
                    'U8a0e',
                    'U5c4a',
                    'U96e3',
                    'U4e73',
                    'U8a8d',
                    'U7d0d',
                    'U8133',
                    'U6d3e',
                    'U4ff3',
                    'U62dd',
                    'U80cc',
                    'U80ba',
                    'U73ed',
                    'U6669',
                    'U5426',
                    'U6279',
                    'U79d8',
                    'U8179',
                    'U596e',
                    'U4e26',
                    'U9589',
                    'U965b',
                    'U7247',
                    'U88dc',
                    'U66ae',
                    'U5b9d',
                    'U8a2a',
                    'U4ea1',
                    'U5fd8',
                    'U68d2',
                    'U679a',
                    'U5e55',
                    'U5bc6',
                    'U76df',
                    'U6a21',
                    'U8a33',
                    'U512a',
                    'U90f5',
                    'U5e7c',
                    'U6b32',
                    'U7fcc',
                    'U4e71',
                    'U5375',
                    'U89a7',
                    'U88cf',
                    'U5f8b',
                    'U81e8',
                    'U6717',
                    'U8ad6'
                  ]
        );

my %chars;

if (defined($ARGV[0])) {
	print "$ARGV[0]\n";
	if ($ARGV[0] =~ /^G[1-9]$/) {
		print "Valid Grade\n";
	} else {
		print "Invalid Grade\n";
		exit(0);
	}

	my $i_temp;
	my $count = @{$grades{$ARGV[0]}};
	while (keys(%chars) < 42) {
		my $j_temp = int(rand($count)); 
		if (!defined($chars{$j_temp})) {
			my $s_temp = $grades{$ARGV[0]}->[$j_temp];
			$s_temp =~ s/^U([0-9a-f]{4})/0x$1/;
			$chars{$j_temp} = $s_temp;
		}
	}

	my $i_key;
	my @s_temp;
	foreach $i_key(keys(%chars)) {
		push(@s_temp, hex($chars{$i_key}));
	}

	foreach $i_key(keys(%chars)) {
		push(@s_temp, hex($chars{$i_key}));
	}

	my $colors = [
	undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,
	undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,undef,
	"0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff","0xff00ff"
	];
	
	$retval = render_table (40, 56, 4, 21, \@s_temp, $colors, 0x1c000, 0x1c000);
	
	if (defined($retval->{'ok'})) {
		$retval = bitmap_as_xpm($retval);
		if (defined($retval)) {
			open (OUTPUT, '> temp.xpm');
		        print OUTPUT $retval;
			close (OUTPUT);
			print "SUCCESS!\n";
		} else {
			print "FAILURE!  Unable to convert bitmap to xpm\n";
		}
	} else {
		print "FAILURE!  Unable to render bitmap\n";
	}

} else {
	print "No Options given!\n";
}
